/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.processor.DelegateSyncProcessor;
import org.apache.camel.spi.Required;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="process")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ProcessDefinition
extends NoOutputDefinition<ProcessDefinition> {
    @XmlAttribute(required=true)
    private String ref;
    @XmlTransient
    private Processor processor;

    public ProcessDefinition() {
    }

    public ProcessDefinition(Processor processor) {
        this.processor = processor;
    }

    @Override
    public String getShortName() {
        return "process";
    }

    public String toString() {
        return "process[" + (this.ref != null ? "ref:" + this.ref : this.processor) + "]";
    }

    @Override
    public String getLabel() {
        if (this.ref != null) {
            return "ref:" + this.ref;
        }
        if (this.processor != null) {
            return this.processor.toString();
        }
        return "";
    }

    public String getRef() {
        return this.ref;
    }

    @Required
    public void setRef(String ref) {
        this.ref = ref;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) {
        Processor answer = this.processor;
        if (this.processor == null) {
            ObjectHelper.notNull(this.ref, "ref", this);
            answer = routeContext.mandatoryLookup(this.getRef(), Processor.class);
        }
        if (!(answer instanceof Service)) {
            answer = answer instanceof AsyncProcessor ? new DelegateAsyncProcessor(answer) : new DelegateSyncProcessor(answer);
        }
        return answer;
    }
}

