/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedThrottlerMBean;
import org.apache.camel.builder.Builder;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.Throttler;

@ManagedResource(description="Managed Throttler")
public class ManagedThrottler
extends ManagedProcessor
implements ManagedThrottlerMBean {
    private final Throttler throttler;

    public ManagedThrottler(CamelContext context, Throttler throttler, ProcessorDefinition<?> definition) {
        super(context, throttler, definition);
        this.throttler = throttler;
    }

    public Throttler getThrottler() {
        return this.throttler;
    }

    @Override
    public long getMaximumRequestsPerPeriod() {
        return this.getThrottler().getCurrentMaximumRequestsPerPeriod();
    }

    @Override
    public void setMaximumRequestsPerPeriod(long maximumRequestsPerPeriod) {
        this.getThrottler().setMaximumRequestsPerPeriodExpression(Builder.constant(maximumRequestsPerPeriod));
    }

    @Override
    public long getTimePeriodMillis() {
        return this.getThrottler().getTimePeriodMillis();
    }

    @Override
    public void setTimePeriodMillis(long timePeriodMillis) {
        this.getThrottler().setTimePeriodMillis(timePeriodMillis);
    }

    @Override
    public int getThrottledCount() {
        return this.getThrottler().getDelayedCount();
    }
}

