/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.NotificationSenderAware;
import org.apache.camel.management.MBeanInfoAssembler;
import org.apache.camel.management.MaskRequiredModelMBean;
import org.apache.camel.management.NotificationSenderAdapter;
import org.apache.camel.spi.ManagementMBeanAssembler;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultManagementMBeanAssembler
implements ManagementMBeanAssembler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultManagementMBeanAssembler.class);
    protected final MBeanInfoAssembler assembler;
    protected final CamelContext camelContext;

    public DefaultManagementMBeanAssembler(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.assembler = new MBeanInfoAssembler(camelContext);
    }

    @Override
    public ModelMBean assemble(MBeanServer mBeanServer, Object obj, ObjectName name) throws JMException {
        RequiredModelMBean mbean;
        boolean sanitize;
        Object custom;
        ModelMBeanInfo mbi = null;
        if (obj instanceof ManagedInstance && (custom = ((ManagedInstance)obj).getInstance()) != null && ObjectHelper.hasAnnotation(custom.getClass().getAnnotations(), ManagedResource.class)) {
            LOG.trace("Assembling MBeanInfo for: {} from custom @ManagedResource object: {}", (Object)name, custom);
            mbi = this.assembler.getMBeanInfo(null, custom, name.toString());
            obj = custom;
        }
        if (mbi == null) {
            LOG.trace("Assembling MBeanInfo for: {} from @ManagedResource object: {}", (Object)name, obj);
            mbi = this.assembler.getMBeanInfo(obj, null, name.toString());
        }
        if (mbi == null) {
            return null;
        }
        boolean bl = sanitize = this.camelContext.getManagementStrategy().getManagementAgent().getMask() != null && this.camelContext.getManagementStrategy().getManagementAgent().getMask() != false;
        if (sanitize) {
            mbean = new MaskRequiredModelMBean(mbi, sanitize);
        } else {
            mbean = (RequiredModelMBean)mBeanServer.instantiate(RequiredModelMBean.class.getName());
            mbean.setModelMBeanInfo(mbi);
        }
        try {
            mbean.setManagedResource(obj, "ObjectReference");
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new JMException(e.getMessage());
        }
        if (obj instanceof NotificationSenderAware) {
            ((NotificationSenderAware)obj).setNotificationSender(new NotificationSenderAdapter(mbean));
        }
        return mbean;
    }
}

