/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.ManagementNameStrategy;
import org.apache.camel.util.ObjectHelper;

public class DefaultManagementNameStrategy
implements ManagementNameStrategy {
    private static final Pattern INVALID_PATTERN = Pattern.compile(".*#\\w+#.*");
    private static final AtomicLong NAME_COUNTER = new AtomicLong();
    private final CamelContext camelContext;
    private final String defaultPattern;
    private final String nextPattern;
    private String name;
    private String namePattern;

    public DefaultManagementNameStrategy(CamelContext camelContext) {
        this(camelContext, "#name#", "#name#-#counter#");
    }

    public DefaultManagementNameStrategy(CamelContext camelContext, String defaultPattern, String nextPattern) {
        this.camelContext = camelContext;
        this.defaultPattern = defaultPattern;
        this.nextPattern = nextPattern;
    }

    @Override
    public String getNamePattern() {
        return this.namePattern;
    }

    @Override
    public void setNamePattern(String namePattern) {
        this.namePattern = namePattern;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            String pattern = this.getNamePattern();
            if (pattern == null) {
                pattern = this.defaultPattern;
            }
            this.name = this.resolveManagementName(pattern, this.camelContext.getName(), true);
        }
        return this.name;
    }

    @Override
    public String getNextName() {
        if (this.isFixedName()) {
            return this.getName();
        }
        String pattern = this.getNamePattern();
        if (pattern == null) {
            pattern = this.nextPattern;
        }
        return this.resolveManagementName(pattern, this.camelContext.getName(), true);
    }

    @Override
    public boolean isFixedName() {
        String pattern = this.getNamePattern();
        if (pattern == null) {
            return false;
        }
        return !pattern.contains("#counter#");
    }

    @Override
    public String resolveManagementName(String pattern, String name, boolean invalidCheck) {
        ObjectHelper.notEmpty(pattern, "pattern");
        ObjectHelper.notEmpty(name, "name");
        name = Matcher.quoteReplacement(name);
        String answer = pattern;
        if (pattern.contains("#counter#")) {
            answer = pattern.replaceFirst("#counter#", "" + DefaultManagementNameStrategy.nextNameCounter());
        }
        answer = answer.replaceFirst("#camelId#", name);
        answer = answer.replaceFirst("#name#", name);
        answer = this.customResolveManagementName(pattern, answer);
        if (invalidCheck && INVALID_PATTERN.matcher(answer).matches()) {
            throw new IllegalArgumentException("Pattern is invalid: " + pattern);
        }
        return answer;
    }

    protected String customResolveManagementName(String pattern, String answer) {
        return answer;
    }

    private static long nextNameCounter() {
        return NAME_COUNTER.incrementAndGet();
    }

    public static void setCounter(int value) {
        NAME_COUNTER.set(value);
    }
}

