/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.transport.MutexTransport;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.amqp.AmqpTransportFilter;
import org.apache.activemq.transport.tcp.TcpTransportFactory;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.wireformat.WireFormat;

public class AmqpTransportFactory
extends TcpTransportFactory
implements BrokerServiceAware {
    private BrokerContext brokerContext = null;

    @Override
    protected String getDefaultWireFormatType() {
        return "amqp";
    }

    @Override
    public Transport compositeConfigure(Transport transport, WireFormat format2, Map options) {
        transport = new AmqpTransportFilter(transport, format2, this.brokerContext);
        IntrospectionSupport.setProperties(transport, options);
        return super.compositeConfigure(transport, format2, options);
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerContext = brokerService.getBrokerContext();
    }

    @Override
    public Transport serverConfigure(Transport transport, WireFormat format2, HashMap options) throws Exception {
        if ((transport = super.serverConfigure(transport, format2, options)) instanceof MutexTransport) {
            transport = ((MutexTransport)transport).getNext();
        }
        return transport;
    }

    @Override
    protected boolean isUseInactivityMonitor(Transport transport) {
        return false;
    }
}

