/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.hooks.osgi;

import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;

public class SpringOsgiContextHook
implements Runnable,
ApplicationContextAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(SpringOsgiContextHook.class);
    ApplicationContext applicationContext;

    @Override
    public void run() {
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.applicationContext).close();
        }
        if (this.applicationContext instanceof OsgiBundleXmlApplicationContext) {
            try {
                ((OsgiBundleXmlApplicationContext)this.applicationContext).getBundle().stop();
            }
            catch (BundleException e) {
                LOG.info("Error stopping OSGi bundle " + (Object)((Object)e), e);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

