/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.ImageStream;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.graphics.CachedImageReference;
import org.icepdf.core.pobjects.graphics.ImagePool;
import org.icepdf.core.pobjects.graphics.ImageReference;
import org.icepdf.core.util.Library;

public class ScaledImageReference
extends CachedImageReference {
    private static final Logger logger = Logger.getLogger(ScaledImageReference.class.toString());
    private int width;
    private int height;

    protected ScaledImageReference(ImageStream imageStream, Color fillColor, Resources resources) {
        super(imageStream, fillColor, resources);
        int width = imageStream.getWidth();
        int height = imageStream.getHeight();
        double scaleFactor = 1.0;
        if (width > 1000 && width < 1500) {
            scaleFactor = 0.75;
        } else if (width > 1500) {
            scaleFactor = 0.5;
        }
        if (scaleFactor < 1.0) {
            this.width = (int)Math.ceil((double)width * scaleFactor);
            this.height = (int)Math.ceil((double)height * scaleFactor);
        } else {
            this.width = width;
            this.height = height;
        }
        ImagePool imagePool = imageStream.getLibrary().getImagePool();
        if (useProxy && imagePool.get(this.reference) == null) {
            this.futureTask = new FutureTask<BufferedImage>(this);
            Library.executeImage(this.futureTask);
        } else if (!useProxy && imagePool.get(this.reference) == null) {
            this.image = this.call();
        }
    }

    public ScaledImageReference(ImageReference imageReference, Color fillColor, Resources resources, int width, int height) {
        super(imageReference.getImageStream(), fillColor, resources);
        this.width = width;
        this.height = height;
        if (imageReference.isImage()) {
            this.image = imageReference.getImage();
        }
        ImagePool imagePool = this.imageStream.getLibrary().getImagePool();
        if (useProxy && imagePool.get(this.reference) == null) {
            this.futureTask = new FutureTask<BufferedImage>(this);
            Library.executeImage(this.futureTask);
        } else if (!useProxy && imagePool.get(this.reference) == null) {
            this.image = this.call();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public BufferedImage call() {
        BufferedImage image = null;
        try {
            if (image == null) {
                image = this.imageStream.getImage(this.fillColor, this.resources);
            }
            if (image != null) {
                int width = image.getWidth();
                int height = image.getHeight();
                if (width != this.width || height != this.height) {
                    ColorModel colorModel = image.getColorModel();
                    BufferedImage scaled = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(this.width, this.height), image.isAlphaPremultiplied(), null);
                    Graphics2D g = scaled.createGraphics();
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    g.drawImage(image, 0, 0, this.width, this.height, null);
                    g.dispose();
                    image = scaled;
                }
            }
        }
        catch (Throwable e) {
            logger.warning("Error loading image: " + this.imageStream.getPObjectReference() + " " + this.imageStream.toString());
        }
        return image;
    }
}

