/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.security.SecureSessionPool;
import fi.csc.microarray.util.BitTwiddling;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SecureSessionPoolTest {
    @Before
    public void init() throws IOException, ConfigurationLoader.IllegalConfigurationException {
        DirectoryLayout.uninitialise();
        DirectoryLayout.initialiseServerLayout(Arrays.asList("auth"));
    }

    @Test
    public void testBasicUsage() {
        SecureSessionPool ssp = new SecureSessionPool();
        SecureSessionPool.Session session = ssp.createSession();
        session.putParameter("one", (Object)1);
        session.putParameter("two", (Object)2);
        String id = session.getID();
        SecureSessionPool.Session reloadedSession = ssp.getSession(id);
        Assert.assertTrue(((Integer)reloadedSession.getParameter("one") == 1 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)reloadedSession.getParameter("two") == 2 ? 1 : 0) != 0);
        ssp.removeSession(reloadedSession);
        Assert.assertTrue((ssp.getSession(reloadedSession.getID()) == null ? 1 : 0) != 0);
    }

    @Test
    public void testKeyRandomness() {
        SecureSessionPool ssp = new SecureSessionPool();
        int valCount = 1000;
        HashSet<Long> numbers = new HashSet<Long>();
        for (int i = 0; i < 1000; ++i) {
            UUID id = UUID.fromString(ssp.createSession().getID());
            long xorredValue = id.getLeastSignificantBits() ^ id.getMostSignificantBits();
            Assert.assertFalse((String)"duplicate key generated", (boolean)numbers.contains(xorredValue));
            numbers.add(xorredValue);
        }
        int[] bitCounts = BitTwiddling.calculateBitFrequencies(numbers);
        long average = 500L;
        long allowedError = 100L;
        long allowedErrorInAvg = 10L;
        long sum = 0L;
        for (int i = 0; i < bitCounts.length; ++i) {
            int count = bitCounts[i];
            sum += (long)count;
            Assert.assertTrue((String)("bit count too far from theoretical average: " + count), ((long)BigInteger.valueOf((long)count - 500L).abs().intValue() < 100L ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)"average too far from theoretical average", ((long)BigInteger.valueOf(sum / 64L - 500L).abs().intValue() < 10L ? 1 : 0) != 0);
    }
}

