/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.util.BitTwiddling;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;

public class BitTwiddlingTest {
    @Test
    public void testByteConversions() {
        int i;
        for (i = 0; i < 1000; ++i) {
            int original = (int)UUID.randomUUID().getLeastSignificantBits();
            int converted = BitTwiddling.bytesToInt(BitTwiddling.intToBytes(original));
            Assert.assertTrue((String)("comparing 0x" + Integer.toHexString(original) + " and 0x" + Integer.toHexString(converted)), (original == converted ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            byte[] original = new byte[4];
            for (int c = 0; c < original.length; ++c) {
                original[c] = (byte)UUID.randomUUID().getLeastSignificantBits();
            }
            byte[] converted = BitTwiddling.intToBytes(BitTwiddling.bytesToInt(original));
            for (int c = 0; c < original.length; ++c) {
                Assert.assertTrue((String)("comparing " + original[c] + " and " + converted[c]), (original[c] == converted[c] ? 1 : 0) != 0);
            }
        }
    }

    public static void main(String[] args) {
        int i = -459594509;
        byte[] b = BitTwiddling.intToBytes(i);
        int i2 = BitTwiddling.bytesToInt(b);
        System.out.println(Integer.toHexString(i) + " and " + Integer.toHexString(i2));
    }
}

