/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Binding;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import org.sonatype.guice.bean.locators.LazyBeanEntry;
import org.sonatype.guice.bean.locators.QualifyingStrategy;
import org.sonatype.guice.bean.locators.spi.BindingDistributor;
import org.sonatype.guice.bean.locators.spi.BindingPublisher;
import org.sonatype.guice.bean.locators.spi.BindingSubscriber;
import org.sonatype.guice.bean.reflect.Logs;
import org.sonatype.inject.BeanEntry;
import org.sonatype.inject.Mediator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WatchedBeans<Q extends Annotation, T, W>
implements BindingDistributor,
BindingSubscriber {
    private final Map<Binding<T>, BeanEntry<Q, T>> beanCache = new IdentityHashMap<Binding<T>, BeanEntry<Q, T>>();
    private final Key<T> key;
    private final Mediator<Q, T, W> mediator;
    private final QualifyingStrategy strategy;
    private final Reference<W> watcherRef;

    WatchedBeans(Key<T> key, Mediator<Q, T, W> mediator, W watcher) {
        this.key = key;
        this.mediator = mediator;
        this.strategy = QualifyingStrategy.selectFor(key);
        this.watcherRef = new WeakReference<W>(watcher);
    }

    @Override
    public synchronized void add(BindingPublisher publisher, int rank) {
        publisher.subscribe(this.key.getTypeLiteral(), this);
    }

    @Override
    public synchronized void remove(BindingPublisher publisher) {
        publisher.unsubscribe(this.key.getTypeLiteral(), this);
        for (Binding<T> b : new ArrayList<Binding<T>>(this.beanCache.keySet())) {
            if (!publisher.contains(b)) continue;
            this.notify(WatcherEvent.REMOVE, this.beanCache.remove(b));
        }
    }

    public synchronized void add(Binding binding, int rank) {
        Annotation qualifier = this.strategy.qualifies(this.key, binding);
        if (null != qualifier) {
            LazyBeanEntry bean = new LazyBeanEntry(qualifier, binding, rank);
            this.beanCache.put(binding, bean);
            this.notify(WatcherEvent.ADD, bean);
        }
    }

    public synchronized void remove(Binding binding) {
        BeanEntry<Q, T> bean = this.beanCache.remove(binding);
        if (null != bean) {
            this.notify(WatcherEvent.REMOVE, bean);
        }
    }

    @Override
    public synchronized void clear() {
        for (BeanEntry<Q, T> bean : this.beanCache.values()) {
            this.notify(WatcherEvent.REMOVE, bean);
        }
        this.beanCache.clear();
    }

    boolean isActive() {
        return null != this.watcherRef.get();
    }

    private void notify(WatcherEvent event, BeanEntry<Q, T> bean) {
        W watcher = this.watcherRef.get();
        if (null != watcher) {
            try {
                switch (event) {
                    case ADD: {
                        this.mediator.add(bean, watcher);
                        break;
                    }
                    case REMOVE: {
                        this.mediator.remove(bean, watcher);
                    }
                }
            }
            catch (Throwable e) {
                Logs.warn("Problem mediating: {}", bean, e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WatcherEvent {
        ADD,
        REMOVE;

    }
}

