/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.sample.file;

import de.schlichtherle.truezip.crypto.raes.RaesOutputStream;
import de.schlichtherle.truezip.crypto.raes.RaesParameters;
import de.schlichtherle.truezip.crypto.raes.RaesReadOnlyFile;
import de.schlichtherle.truezip.crypto.raes.param.KeyManagerRaesParameters;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.key.sl.KeyManagerLocator;
import de.schlichtherle.truezip.rof.DefaultReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFileInputStream;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RaesFiles {
    private RaesFiles() {
    }

    public static void encrypt(String plainFilePath, String raesFilePath) throws IOException {
        RaesFiles.encrypt(plainFilePath, raesFilePath, TConfig.get().getArchiveDetector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public static void encrypt(String plainFilePath, String raesFilePath, TArchiveDetector detector) throws IOException {
        TFile plainFile = RaesFiles.newNonArchiveFile(plainFilePath, detector);
        TFile raesFile = RaesFiles.newNonArchiveFile(raesFilePath, detector);
        KeyManagerRaesParameters params = new KeyManagerRaesParameters(KeyManagerLocator.SINGLETON, raesFile.toURI());
        TFileInputStream in = new TFileInputStream(plainFile);
        RaesOutputStream out = null;
        try {
            out = RaesOutputStream.getInstance(new TFileOutputStream(raesFile, false), params);
        }
        finally {
            if (null == out) {
                ((InputStream)in).close();
            }
        }
        TFile.cp((InputStream)in, (OutputStream)out);
    }

    public static void decrypt(String raesFilePath, String plainFilePath, boolean strongAuthentication) throws IOException {
        RaesFiles.decrypt(raesFilePath, plainFilePath, strongAuthentication, TConfig.get().getArchiveDetector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public static void decrypt(String raesFilePath, String plainFilePath, boolean authenticate, TArchiveDetector detector) throws IOException {
        TFile raesFile = RaesFiles.newNonArchiveFile(raesFilePath, detector);
        TFile plainFile = RaesFiles.newNonArchiveFile(plainFilePath, detector);
        KeyManagerRaesParameters params = new KeyManagerRaesParameters(KeyManagerLocator.SINGLETON, raesFile.toURI());
        DefaultReadOnlyFile rof = new DefaultReadOnlyFile(raesFile);
        try {
            RaesReadOnlyFile rrof = RaesReadOnlyFile.getInstance(rof, (RaesParameters)params);
            if (authenticate) {
                rrof.authenticate();
            }
            ReadOnlyFileInputStream in = new ReadOnlyFileInputStream(rrof);
            TFileOutputStream out = null;
            try {
                out = new TFileOutputStream(plainFile, false);
            }
            finally {
                if (null == out) {
                    ((InputStream)in).close();
                }
            }
            TFile.cp((InputStream)in, (OutputStream)out);
        }
        finally {
            rof.close();
        }
    }

    private static TFile newNonArchiveFile(String path, TArchiveDetector detector) {
        TFile file = new TFile(path, detector);
        return new TFile((File)file.getParentFile(), file.getName(), TArchiveDetector.NULL);
    }
}

