/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.nio.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.file.ExpertFeature;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.io.Paths;
import de.schlichtherle.truezip.nio.file.TFileSystem;
import de.schlichtherle.truezip.nio.file.TFileSystemProvider;
import de.schlichtherle.truezip.nio.file.TPathScanner;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.HashMaps;
import de.schlichtherle.truezip.util.QuotedUriSyntaxException;
import de.schlichtherle.truezip.util.UriBuilder;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public final class TPath
implements Path {
    private static final TPathComparator COMPARATOR = '\\' == File.separatorChar ? new WindowsTPathComparator() : new TPathComparator();
    private final URI name;
    private final TArchiveDetector detector;
    private final FsPath address;
    @CheckForNull
    private volatile TFileSystem fileSystem;
    @CheckForNull
    private volatile String string;
    @CheckForNull
    private volatile Integer hashCode;
    @CheckForNull
    private volatile List<String> elements;

    public TPath(String first, String ... more) {
        this(TPath.name(first, more), null, null);
    }

    TPath(TFileSystem fileSystem, String first, String ... more) {
        TArchiveDetector detector;
        URI name;
        this.name = name = TPath.name(TPath.cutLeadingSeparators(first), more);
        this.detector = detector = TPath.getDefaultArchiveDetector();
        this.address = new TPathScanner(detector).scan(new FsPath(fileSystem.getMountPoint(), FsEntryName.ROOT), name);
        this.fileSystem = fileSystem;
        assert (this.invariants());
    }

    public TPath(URI name) {
        this(name, null, null);
    }

    public TPath(File file) {
        URI name;
        this.name = name = TPath.name(file.getPath(), new String[0]);
        if (file instanceof TFile) {
            TFile f = (TFile)file;
            this.detector = f.getArchiveDetector();
            this.address = f.toFsPath();
        } else {
            TArchiveDetector detector;
            this.detector = detector = TPath.getDefaultArchiveDetector();
            this.address = TPath.address(name, detector);
        }
        assert (this.invariants());
    }

    public TPath(Path path) {
        this(path instanceof TPath ? ((TPath)path).getName() : TPath.name(path.toString().replace(path.getFileSystem().getSeparator(), File.separator), new String[0]), null, null);
    }

    @SuppressWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"})
    private TPath(URI name, @CheckForNull TArchiveDetector detector, @CheckForNull FsPath address) {
        this.name = name = TPath.name(name);
        if (null == detector) {
            detector = TPath.getDefaultArchiveDetector();
        }
        this.detector = detector;
        FsPath fsPath = this.address = null != address ? address : TPath.address(name, detector);
        assert (this.invariants());
    }

    private static URI name(String first, String ... more) {
        int l = 1 + first.length();
        for (String m : more) {
            l += 1 + m.length();
        }
        StringBuilder sb = new StringBuilder(l);
        int i = -1;
        String s = first.replace(File.separatorChar, '/');
        int l2 = s.length();
        for (int k = 0; k < l2; ++k) {
            char c = s.charAt(k);
            if ('/' == c && i > 0 && (0 >= i || '/' == sb.charAt(i))) continue;
            sb.append(c);
            ++i;
        }
        for (String s2 : more) {
            s2 = s2.replace(File.separatorChar, '/');
            int l3 = s2.length();
            int j = 0;
            for (int k = 0; k < l3; ++k) {
                boolean o;
                char c = s2.charAt(k);
                boolean n = '/' != c;
                boolean bl = o = 0 <= i && '/' != sb.charAt(i);
                if (!n && !o) continue;
                if (0 == j && n && o) {
                    sb.append('/');
                }
                sb.append(c);
                ++i;
                ++j;
            }
        }
        String p = sb.toString();
        l2 = TPath.prefixLength(p);
        p = TPath.cutTrailingSeparators(p, l2);
        try {
            UriBuilder ub = new UriBuilder();
            if (0 < l2) {
                if ('/' != p.charAt(l2 - 1)) {
                    throw new QuotedUriSyntaxException((Object)p, "Relative path with non-empty prefix.");
                }
                if (1 < l2 && '/' == p.charAt(0)) {
                    assert (File.separatorChar == '\\');
                    assert ('/' == p.charAt(1));
                    int j = p.indexOf(47, 2);
                    if (-1 != j) {
                        ub.setAuthority(p.substring(2, j));
                        p = p.substring(j);
                    }
                }
            }
            return ub.path(p).getUri();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @SuppressWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"})
    private static URI name(URI uri) {
        try {
            uri = TPathScanner.checkFix(uri);
            int pl = TPathScanner.pathPrefixLength(uri);
            String q = uri.getPath();
            String p = TPath.cutTrailingSeparators(q, pl);
            if (p != q) {
                return new UriBuilder(uri).path(p).getUri();
            }
            return uri;
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static String cutLeadingSeparators(String p) {
        int l = p.length();
        for (int i = 0; i < l; ++i) {
            if ('/' == p.charAt(i)) continue;
            return p.substring(i);
        }
        return "";
    }

    static String cutTrailingSeparators(String p, int o) {
        int i = p.length();
        if (o >= i || '/' != p.charAt(--i)) {
            return p;
        }
        while (o <= i && '/' == p.charAt(--i)) {
        }
        return p.substring(0, ++i);
    }

    private static int prefixLength(String p) {
        return Paths.prefixLength(p, '/', true);
    }

    private static FsPath address(URI name, TArchiveDetector detector) {
        return new TPathScanner(detector).scan(TFileSystemProvider.get(name).getRoot(), name);
    }

    private boolean invariants() {
        assert (null != this.getName());
        assert (null != this.getArchiveDetector());
        assert (null != this.getAddress());
        return true;
    }

    public static TArchiveDetector getDefaultArchiveDetector() {
        return TConfig.get().getArchiveDetector();
    }

    public static void setDefaultArchiveDetector(TArchiveDetector detector) {
        TConfig.get().setArchiveDetector(detector);
    }

    public boolean isArchive() {
        FsPath address = this.getAddress();
        boolean root = address.getEntryName().isRoot();
        FsMountPoint parent = address.getMountPoint().getParent();
        return root && null != parent;
    }

    public boolean isEntry() {
        FsPath address = this.getAddress();
        boolean root = address.getEntryName().isRoot();
        FsMountPoint parent = address.getMountPoint().getParent();
        return !root ? null != parent : null != parent && null != parent.getParent();
    }

    URI getName() {
        return this.name;
    }

    TArchiveDetector getArchiveDetector() {
        return this.detector;
    }

    private FsPath getAddress() {
        return this.address;
    }

    FsMountPoint getMountPoint() {
        return this.getAddress().getMountPoint();
    }

    FsEntryName getEntryName() {
        return this.getAddress().getEntryName();
    }

    @Override
    public TFileSystem getFileSystem() {
        TFileSystem fs = this.fileSystem;
        return null != fs ? fs : (this.fileSystem = this.getFileSystem0());
    }

    private TFileSystem getFileSystem0() {
        return TFileSystemProvider.get(this.getName()).getFileSystem(this);
    }

    @Override
    public boolean isAbsolute() {
        return TPathScanner.isAbsolute(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExpertFeature(level=ExpertFeature.Level.INTERMEDIATE, value={ExpertFeature.Reason.INJECTING_A_DIFFERENT_DETECTOR_FOR_THE_SAME_PATH_MAY_CORRUPT_DATA})
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public TPath toNonArchivePath() {
        if (!this.isArchive()) {
            return this;
        }
        TConfig config = TConfig.push();
        try {
            config.setArchiveDetector(TArchiveDetector.NULL);
            TPath fileName = this.getFileName();
            assert (null != fileName) : "an archive file must not have an empty path name!";
            TPath tPath = this.resolveSibling(fileName);
            return tPath;
        }
        finally {
            config.close();
        }
    }

    @Override
    @Nullable
    public TPath getRoot() {
        URI n = this.getName();
        String ssp = n.getSchemeSpecificPart();
        int l = TPath.prefixLength(ssp);
        if (l <= 0 || '/' != ssp.charAt(l - 1)) {
            return null;
        }
        return new TPath(TPath.name(ssp.substring(0, l), new String[0]), this.getArchiveDetector(), null);
    }

    @Override
    @Nullable
    public TPath getFileName() {
        List<String> elements = this.getElements();
        int l = elements.size();
        if (l <= 0) {
            return null;
        }
        return new TPath(TPath.name(elements.get(l - 1), new String[0]), this.getArchiveDetector(), null);
    }

    @Override
    @Nullable
    public TPath getParent() {
        int pl;
        URI n = this.getName();
        int l = n.getPath().length();
        if (l <= (pl = TPathScanner.pathPrefixLength(n))) {
            return null;
        }
        URI p = n.resolve(TPathScanner.DOT_URI);
        return p.getPath().isEmpty() ? null : new TPath(p, this.getArchiveDetector(), null);
    }

    private List<String> getElements() {
        List<String> elements = this.elements;
        return null != elements ? elements : (this.elements = this.getElements0());
    }

    private List<String> getElements0() {
        URI n = this.getName();
        String p = n.getPath();
        String[] ss = p.substring(TPathScanner.pathPrefixLength(n)).split("/");
        int i = 0;
        for (String s : ss) {
            if (s.isEmpty()) continue;
            ss[i++] = s;
        }
        return Arrays.asList(ss).subList(0, i);
    }

    @Override
    public int getNameCount() {
        return this.getElements().size();
    }

    @Override
    public TPath getName(int index) {
        return new TPath(this.getElements().get(index), new String[0]);
    }

    @Override
    public TPath subpath(int beginIndex, int endIndex) {
        List<String> segments = this.getElements();
        String first = segments.get(beginIndex);
        String[] more = new String[endIndex - beginIndex - 1];
        return new TPath(first, segments.subList(beginIndex + 1, endIndex).toArray(more));
    }

    @Override
    public boolean startsWith(Path that) {
        if (!this.getFileSystem().equals(that.getFileSystem())) {
            return false;
        }
        return this.startsWith(that.toString());
    }

    @Override
    public boolean startsWith(String other) {
        String name = this.toString();
        int ol = other.length();
        return name.startsWith(other) && (name.length() == ol || File.separatorChar == name.charAt(ol));
    }

    @Override
    public boolean endsWith(Path that) {
        if (!this.getFileSystem().equals(that.getFileSystem())) {
            return false;
        }
        return this.endsWith(that.toString());
    }

    @Override
    public boolean endsWith(String other) {
        int tl;
        String name = this.toString();
        int ol = other.length();
        return name.endsWith(other) && ((tl = name.length()) == ol || File.separatorChar == name.charAt(tl - ol));
    }

    @Override
    public TPath normalize() {
        return new TPath(this.getName().normalize(), this.getArchiveDetector(), this.getAddress());
    }

    @Override
    public TPath resolve(Path other) {
        if (other instanceof TPath) {
            TPath o = (TPath)other;
            if (o.isAbsolute()) {
                return o;
            }
            if (o.toString().isEmpty()) {
                return this;
            }
            return this.resolve(o.getName());
        }
        return this.resolve(other.toString().replace(other.getFileSystem().getSeparator(), File.separator));
    }

    @Override
    public TPath resolve(String other) {
        return this.resolve(TPath.name(other, new String[0]));
    }

    private TPath resolve(URI m) {
        URI n;
        if (TPathScanner.isAbsolute(m) || (n = this.getName()).toString().isEmpty()) {
            n = m;
        } else if (m.toString().isEmpty()) {
            n = this.getName();
        } else {
            String np = n.getPath();
            if (np.endsWith("/")) {
                n = n.resolve(m);
            } else {
                try {
                    n = new UriBuilder(n).path(np + '/').getUri().resolve(m);
                }
                catch (URISyntaxException ex) {
                    throw new AssertionError((Object)ex);
                }
            }
        }
        TArchiveDetector d = TPath.getDefaultArchiveDetector();
        FsPath a = new TPathScanner(d).scan(TPathScanner.isAbsolute(m) ? TFileSystemProvider.get(this.getName()).getRoot() : this.getAddress(), m);
        return new TPath(n, d, a);
    }

    @Override
    public TPath resolveSibling(Path other) {
        if (!(other instanceof TPath)) {
            return this.resolveSibling(new TPath(other));
        }
        TPath o = (TPath)other;
        if (o.isAbsolute()) {
            return o;
        }
        TPath p = this.getParent();
        if (null == p) {
            return o;
        }
        if (o.toString().isEmpty()) {
            return p;
        }
        return p.resolve(o);
    }

    @Override
    public TPath resolveSibling(String other) {
        return this.resolveSibling(new TPath(other, new String[0]));
    }

    @Override
    public TPath relativize(Path other) {
        return new TPath(this.toUri().relativize(other.toUri()));
    }

    @Override
    public URI toUri() {
        URI n = this.getName();
        String s = n.getScheme();
        return new UriBuilder(this.getAddress().toHierarchicalUri()).scheme(null != s ? s : TFileSystemProvider.get(n).getScheme()).toUri();
    }

    @Override
    public TPath toAbsolutePath() {
        return new TPath(this.toUri(), this.getArchiveDetector(), this.getAddress());
    }

    @Override
    public TPath toRealPath(LinkOption ... options) throws IOException {
        return new TPath(this.toUri(), this.getArchiveDetector(), this.getAddress());
    }

    @Override
    public TFile toFile() {
        try {
            return this.getName().isAbsolute() ? new TFile(this.getAddress(), this.getArchiveDetector()) : new TFile(this.toString(), this.getArchiveDetector());
        }
        catch (IllegalArgumentException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Iterator<Path> iterator() {
        return new SegmentIterator(this);
    }

    @Override
    public int compareTo(Path that) {
        return COMPARATOR.compare(this, (TPath)that);
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof TPath && COMPARATOR.equals(this, (TPath)that);
    }

    @Override
    public int hashCode() {
        return COMPARATOR.hashCode(this);
    }

    @Override
    public String toString() {
        String string = this.string;
        return null != string ? string : (this.string = this.toString0());
    }

    private String toString0() {
        URI name = this.getName();
        return name.isAbsolute() ? name.toString() : name.getSchemeSpecificPart().replace('/', File.separatorChar);
    }

    SeekableByteChannel newByteChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.getFileSystem().newByteChannel(this, options, attrs);
    }

    InputStream newInputStream(OpenOption ... options) throws IOException {
        return this.getFileSystem().newInputStream(this, options);
    }

    OutputStream newOutputStream(OpenOption ... options) throws IOException {
        return this.getFileSystem().newOutputStream(this, options);
    }

    DirectoryStream<Path> newDirectoryStream(DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.getFileSystem().newDirectoryStream(this, filter);
    }

    void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        this.getFileSystem().createDirectory(this, attrs);
    }

    void delete() throws IOException {
        this.getFileSystem().delete(this);
    }

    FsEntry getEntry() throws IOException {
        return this.getFileSystem().getEntry(this);
    }

    InputSocket<?> getInputSocket(BitField<FsInputOption> options) {
        return this.getFileSystem().getInputSocket(this, options);
    }

    OutputSocket<?> getOutputSocket(BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return this.getFileSystem().getOutputSocket(this, options, template);
    }

    void checkAccess(AccessMode ... modes) throws IOException {
        this.getFileSystem().checkAccess(this, modes);
    }

    @Nullable
    <V extends FileAttributeView> V getFileAttributeView(Class<V> type, LinkOption ... options) {
        return this.getFileSystem().getFileAttributeView(this, type, options);
    }

    <A extends BasicFileAttributes> A readAttributes(Class<A> type, LinkOption ... options) throws IOException {
        return this.getFileSystem().readAttributes(this, type, options);
    }

    BitField<FsInputOption> mapInput(OpenOption ... options) {
        HashSet set = new HashSet(HashMaps.initialCapacity(options.length));
        Collections.addAll(set, options);
        return this.mapInput(set);
    }

    BitField<FsInputOption> mapInput(Set<? extends OpenOption> options) {
        int s = options.size();
        if (0 == s || 1 == s && options.contains(StandardOpenOption.READ)) {
            return this.getInputPreferences();
        }
        throw new IllegalArgumentException(options.toString());
    }

    BitField<FsInputOption> getInputPreferences() {
        return TConfig.get().getInputPreferences();
    }

    BitField<FsOutputOption> mapOutput(OpenOption ... options) {
        HashSet set = new HashSet(HashMaps.initialCapacity(options.length));
        Collections.addAll(set, options);
        return this.mapOutput(set);
    }

    BitField<FsOutputOption> mapOutput(Set<? extends OpenOption> options) {
        EnumSet<FsOutputOption> set = EnumSet.noneOf(FsOutputOption.class);
        block6: for (OpenOption openOption : options) {
            if (!(openOption instanceof StandardOpenOption)) {
                throw new UnsupportedOperationException(openOption.toString());
            }
            switch ((StandardOpenOption)openOption) {
                case READ: {
                    throw new IllegalArgumentException(openOption.toString());
                }
                case WRITE: 
                case TRUNCATE_EXISTING: 
                case CREATE: {
                    continue block6;
                }
                case APPEND: {
                    set.add(FsOutputOption.APPEND);
                    continue block6;
                }
                case CREATE_NEW: {
                    set.add(FsOutputOption.EXCLUSIVE);
                    continue block6;
                }
            }
            throw new UnsupportedOperationException(openOption.toString());
        }
        BitField<FsOutputOption> prefs = this.getOutputPreferences();
        return set.isEmpty() ? prefs : prefs.or(BitField.copyOf(set));
    }

    BitField<FsOutputOption> getOutputPreferences() {
        BitField<FsOutputOption> prefs = TConfig.get().getOutputPreferences();
        return null != this.getMountPoint().getParent() ? prefs : prefs.clear(FsOutputOption.CREATE_PARENTS);
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static final class WindowsTPathComparator
    extends TPathComparator {
        private WindowsTPathComparator() {
        }

        @Override
        public int compare(TPath p1, TPath p2) {
            return p1.toString().compareToIgnoreCase(p2.toString());
        }

        @Override
        boolean equals(TPath p1, TPath p2) {
            return p1.getAddress().getMountPoint().equals(p2.getAddress().getMountPoint()) && p1.toString().equalsIgnoreCase(p2.toString());
        }

        @Override
        int hashCode(TPath p) {
            Integer hashCode = p.hashCode;
            if (null != hashCode) {
                return hashCode;
            }
            int result = 17;
            result = 37 * result + p.getAddress().getMountPoint().hashCode();
            result = 37 * result + p.toString().toLowerCase(Locale.getDefault()).hashCode();
            return p.hashCode = result;
        }
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static class TPathComparator
    implements Comparator<TPath> {
        private TPathComparator() {
        }

        @Override
        public int compare(TPath p1, TPath p2) {
            return p1.toString().compareTo(p2.toString());
        }

        boolean equals(TPath p1, TPath p2) {
            return p1.getAddress().getMountPoint().equals(p2.getAddress().getMountPoint()) && p1.toString().equals(p2.toString());
        }

        int hashCode(TPath p) {
            Integer hashCode = p.hashCode;
            if (null != hashCode) {
                return hashCode;
            }
            int result = 17;
            result = 37 * result + p.getAddress().getMountPoint().hashCode();
            result = 37 * result + p.toString().hashCode();
            return p.hashCode = result;
        }
    }

    private static final class SegmentIterator
    implements Iterator<Path> {
        final Iterator<String> i;

        SegmentIterator(TPath path) {
            this.i = path.getElements().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public Path next() {
            return new TPath(this.i.next(), new String[0]);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

