/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.nio.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.nio.file.TFileSystem;
import de.schlichtherle.truezip.nio.file.TPath;
import de.schlichtherle.truezip.nio.file.TPathScanner;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystemException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class TFileSystemProvider
extends FileSystemProvider {
    public static final String DEFAULT_SCHEME = "tpath";
    public static final String DEFAULT_ROOT_MOUNT_POINT = "file:/";
    private static final URI DEFAULT_ROOT_MOUNT_POINT_URI = URI.create("file:/");
    private static final Map<String, TFileSystemProvider> providers = new WeakHashMap<String, TFileSystemProvider>();
    private final String scheme;
    private final FsPath root;
    private Map<FsMountPoint, WeakReference<TFileSystem>> fileSystems = new WeakHashMap<FsMountPoint, WeakReference<TFileSystem>>();

    static synchronized TFileSystemProvider get(URI name) {
        String scheme;
        TFileSystemProvider provider;
        if (!TPathScanner.isAbsolute(name)) {
            return Holder.CURRENT_DIRECTORY_PROVIDER;
        }
        if (!name.isAbsolute()) {
            name = DEFAULT_ROOT_MOUNT_POINT_URI;
        }
        if (null != (provider = providers.get(scheme = name.getScheme()))) {
            return provider;
        }
        provider = new TFileSystemProvider(scheme, name.resolve("/"));
        providers.put(scheme, provider);
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public TFileSystemProvider() {
        this(DEFAULT_SCHEME, DEFAULT_ROOT_MOUNT_POINT_URI);
        Class<TFileSystemProvider> clazz = TFileSystemProvider.class;
        synchronized (TFileSystemProvider.class) {
            providers.put(this.scheme, this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Logger.getLogger(TFileSystemProvider.class.getName(), TFileSystemProvider.class.getName()).log(Level.CONFIG, "installed");
            return;
        }
    }

    private TFileSystemProvider(String scheme, URI root) {
        assert (null != scheme);
        this.scheme = scheme;
        this.root = FsPath.create(root);
    }

    @Deprecated
    public static void umount() throws FsSyncException {
        TVFS.umount();
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    public FsPath getRoot() {
        return this.root;
    }

    private static TConfig push(Map<String, ?> env) {
        TArchiveDetector detector = (TArchiveDetector)env.get("archiveDetector");
        TConfig config = TConfig.push();
        if (null != detector) {
            config.setArchiveDetector(detector);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TFileSystem newFileSystem(Path path, Map<String, ?> configuration) {
        TConfig config = TFileSystemProvider.push(configuration);
        try {
            TPath p = new TPath(path);
            if (null == p.getMountPoint().getParent()) {
                throw new UnsupportedOperationException("No prospective archive file detected.");
            }
            TFileSystem tFileSystem = p.getFileSystem();
            return tFileSystem;
        }
        finally {
            config.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TFileSystem newFileSystem(URI uri, Map<String, ?> configuration) {
        TConfig config = TFileSystemProvider.push(configuration);
        try {
            TFileSystem tFileSystem = this.getFileSystem(uri);
            return tFileSystem;
        }
        finally {
            config.close();
        }
    }

    @Override
    public TFileSystem getFileSystem(URI uri) {
        return this.getPath(uri).getFileSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TFileSystem getFileSystem(TPath path) {
        FsMountPoint mp = path.getMountPoint();
        TFileSystemProvider tFileSystemProvider = this;
        synchronized (tFileSystemProvider) {
            TFileSystem fs = (TFileSystem)TFileSystemProvider.deref(this.fileSystems.get(mp));
            if (null == fs) {
                fs = new TFileSystem(path);
                this.fileSystems.put(mp, new WeakReference<TFileSystem>(fs));
            }
            return fs;
        }
    }

    private static <T> T deref(Reference<T> ref) {
        return null != ref ? (T)ref.get() : null;
    }

    @Override
    public TPath getPath(URI name) {
        if (!this.getScheme().equals(name.getScheme())) {
            throw new IllegalArgumentException();
        }
        return new TPath(name);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return TFileSystemProvider.promote(path).newByteChannel(options, attrs);
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        return TFileSystemProvider.promote(path).newInputStream(options);
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        return TFileSystemProvider.promote(path).newOutputStream(options);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return TFileSystemProvider.promote(dir).newDirectoryStream(filter);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        TFileSystemProvider.promote(dir).createDirectory(attrs);
    }

    @Override
    public void delete(Path path) throws IOException {
        TFileSystemProvider.promote(path).delete();
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        TFileSystemProvider.copy(TFileSystemProvider.promote(source), TFileSystemProvider.promote(target), options);
    }

    private static void copy(TPath src, TPath dst, CopyOption ... options) throws IOException {
        if (TFileSystemProvider.isSameFile0(src, dst)) {
            throw new FileSystemException(src.toString(), dst.toString(), "Source and destination are the same file!");
        }
        boolean preserve = false;
        BitField<FsOutputOption> o = dst.getOutputPreferences().set(FsOutputOption.EXCLUSIVE);
        block7: for (CopyOption option : options) {
            if (!(option instanceof StandardCopyOption)) {
                throw new UnsupportedOperationException(option.toString());
            }
            switch ((StandardCopyOption)option) {
                case REPLACE_EXISTING: {
                    o = o.clear(FsOutputOption.EXCLUSIVE);
                    continue block7;
                }
                case COPY_ATTRIBUTES: {
                    preserve = true;
                    continue block7;
                }
                case ATOMIC_MOVE: {
                    throw new AtomicMoveNotSupportedException(src.toString(), dst.toString(), null);
                }
                default: {
                    throw new UnsupportedOperationException(option.toString());
                }
            }
        }
        FsEntry srcEntry = src.getEntry();
        FsEntry dstEntry = dst.getEntry();
        if (null == srcEntry) {
            throw new NoSuchFileException(src.toString());
        }
        if (!srcEntry.isType(Entry.Type.FILE)) {
            throw new FileSystemException(src.toString(), null, "Expected type FILE, but is " + BitField.copyOf(srcEntry.getTypes()) + "!");
        }
        if (null != dstEntry) {
            if (o.get(FsOutputOption.EXCLUSIVE)) {
                throw new FileAlreadyExistsException(dst.toString());
            }
            if (dstEntry.isType(Entry.Type.DIRECTORY)) {
                try {
                    dst.delete();
                }
                catch (IOException ex) {
                    if (!dstEntry.getMembers().isEmpty()) {
                        throw (IOException)new DirectoryNotEmptyException(dst.toString()).initCause(ex);
                    }
                    throw ex;
                }
            }
        }
        InputSocket<?> input = src.getInputSocket(src.getInputPreferences());
        OutputSocket<?> output = dst.getOutputSocket(o, preserve ? (Entry)input.getLocalTarget() : null);
        IOSocket.copy(input, output);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        TFileSystemProvider.move(TFileSystemProvider.promote(source), TFileSystemProvider.promote(target), options);
    }

    private static void move(TPath source, TPath target, CopyOption ... options) throws IOException {
        TFileSystemProvider.copy(source, target, StandardCopyOption.COPY_ATTRIBUTES);
        source.delete();
    }

    @Override
    public boolean isSameFile(Path a, Path b) throws IOException {
        return TFileSystemProvider.isSameFile0(a, b);
    }

    private static boolean isSameFile0(Path a, Path b) throws IOException {
        return a.equals(b) || a.toRealPath(new LinkOption[0]).equals(b.toRealPath(new LinkOption[0]));
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return TFileSystemProvider.promote(path).getFileName().toString().startsWith(".");
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        TFileSystemProvider.promote(path).checkAccess(modes);
    }

    @Override
    @Nullable
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return TFileSystemProvider.promote(path).getFileAttributeView(type, options);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        return TFileSystemProvider.promote(path).readAttributes(type, options);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static TPath promote(Path path) {
        try {
            return (TPath)path;
        }
        catch (ClassCastException ex) {
            throw (ProviderMismatchException)new ProviderMismatchException(ex.toString()).initCause(ex);
        }
    }

    private static final class Holder {
        static final TFileSystemProvider CURRENT_DIRECTORY_PROVIDER = new TFileSystemProvider("file", new File("").toURI());

        private Holder() {
        }
    }

    public static interface Parameter {
        public static final String ARCHIVE_DETECTOR = "archiveDetector";
    }
}

