/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.sam.MergingSamRecordIterator;
import net.sf.picard.sam.SamFileHeaderMerger;
import net.sf.picard.sam.SamPairUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.PeekableIterator;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.util.RuntimeIOException;
import net.sf.samtools.util.SortingCollection;

public class FixMateInformation
extends CommandLineProgram {
    @Usage
    public final String USAGE = "Ensure that all mate-pair information is in sync between each read  and it's mate pair.  If no OUTPUT file is supplied then the output is written to a temporary file  and then copied over the INPUT file.  Reads marked with the secondary alignment flag are written to the output file unchanged.";
    @Option(shortName="I", doc="The input file to fix.")
    public List<File> INPUT;
    @Option(shortName="O", optional=true, doc="The output file to write to. If no output file is supplied, the input file is overwritten.")
    public File OUTPUT;
    @Option(shortName="SO", optional=true, doc="Optional sort order if the OUTPUT file should be sorted differently than the INPUT file.")
    public SAMFileHeader.SortOrder SORT_ORDER;
    private static final Log log = Log.getInstance(FixMateInformation.class);
    protected SAMFileWriter out;

    public static void main(String[] args) {
        new FixMateInformation().instanceMainWithExit(args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int doWork() {
        PeekableIterator<SAMRecord> iterator;
        SAMFileHeader header;
        Object tmp;
        boolean differentOutputSpecified;
        boolean allQueryNameSorted = true;
        ArrayList<SAMFileReader> readers = new ArrayList<SAMFileReader>();
        for (File f : this.INPUT) {
            IoUtil.assertFileIsReadable(f);
            SAMFileReader reader = new SAMFileReader(f);
            readers.add(reader);
            if (reader.getFileHeader().getSortOrder() == SAMFileHeader.SortOrder.queryname) continue;
            allQueryNameSorted = false;
        }
        if (this.OUTPUT != null) {
            this.OUTPUT = this.OUTPUT.getAbsoluteFile();
        }
        boolean bl = differentOutputSpecified = this.OUTPUT != null;
        if (differentOutputSpecified) {
            IoUtil.assertFileIsWritable(this.OUTPUT);
        } else {
            if (this.INPUT.size() != 1) {
                throw new PicardException("Must specify either an explicit OUTPUT file or a single INPUT file to be overridden.");
            }
            File soleInput = this.INPUT.get(0).getAbsoluteFile();
            File dir = soleInput.getParentFile().getAbsoluteFile();
            try {
                IoUtil.assertFileIsWritable(soleInput);
                IoUtil.assertDirectoryIsWritable(dir);
                this.OUTPUT = File.createTempFile(soleInput.getName() + ".being_fixed.", ".bam", dir);
            }
            catch (IOException ioe) {
                throw new RuntimeIOException("Could not create tmp file in " + dir.getAbsolutePath());
            }
        }
        if (this.INPUT.size() > 1) {
            ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>(readers.size());
            for (SAMFileReader reader : readers) {
                headers.add(reader.getFileHeader());
            }
            SAMFileHeader.SortOrder sortOrder = allQueryNameSorted ? SAMFileHeader.SortOrder.queryname : SAMFileHeader.SortOrder.unsorted;
            SamFileHeaderMerger merger = new SamFileHeaderMerger(sortOrder, headers, false);
            tmp = new MergingSamRecordIterator(merger, readers, false);
            header = merger.getMergedHeader();
        } else {
            tmp = ((SAMFileReader)readers.get(0)).iterator();
            header = ((SAMFileReader)readers.get(0)).getFileHeader();
        }
        if (allQueryNameSorted) {
            iterator = new PeekableIterator((Iterator<SAMRecord>)tmp);
        } else {
            log.info("Sorting input into queryname order.");
            final SortingCollection sorter = SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec(header), (Comparator)new SAMRecordQueryNameComparator(), (int)this.MAX_RECORDS_IN_RAM, (Collection)this.TMP_DIR);
            while (tmp.hasNext()) {
                sorter.add(tmp.next());
            }
            iterator = new PeekableIterator<SAMRecord>((Iterator)sorter.iterator()){

                @Override
                public void close() {
                    super.close();
                    sorter.cleanup();
                }
            };
            log.info("Sorting by queryname complete.");
        }
        SAMFileHeader.SortOrder outputSortOrder = this.SORT_ORDER == null ? ((SAMFileReader)readers.get(0)).getFileHeader().getSortOrder() : this.SORT_ORDER;
        log.info("Output will be sorted by " + outputSortOrder);
        header.setSortOrder(outputSortOrder);
        if (this.CREATE_INDEX.booleanValue() && header.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new PicardException("Can't CREATE_INDEX unless sort order is coordinate");
        }
        this.createSamFileWriter(header);
        log.info("Traversing query name sorted records and fixing up mate pair information.");
        ProgressLogger progress = new ProgressLogger(log);
        while (iterator.hasNext()) {
            SAMRecord rec1 = (SAMRecord)iterator.next();
            if (rec1.isSecondaryOrSupplementary()) {
                this.writeAlignment(rec1);
                progress.record(rec1);
                continue;
            }
            SAMRecord rec2 = null;
            while (iterator.hasNext() && (rec2 = (SAMRecord)iterator.peek()).isSecondaryOrSupplementary()) {
                iterator.next();
                this.writeAlignment(rec2);
                progress.record(rec2);
                rec2 = null;
            }
            if (rec2 != null && rec1.getReadName().equals(rec2.getReadName())) {
                iterator.next();
                SamPairUtil.setMateInfo(rec1, rec2, header);
                this.writeAlignment(rec1);
                this.writeAlignment(rec2);
                progress.record(rec1, rec2);
                continue;
            }
            this.writeAlignment(rec1);
            progress.record(rec1);
        }
        iterator.close();
        if (header.getSortOrder() == SAMFileHeader.SortOrder.queryname) {
            log.info("Closing output file.");
        } else {
            log.info("Finished processing reads; re-sorting output file.");
        }
        this.closeWriter();
        if (differentOutputSpecified) return 0;
        log.info("Replacing input file with fixed file.");
        File soleInput = this.INPUT.get(0).getAbsoluteFile();
        File old = new File(soleInput.getParentFile(), soleInput.getName() + ".old");
        if (!old.exists() && soleInput.renameTo(old)) {
            File oldIndex;
            if (!this.OUTPUT.renameTo(soleInput)) {
                log.error("Could not move new file to " + soleInput.getAbsolutePath());
                log.error("Input file preserved as: " + old.getAbsolutePath());
                log.error("New file preserved as: " + this.OUTPUT.getAbsolutePath());
                return 1;
            }
            if (!old.delete()) {
                log.warn("Could not delete old file: " + old.getAbsolutePath());
                return 1;
            }
            if (this.CREATE_INDEX == false) return 0;
            File newIndex = new File(this.OUTPUT.getParent(), this.OUTPUT.getName().substring(0, this.OUTPUT.getName().length() - 4) + ".bai");
            if (newIndex.renameTo(oldIndex = new File(soleInput.getParent(), soleInput.getName().substring(0, soleInput.getName().length() - 4) + ".bai"))) return 0;
            log.warn("Could not overwrite index file: " + oldIndex.getAbsolutePath());
            return 0;
        }
        log.error("Could not move input file out of the way: " + soleInput.getAbsolutePath());
        if (this.OUTPUT.delete()) return 1;
        log.error("Could not delete temporary file: " + this.OUTPUT.getAbsolutePath());
        return 1;
    }

    protected void createSamFileWriter(SAMFileHeader header) {
        this.out = new SAMFileWriterFactory().makeSAMOrBAMWriter(header, header.getSortOrder() == SAMFileHeader.SortOrder.queryname, this.OUTPUT);
    }

    protected void writeAlignment(SAMRecord sam) {
        this.out.addAlignment(sam);
    }

    protected void closeWriter() {
        this.out.close();
    }
}

