/* ======================================================================= 
 * A visualisation library extension for JFreeChart. Please see JFreeChart
 * for further information.
 * =======================================================================
 * Copyright (C) 2006  University of Helsinki, Department of Computer Science
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * -----------------------------
 * Contact:  ohtu@cs.helsinki.fi
 * -----------------------------
 *
 */

package org.jfree.chart.labels;
import java.io.Serializable;
import org.jfree.data.som.*;

/**
 * A standard tool tip generator to be used with a {@link org.jfree.chart.plot.SOMPlot}.
 * @author  viski project
 */
public class StandardSOMToolTipGenerator implements SOMToolTipGenerator, Cloneable, Serializable {


    /** 
     * Creates a new tool tip generator.
     */
    public StandardSOMToolTipGenerator() {
        ;
    }
    
    /**
     * Generates a tooltip text string for a particular SOM map cell.
     *
     * @param dataset  the dataset. (<code>null</code> not permitted.)
     * @param x  the x coordinate.
     * @param y  the y coordinate.
     *
     * @throws NullPointerException  if dataset is null.
     * @throws IndexOutOfRangeException  if (x,y) is not in the dataset.
     *
     * @return The tooltip text. (never null.)
     */
    public String generateToolTip(SOMDataset dataset, int x, int y) {
        StringBuffer sb = new StringBuffer();
        String[] descriptions = dataset.getValue(x, y).getDescriptions();
        double[] weights = dataset.getValue(x, y).getNeuronWeights();
        
        sb.append("<html>");
        
        if (descriptions != null) {
            for (int i=0; i < descriptions.length; ++i) {
                sb.append(descriptions[i] + "<br>");
            }
            sb.append("<br>");
        }
        
        if (weights != null) {
            for (int i=0; i < weights.length; ++i) {
                sb.append(weights[i] + "<br>");
            }
        }
        
        sb.append("</html>");

        return sb.toString();
    }

}

