/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics.text;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.icepdf.core.pobjects.OptionalContents;
import org.icepdf.core.pobjects.graphics.text.GlyphText;
import org.icepdf.core.pobjects.graphics.text.LinePositionComparator;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.pobjects.graphics.text.TextSelect;
import org.icepdf.core.pobjects.graphics.text.WordPositionComparator;
import org.icepdf.core.pobjects.graphics.text.WordText;
import org.icepdf.core.util.Defs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageText
implements TextSelect {
    private static boolean checkForDuplicates = Defs.booleanProperty("org.icepdf.core.views.page.text.trim.duplicates", false);
    private static boolean preserveColumns = Defs.booleanProperty("org.icepdf.core.views.page.text.preserveColumns", true);
    private LineText currentLine;
    private ArrayList<LineText> pageLines = new ArrayList(64);
    private ArrayList<LineText> sortedPageLines;
    private LinkedHashMap<OptionalContents, PageText> optionalPageLines;

    public void newLine(LinkedList<OptionalContents> oCGs) {
        if (oCGs != null && oCGs.size() > 0) {
            OptionalContents optionalContent;
            PageText pageText;
            if (this.optionalPageLines == null) {
                this.optionalPageLines = new LinkedHashMap(10);
            }
            if ((pageText = this.optionalPageLines.get(optionalContent = oCGs.peek())) == null) {
                pageText = new PageText();
                pageText.newLine();
                this.optionalPageLines.put(optionalContent, pageText);
            } else {
                pageText.newLine();
            }
        }
    }

    public void newLine() {
        if (this.currentLine != null && this.currentLine.getWords().size() == 0) {
            return;
        }
        this.currentLine = new LineText();
        this.pageLines.add(this.currentLine);
    }

    protected void addGlyph(GlyphText sprite) {
        if (this.currentLine == null) {
            this.newLine();
        }
        this.currentLine.addText(sprite);
    }

    public ArrayList<LineText> getPageLines() {
        if (this.sortedPageLines == null) {
            this.sortAndFormatText();
        }
        return this.sortedPageLines;
    }

    private ArrayList<LineText> getVisiblePageLines() {
        ArrayList<LineText> visiblePageLines = new ArrayList<LineText>(this.pageLines);
        if (this.optionalPageLines != null) {
            Set<OptionalContents> keys = this.optionalPageLines.keySet();
            LineText currentLine = new LineText();
            visiblePageLines.add(currentLine);
            for (OptionalContents key : keys) {
                if (key == null || !key.isVisible()) continue;
                ArrayList<LineText> pageLines = this.optionalPageLines.get(key).getVisiblePageLines();
                for (LineText lineText : pageLines) {
                    currentLine.addAll(lineText.getWords());
                }
            }
            currentLine.getBounds();
        }
        return visiblePageLines;
    }

    private ArrayList<LineText> getAllPageLines() {
        ArrayList<LineText> visiblePageLines = new ArrayList<LineText>(this.pageLines);
        if (this.optionalPageLines != null) {
            Set<OptionalContents> keys = this.optionalPageLines.keySet();
            LineText currentLine = new LineText();
            visiblePageLines.add(currentLine);
            for (OptionalContents key : keys) {
                if (key == null) continue;
                ArrayList<LineText> pageLines = this.optionalPageLines.get(key).getVisiblePageLines();
                for (LineText lineText : pageLines) {
                    currentLine.addAll(lineText.getWords());
                }
            }
            currentLine.getBounds();
        }
        return visiblePageLines;
    }

    public void addPageLines(ArrayList<LineText> pageLines) {
        if (pageLines != null) {
            this.pageLines.addAll(pageLines);
        }
    }

    public void addGlyph(GlyphText glyphText, LinkedList<OptionalContents> oCGs) {
        if (oCGs != null && oCGs.size() > 0) {
            if (oCGs.peek() != null) {
                this.addOptionalPageLines(oCGs.peek(), glyphText);
            }
        } else {
            this.addGlyph(glyphText);
        }
    }

    protected void addOptionalPageLines(OptionalContents optionalContent, GlyphText sprite) {
        PageText pageText;
        if (this.optionalPageLines == null) {
            this.optionalPageLines = new LinkedHashMap(10);
        }
        if ((pageText = this.optionalPageLines.get(optionalContent)) == null) {
            pageText = new PageText();
            pageText.addGlyph(sprite);
            this.optionalPageLines.put(optionalContent, pageText);
        } else {
            pageText.addGlyph(sprite);
        }
    }

    public void applyXObjectTransform(AffineTransform transform) {
        for (LineText lineText : this.pageLines) {
            lineText.clearBounds();
            for (WordText wordText : lineText.getWords()) {
                wordText.clearBounds();
                for (GlyphText glyph : wordText.getGlyphs()) {
                    glyph.normalizeToUserSpace(transform);
                }
            }
        }
    }

    @Override
    public void clearSelected() {
        if (this.pageLines != null) {
            for (LineText lineText : this.pageLines) {
                lineText.clearSelected();
            }
        }
        if (this.sortedPageLines != null) {
            for (LineText lineText : this.sortedPageLines) {
                lineText.clearSelected();
            }
        }
        if (this.optionalPageLines != null) {
            Set<OptionalContents> keys = this.optionalPageLines.keySet();
            for (OptionalContents key : keys) {
                ArrayList<LineText> optionalLines;
                if (key == null || (optionalLines = this.optionalPageLines.get(key).getAllPageLines()) == null) continue;
                for (LineText lineText : optionalLines) {
                    lineText.clearSelected();
                }
            }
        }
    }

    @Override
    public void clearHighlighted() {
        for (LineText lineText : this.pageLines) {
            lineText.clearHighlighted();
        }
        for (LineText lineText : this.sortedPageLines) {
            lineText.clearHighlighted();
        }
        if (this.optionalPageLines != null) {
            Set<OptionalContents> keys = this.optionalPageLines.keySet();
            for (OptionalContents key : keys) {
                if (key == null || !key.isVisible()) continue;
                ArrayList<LineText> optionalLines = this.optionalPageLines.get(key).getAllPageLines();
                for (LineText lineText : optionalLines) {
                    lineText.clearHighlighted();
                }
            }
        }
    }

    @Override
    public StringBuilder getSelected() {
        StringBuilder selectedText = new StringBuilder();
        ArrayList<LineText> pageLines = this.getPageLines();
        if (pageLines != null) {
            for (LineText lineText : pageLines) {
                selectedText.append((CharSequence)lineText.getSelected());
            }
        }
        return selectedText;
    }

    @Override
    public void selectAll() {
        ArrayList<LineText> pageLines = this.getPageLines();
        if (pageLines != null) {
            for (LineText lineText : pageLines) {
                lineText.selectAll();
            }
        }
    }

    public void deselectAll() {
        for (LineText lineText : this.pageLines) {
            lineText.clearSelected();
        }
    }

    public String toString() {
        StringBuilder extractedText = new StringBuilder();
        for (LineText lineText : this.pageLines) {
            for (WordText wordText : lineText.getWords()) {
                extractedText.append(wordText.getText());
            }
            extractedText.append('\n');
        }
        return extractedText.toString();
    }

    public void sortAndFormatText() {
        ArrayList<LineText> visiblePageLines = this.getVisiblePageLines();
        if (visiblePageLines != null && visiblePageLines.size() > 0 && visiblePageLines.get(0) != null) {
            ArrayList<LineText> sortedPageLines = new ArrayList<LineText>(64);
            for (LineText pageLine : visiblePageLines) {
                List<WordText> words = pageLine.getWords();
                if (words == null || words.size() <= 0) continue;
                if (!preserveColumns) {
                    Collections.sort(words, new LinePositionComparator());
                }
                double lastY = words.get((int)0).getBounds().y;
                int start = 0;
                int end = 0;
                for (WordText word : words) {
                    double currentY = Math.round(word.getBounds().getY());
                    if (currentY != lastY) {
                        LineText lineText = new LineText();
                        lineText.addAll(words.subList(start, end));
                        sortedPageLines.add(lineText);
                        start = end;
                    }
                    ++end;
                    lastY = currentY;
                }
                if (start >= end) continue;
                LineText lineText = new LineText();
                lineText.addAll(words.subList(start, end));
                sortedPageLines.add(lineText);
            }
            if (checkForDuplicates) {
                int maxLines = sortedPageLines.size();
                for (int k = 0; k < maxLines; ++k) {
                    int max;
                    LineText lineText = (LineText)sortedPageLines.get(k);
                    if (lineText.getWords().size() <= 0) continue;
                    List<WordText> words = lineText.getWords();
                    int wordCount = words.size();
                    boolean mirrored = true;
                    int middle = wordCount / 2;
                    int i = 0;
                    int j = max = middle;
                    while (i < max) {
                        if (!words.get(i).toString().equals(words.get(j).toString())) {
                            mirrored = false;
                            break;
                        }
                        ++i;
                        ++j;
                    }
                    if (!mirrored) continue;
                    List<WordText> trimmedWords = words.subList(0, middle);
                    lineText.setWords(trimmedWords);
                }
            }
            if (sortedPageLines.size() > 0) {
                for (LineText lineText : sortedPageLines) {
                    Collections.sort(lineText.getWords(), new WordPositionComparator());
                }
            }
            if (sortedPageLines.size() > 0) {
                for (LineText lineText : sortedPageLines) {
                    lineText.getBounds();
                }
            }
            this.sortedPageLines = sortedPageLines;
        }
    }
}

