/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.ImageStream;
import org.icepdf.core.pobjects.ImageUtility;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.graphics.CachedImageReference;
import org.icepdf.core.pobjects.graphics.DeviceGray;
import org.icepdf.core.pobjects.graphics.ImagePool;
import org.icepdf.core.pobjects.graphics.ScaledImageReference;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;

public class SmoothScaledImageReference
extends CachedImageReference {
    private static final Logger logger = Logger.getLogger(ScaledImageReference.class.toString());
    private static int maxImageWidth = 7000;
    private static int maxImageHeight = 7000;
    private int width;
    private int height;

    protected SmoothScaledImageReference(ImageStream imageStream, Color fillColor, Resources resources) {
        super(imageStream, fillColor, resources);
        this.width = imageStream.getWidth();
        this.height = imageStream.getHeight();
        ImagePool imagePool = imageStream.getLibrary().getImagePool();
        if (useProxy && imagePool.get(this.reference) == null) {
            this.futureTask = new FutureTask<BufferedImage>(this);
            Library.executeImage(this.futureTask);
        } else if (!useProxy && imagePool.get(this.reference) == null) {
            this.image = this.call();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public BufferedImage call() {
        BufferedImage image = null;
        try {
            if (image == null) {
                image = this.imageStream.getImage(this.fillColor, this.resources);
                if (this.width > maxImageWidth || this.height > maxImageHeight) {
                    return image;
                }
            }
            if (image != null) {
                int width = this.width;
                double imageScale = 1.0;
                if (this.imageStream.getColourSpace() != null && this.imageStream.getColourSpace() instanceof DeviceGray) {
                    imageScale = width < 50 || this.height < 50 ? 0.9 : 0.99;
                    if (imageScale != 1.0) {
                        image = (BufferedImage)ImageUtility.getTrilinearScaledInstance(image, (int)Math.ceil((double)width * imageScale), (int)Math.ceil((double)this.height * imageScale));
                    }
                } else {
                    if (!(width < 250 && this.height < 250 || width >= 500 && this.height >= 500)) {
                        imageScale = 0.9;
                    } else if (!(width < 500 && this.height < 500 || width >= 1000 && this.height >= 1000)) {
                        imageScale = 0.8;
                    } else if (!(width < 1000 && this.height < 1000 || width >= 1500 && this.height >= 1500)) {
                        imageScale = 0.7;
                    } else if (!(width < 1500 && this.height < 1500 || width >= 2000 && this.height >= 2000)) {
                        imageScale = 0.6;
                    } else if (!(width < 2000 && this.height < 2000 || width >= 2500 && this.height >= 2500)) {
                        imageScale = 0.5;
                    } else if (!(width < 2500 && this.height < 2500 || width >= 3000 && this.height >= 3000)) {
                        imageScale = 0.4;
                    } else if (width >= 3000 || this.height >= 3000) {
                        imageScale = 0.3;
                    }
                    if (imageScale != 1.0) {
                        AffineTransform tx = new AffineTransform();
                        tx.scale(imageScale, imageScale);
                        AffineTransformOp op = new AffineTransformOp(tx, 3);
                        BufferedImage sbim = op.filter(image, null);
                        image.flush();
                        image = sbim;
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.warning("Error loading image: " + this.imageStream.getPObjectReference() + " " + this.imageStream.toString());
        }
        return image;
    }

    static {
        try {
            maxImageWidth = Integer.parseInt(Defs.sysProperty("org.icepdf.core.imageReference.smoothscaled.maxwidth", String.valueOf(maxImageWidth)));
            maxImageHeight = Integer.parseInt(Defs.sysProperty("org.icepdf.core.imageReference.smoothscaled.maxheight", String.valueOf(maxImageHeight)));
        }
        catch (NumberFormatException e) {
            logger.warning("Error reading buffered scale factor");
        }
    }
}

