/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Catalog;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.NameTree;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Destination {
    private static final Logger logger = Logger.getLogger(Destination.class.toString());
    public static final Name D_KEY = new Name("D");
    public static final Name TYPE_XYZ = new Name("XYZ");
    public static final Name TYPE_FIT = new Name("Fit");
    public static final Name TYPE_FITH = new Name("FitH");
    public static final Name TYPE_FITV = new Name("FitV");
    public static final Name TYPE_FITR = new Name("FitR");
    public static final Name TYPE_FITB = new Name("FitB");
    public static final Name TYPE_FITBH = new Name("FitBH");
    public static final Name TYPE_FITBV = new Name("FitBV");
    private Library library;
    private Object object;
    private Reference ref;
    private Name type;
    private Float left = null;
    private Float bottom = null;
    private Float right = null;
    private Float top = null;
    private Float zoom = null;
    private Name namedDestination;
    private boolean inited;

    public Destination(Library l, Object h) {
        this.library = l;
        this.object = h;
        this.init();
    }

    private void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        if (this.object instanceof List) {
            this.parse((List)this.object);
        } else if (this.object instanceof Name || this.object instanceof StringObject) {
            String s;
            if (this.object instanceof StringObject) {
                StringObject stringObject = (StringObject)this.object;
                s = stringObject.getDecryptedLiteralString(this.library.securityManager);
            } else {
                s = this.object.toString();
            }
            this.namedDestination = new Name(s);
            boolean found = false;
            Catalog catalog = this.library.getCatalog();
            if (catalog != null) {
                Dictionary dests;
                Object o;
                NameTree nameTree = catalog.getNameTree();
                if (nameTree != null && (o = nameTree.searchName(s)) != null) {
                    HashMap h;
                    Object o1;
                    if (o instanceof List) {
                        this.parse((List)o);
                        found = true;
                    } else if (o instanceof HashMap && (o1 = (h = (HashMap)o).get(D_KEY)) instanceof List) {
                        this.parse((List)o1);
                        found = true;
                    }
                }
                if (!found && (dests = catalog.getDestinations()) != null) {
                    Object ob = dests.getObject((Name)this.object);
                    if (ob instanceof HashMap) {
                        this.parse((List)((HashMap)ob).get(D_KEY));
                    } else if (logger.isLoggable(Level.FINE)) {
                        logger.warning("Destination type missed=" + ob);
                    }
                }
            }
        }
    }

    public Object getObject() {
        return this.object;
    }

    private void parse(List v) {
        Object ob = v.get(0);
        if (ob instanceof Reference) {
            this.ref = (Reference)ob;
        }
        this.type = (ob = v.get(1)) instanceof Name ? (Name)ob : new Name(ob.toString());
        if (this.type.equals(TYPE_XYZ)) {
            ob = v.get(2);
            if (ob != null && !ob.equals("null")) {
                this.left = Float.valueOf(((Number)ob).floatValue());
            }
            if ((ob = v.get(3)) != null && !ob.equals("null")) {
                this.top = Float.valueOf(((Number)ob).floatValue());
            }
            if ((ob = v.get(4)) != null && !ob.equals("null") && !ob.equals("0")) {
                this.zoom = Float.valueOf(((Number)ob).floatValue());
            }
        } else if (this.type.equals(TYPE_FITH)) {
            ob = v.get(2);
            if (ob != null && !ob.equals("null")) {
                this.top = Float.valueOf(((Number)ob).floatValue());
            }
        } else if (this.type.equals(TYPE_FITR)) {
            ob = v.get(2);
            if (ob != null && !ob.equals("null")) {
                this.left = Float.valueOf(((Number)ob).floatValue());
            }
            if ((ob = v.get(3)) != null && !ob.equals("null")) {
                this.bottom = Float.valueOf(((Number)ob).floatValue());
            }
            if ((ob = v.get(4)) != null && !ob.equals("null")) {
                this.right = Float.valueOf(((Number)ob).floatValue());
            }
            if ((ob = v.get(5)) != null && !ob.equals("null")) {
                this.top = Float.valueOf(((Number)ob).floatValue());
            }
        } else if (!this.type.equals(TYPE_FITB)) {
            if (this.type.equals(TYPE_FITBH)) {
                ob = v.get(2);
                if (ob != null && !ob.equals("null")) {
                    this.top = Float.valueOf(((Number)ob).floatValue());
                }
            } else if (this.type.equals(TYPE_FITBV) && (ob = v.get(2)) != null && !ob.equals("null")) {
                this.left = Float.valueOf(((Number)ob).floatValue());
            }
        }
    }

    public Name getNamedDestination() {
        return this.namedDestination;
    }

    public void setNamedDestination(Name dest) {
        this.namedDestination = dest;
        this.object = dest;
        this.inited = false;
        this.init();
    }

    public void setDestinationSyntax(List destinationSyntax) {
        this.namedDestination = null;
        this.object = destinationSyntax;
        this.inited = false;
        this.init();
    }

    public static List<Object> destinationSyntax(Reference page, Name type) {
        ArrayList<Object> destSyntax = new ArrayList<Object>(2);
        destSyntax.add(page);
        destSyntax.add(type);
        return destSyntax;
    }

    public static List<Object> destinationSyntax(Reference page, Name type, Object offset) {
        ArrayList<Object> destSyntax = new ArrayList<Object>(3);
        destSyntax.add(page);
        destSyntax.add(type);
        destSyntax.add(offset);
        return destSyntax;
    }

    public static List<Object> destinationSyntax(Reference page, Object type, Object left, Object top, Object zoom) {
        ArrayList<Object> destSyntax = new ArrayList<Object>(5);
        destSyntax.add(page);
        destSyntax.add(type);
        destSyntax.add(left);
        destSyntax.add(top);
        destSyntax.add(zoom);
        return destSyntax;
    }

    public static List<Object> destinationSyntax(Reference page, Object type, Object left, Object bottom, Object right, Object top) {
        ArrayList<Object> destSyntax = new ArrayList<Object>(6);
        destSyntax.add(page);
        destSyntax.add(type);
        destSyntax.add(left);
        destSyntax.add(bottom);
        destSyntax.add(right);
        destSyntax.add(top);
        return destSyntax;
    }

    public Reference getPageReference() {
        return this.ref;
    }

    public Float getLeft() {
        return this.left;
    }

    public Float getTop() {
        return this.top;
    }

    public Float getZoom() {
        return this.zoom;
    }

    public Reference getRef() {
        return this.ref;
    }

    public Name getType() {
        return this.type;
    }

    public Float getBottom() {
        return this.bottom;
    }

    public Float getRight() {
        return this.right;
    }

    public Object getEncodedDestination() {
        if (this.namedDestination != null) {
            return this.namedDestination;
        }
        if (this.object instanceof List) {
            ArrayList<Object> v = new ArrayList<Object>(7);
            if (this.ref != null) {
                v.add(this.ref);
            }
            if (this.type != null) {
                v.add(this.type);
            }
            if (this.left.floatValue() != Float.NaN) {
                v.add(this.left);
            }
            if (this.bottom.floatValue() != Float.NaN) {
                v.add(this.bottom);
            }
            if (this.right.floatValue() != Float.NaN) {
                v.add(this.right);
            }
            if (this.top.floatValue() != Float.NaN) {
                v.add(this.top);
            }
            if (this.zoom.floatValue() != Float.NaN) {
                v.add(this.zoom);
            }
            return v;
        }
        return null;
    }

    public String toString() {
        return "Destination  ref: " + this.getPageReference() + " ,  top: " + this.getTop() + " ,  left: " + this.getLeft() + " ,  zoom: " + this.getZoom();
    }
}

