/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import de.schlichtherle.truezip.zip.ZipFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.http.HttpServletRequest;

public class IOUtils {
    private static final int BUFFER_SIZE = 16384;
    private static final long CALLBACK_INTERVAL = 500L;

    public static void closeIfPossible(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeIfPossible(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeIfPossible(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeIfPossible(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void disconnectIfPossible(HttpURLConnection connection) {
        if (connection != null) {
            connection.disconnect();
        }
    }

    public static void disconnectIfPossible(URLConnection connection) {
        if (connection instanceof HttpURLConnection) {
            IOUtils.disconnectIfPossible((HttpURLConnection)connection);
        }
    }

    public static void copy(InputStream source, OutputStream target, CopyProgressListener progressListener) throws IOException {
        BufferedInputStream bSource = new BufferedInputStream(source);
        BufferedOutputStream bTarget = new BufferedOutputStream(target);
        byte[] buffer = new byte[16384];
        int len = 16384;
        long sum = 0L;
        long lastCallback = Long.MAX_VALUE;
        if (progressListener != null) {
            progressListener.progress(0L);
            lastCallback = System.currentTimeMillis();
        }
        while ((len = bSource.read(buffer, 0, 16384)) >= 0) {
            bTarget.write(buffer, 0, len);
            sum += (long)len;
            if (progressListener == null || lastCallback + 500L >= System.currentTimeMillis()) continue;
            progressListener.progress(sum);
            lastCallback = System.currentTimeMillis();
        }
        bTarget.flush();
    }

    public static void copy(InputStream source, OutputStream target) throws IOException {
        IOUtils.copy(source, target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream source, File target) throws IOException {
        FileOutputStream out = new FileOutputStream(target);
        try {
            IOUtils.copy(source, out, null);
        }
        finally {
            IOUtils.closeIfPossible(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File from, File to) throws IOException {
        FileInputStream in = new FileInputStream(from);
        FileOutputStream out = new FileOutputStream(to);
        try {
            IOUtils.copy(in, out, null);
        }
        finally {
            IOUtils.closeIfPossible(in);
            IOUtils.closeIfPossible(out);
        }
    }

    public static void closeIfPossible(RandomAccessFile raf) {
        if (raf != null) {
            try {
                raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeIfPossible(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static URL createURL(URL url, String postfix) throws MalformedURLException {
        return new URL(url, url.getFile() + "/" + postfix);
    }

    public static boolean isLocalFileURL(URL url) {
        return "file".equals(url.getProtocol());
    }

    public static String getFilenameWithoutPath(URL url) {
        return url.getPath().substring(url.getPath().lastIndexOf(47) + 1);
    }

    public static String getFilenameWithoutPath(HttpServletRequest request) {
        String path = request.getPathInfo();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static String getFilename(Object o) {
        if (o instanceof File) {
            return ((File)o).getName();
        }
        if (o instanceof URL) {
            return IOUtils.getFilenameWithoutPath((URL)o);
        }
        return null;
    }

    public static void disableHttpCache() {
        try {
            new URL("http://chipster.csc.fi").openConnection().setDefaultUseCaches(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface CopyProgressListener {
        public void progress(long var1);
    }
}

