/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.KeyAndTrustManager;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class HttpRangeTest {
    private static String protocol = "https";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            HttpRangeTest.jetty();
            HttpRangeTest.get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    private static void jetty() throws Exception {
        System.setProperty("org.eclipse.jetty.LEVEL", "DEBUG");
        Server jettyInstance = new Server();
        jettyInstance.setThreadPool((ThreadPool)new QueuedThreadPool());
        SelectChannelConnector connector = null;
        switch (protocol) {
            case "http": {
                connector = new SelectChannelConnector();
                break;
            }
            case "https": {
                connector = new SslSocketConnector(KeyAndTrustManager.createSslContextFactory("../chipster-environment/security/filebroker.ks", "password"));
            }
        }
        connector.setServer(jettyInstance);
        connector.setPort(8080);
        jettyInstance.setConnectors(new Connector[]{connector});
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)jettyInstance, "/", false, false);
        root.setResourceBase(".");
        root.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
        jettyInstance.start();
    }

    private static void get() throws Exception {
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                return hostname.equals("localhost");
            }
        });
        String trustStore = "../chipster-environment/security/client.ts";
        String password = "password";
        System.setProperty("javax.net.ssl.keyStorePassword", password);
        System.setProperty("javax.net.ssl.trustStore", trustStore);
        URL url = new URL(protocol + "://localhost:8080/src/test/resources/affy_example.cel");
        long start = System.currentTimeMillis();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Range", "bytes=100000-200000");
        InputStream stream = connection.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy(stream, out);
        System.out.print(new String(out.toByteArray()));
        long end = System.currentTimeMillis();
        System.out.println();
        System.out.println(end - start + "ms");
        System.out.println(out.size() + " bytes");
    }
}

