/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.admin;

import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.messaging.SuccessMessageListener;
import fi.csc.microarray.messaging.TempTopicMessagingListenerBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.admin.ServerAdminAPI;
import fi.csc.microarray.messaging.admin.StorageAggregate;
import fi.csc.microarray.messaging.admin.StorageEntry;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.ParameterMessage;
import fi.csc.microarray.messaging.message.SuccessMessage;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.jms.JMSException;
import org.apache.log4j.Logger;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class StorageAdminAPI
extends ServerAdminAPI {
    private static final Logger logger = Logger.getLogger(StorageAdminAPI.class);

    public StorageAdminAPI() throws IOException, ConfigurationLoader.IllegalConfigurationException, MicroarrayException, JMSException {
        super(Topics.Name.FILEBROKER_ADMIN_TOPIC, "filebroker-admin");
    }

    public Long[] getStorageUsage() throws JMSException, InterruptedException {
        StorageTotalsMessageListener listener = new StorageTotalsMessageListener();
        return listener.query();
    }

    public List<StorageEntry> listStorageUsageOfSessions(String username) throws JMSException, InterruptedException {
        StorageEntryMessageListener listener = new StorageEntryMessageListener();
        return listener.query(username);
    }

    public List<StorageAggregate> listStorageUsageOfUsers() throws JMSException, InterruptedException {
        StorageAggregateMessageListener listener = new StorageAggregateMessageListener();
        return listener.query();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRemoteSession(String sessionID) throws JMSException, MicroarrayException {
        SuccessMessageListener replyListener = new SuccessMessageListener();
        try {
            CommandMessage removeRequestMessage = new CommandMessage("remove-session");
            removeRequestMessage.addNamedParameter("session-uuid", sessionID);
            this.getTopic().sendReplyableMessage(removeRequestMessage, replyListener);
            SuccessMessage reply = replyListener.waitForReply(30L, this.TIMEOUT_UNIT);
            this.checkSuccessMessage(reply, "delete session");
        }
        finally {
            replyListener.cleanUp();
        }
    }

    private class StorageAggregateMessageListener
    extends TempTopicMessagingListenerBase {
        private CountDownLatch latch;
        private List<StorageAggregate> entries;

        private StorageAggregateMessageListener() {
        }

        public List<StorageAggregate> query() throws JMSException, InterruptedException {
            this.latch = new CountDownLatch(1);
            CommandMessage request = new CommandMessage("get-storage-usage-by-user");
            StorageAdminAPI.this.getTopic().sendReplyableMessage(request, this);
            this.latch.await(30L, StorageAdminAPI.this.TIMEOUT_UNIT);
            return this.entries;
        }

        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            ParameterMessage resultMessage = (ParameterMessage)msg;
            String namesString = resultMessage.getNamedParameter("username-list");
            String sizesString = resultMessage.getNamedParameter("size-list");
            String[] names = namesString.split("\t");
            String[] sizes = sizesString.split("\t");
            this.entries = new LinkedList<StorageAggregate>();
            for (int i = 0; i < names.length && i < sizes.length; ++i) {
                StorageAggregate entry = new StorageAggregate();
                entry.setUsername(names[i]);
                entry.setSize(Long.parseLong(sizes[i]));
                this.entries.add(entry);
            }
            this.latch.countDown();
        }
    }

    private class StorageEntryMessageListener
    extends TempTopicMessagingListenerBase {
        private List<StorageEntry> entries;
        private CountDownLatch latch;

        private StorageEntryMessageListener() {
        }

        public List<StorageEntry> query(String username) throws JMSException, InterruptedException {
            this.latch = new CountDownLatch(1);
            CommandMessage request = new CommandMessage("get-sessions-for-user");
            request.addNamedParameter("username", username);
            StorageAdminAPI.this.getTopic().sendReplyableMessage(request, this);
            this.latch.await(30L, StorageAdminAPI.this.TIMEOUT_UNIT);
            return this.entries;
        }

        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            ParameterMessage resultMessage = (ParameterMessage)msg;
            String usernamesString = resultMessage.getNamedParameter("username-list");
            String namesString = resultMessage.getNamedParameter("session-name-list");
            String sizesString = resultMessage.getNamedParameter("size-list");
            String datesString = resultMessage.getNamedParameter("date-list");
            String idsString = resultMessage.getNamedParameter("session-uuid-list");
            String[] usernames = usernamesString.split("\t");
            String[] names = namesString.split("\t");
            String[] sizes = sizesString.split("\t");
            String[] dates = datesString.split("\t");
            String[] ids = idsString.split("\t");
            DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime();
            this.entries = new LinkedList<StorageEntry>();
            for (int i = 0; i < names.length; ++i) {
                StorageEntry entry = new StorageEntry();
                entry.setDate(dateTimeFormatter.parseDateTime(dates[i]).toDate());
                entry.setUsername(usernames[i]);
                entry.setSize(Long.parseLong(sizes[i]));
                entry.setName(names[i]);
                entry.setID(ids[i]);
                this.entries.add(entry);
            }
            this.latch.countDown();
        }
    }

    private class StorageTotalsMessageListener
    extends TempTopicMessagingListenerBase {
        private CountDownLatch latch;
        private Long usedSpace = null;
        private Long freeSpace = null;

        private StorageTotalsMessageListener() {
        }

        public Long[] query() throws JMSException, InterruptedException {
            this.latch = new CountDownLatch(1);
            CommandMessage request = new CommandMessage("get-sessions-for-session-name");
            StorageAdminAPI.this.getTopic().sendReplyableMessage(request, this);
            this.latch.await(30L, StorageAdminAPI.this.TIMEOUT_UNIT);
            if (this.usedSpace != null && this.freeSpace != null) {
                return new Long[]{this.usedSpace, this.freeSpace};
            }
            return null;
        }

        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            ParameterMessage resultMessage = (ParameterMessage)msg;
            String sizesString = resultMessage.getNamedParameter("size-list");
            String[] sizes = sizesString.split("\t");
            try {
                this.usedSpace = Long.parseLong(sizes[0]);
                this.freeSpace = Long.parseLong(sizes[1]);
            }
            catch (Exception e) {
                this.usedSpace = 0L;
                this.freeSpace = Long.MAX_VALUE;
            }
            this.latch.countDown();
        }
    }

    public static interface StorageEntryListener {
        public void process(List<StorageEntry> var1);
    }
}

