/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.admin;

import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.messaging.JMSMessagingEndpoint;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.NodeBase;
import fi.csc.microarray.messaging.TempTopicMessagingListenerBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.admin.ManagerConfiguration;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.ParameterMessage;
import fi.csc.microarray.messaging.message.ServerStatusMessage;
import fi.csc.microarray.messaging.message.SuccessMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class ServerAdminAPI {
    private static final Logger logger = Logger.getLogger(ServerAdminAPI.class);
    NodeBase nodeSupport;
    public static final long TIMEOUT = 30L;
    public final TimeUnit TIMEOUT_UNIT = TimeUnit.SECONDS;
    private MessagingTopic serverAdminTopic;
    private MessagingEndpoint messagingEndpoint;

    public ServerAdminAPI(Topics.Name topic, String nodeName) throws IOException, ConfigurationLoader.IllegalConfigurationException, MicroarrayException, JMSException {
        ManagerConfiguration.init();
        this.nodeSupport = new AdminNodeBase(nodeName);
        this.messagingEndpoint = new JMSMessagingEndpoint(this.nodeSupport);
        this.serverAdminTopic = this.messagingEndpoint.createTopic(topic, MessagingTopic.AccessMode.WRITE);
    }

    public String getStatusReport() throws JMSException, InterruptedException {
        BlockingStatusReportMessageListener listener = new BlockingStatusReportMessageListener();
        return listener.query();
    }

    public void getStatusReports(StatusReportListener listener) throws JMSException, InterruptedException {
        new AsyncStatusReportMessageListener(listener).query();
    }

    public MessagingTopic getTopic() {
        return this.serverAdminTopic;
    }

    public MessagingEndpoint getEndpoint() {
        return this.messagingEndpoint;
    }

    public void clean() {
        if (this.serverAdminTopic != null) {
            try {
                this.serverAdminTopic.delete();
            }
            catch (JMSException e) {
                logger.error((Object)e);
            }
        }
        if (this.messagingEndpoint != null) {
            try {
                this.messagingEndpoint.close();
            }
            catch (JMSException e) {
                logger.error((Object)e);
            }
        }
    }

    public void checkSuccessMessage(SuccessMessage reply, String context) throws MicroarrayException {
        if (reply == null) {
            throw new MicroarrayException(context + " failed, no reply before timeout");
        }
        if (!reply.success()) {
            throw new MicroarrayException(context + " failed: " + reply.getErrorMessage() + " " + reply.getDetails() + " " + reply.getExceptionString());
        }
    }

    private class AsyncStatusReportMessageListener
    extends TempTopicMessagingListenerBase {
        private Lock mutex = new ReentrantLock();
        private ArrayList<ServerStatusMessage> statuses;
        private StatusReportListener listener;

        public AsyncStatusReportMessageListener(StatusReportListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void query() throws JMSException, InterruptedException {
            this.mutex.lock();
            try {
                this.statuses = new ArrayList();
                CommandMessage request = new CommandMessage("get-comp-status");
                ServerAdminAPI.this.getTopic().sendReplyableMessage(request, this);
            }
            finally {
                this.mutex.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            this.mutex.lock();
            try {
                ServerStatusMessage status = (ServerStatusMessage)msg;
                this.statuses.add(status);
                this.listener.statusUpdated(this.statuses);
            }
            finally {
                this.mutex.unlock();
            }
        }
    }

    private class BlockingStatusReportMessageListener
    extends TempTopicMessagingListenerBase {
        private CountDownLatch latch;
        private String report;

        private BlockingStatusReportMessageListener() {
        }

        public String query() throws JMSException, InterruptedException {
            this.latch = new CountDownLatch(1);
            CommandMessage request = new CommandMessage("get-status-report");
            ServerAdminAPI.this.getTopic().sendReplyableMessage(request, this);
            this.latch.await(30L, ServerAdminAPI.this.TIMEOUT_UNIT);
            return this.report;
        }

        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            ParameterMessage resultMessage = (ParameterMessage)msg;
            this.report = resultMessage.getNamedParameter("status-report");
            this.latch.countDown();
        }
    }

    public static class AdminNodeBase
    extends NodeBase {
        private String name;

        public AdminNodeBase(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static interface StatusReportListener {
        public void statusUpdated(List<ServerStatusMessage> var1);
    }
}

