/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.admin;

import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.messaging.SuccessMessageListener;
import fi.csc.microarray.messaging.TempTopicMessagingListenerBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.admin.JobsEntry;
import fi.csc.microarray.messaging.admin.ServerAdminAPI;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.JobLogMessage;
import fi.csc.microarray.messaging.message.SuccessMessage;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class CompAdminAPI
extends ServerAdminAPI {
    private static final Logger logger = Logger.getLogger(CompAdminAPI.class);

    public CompAdminAPI() throws IOException, ConfigurationLoader.IllegalConfigurationException, MicroarrayException, JMSException {
        super(Topics.Name.COMP_ADMIN_TOPIC, "comp-admin");
    }

    public void queryRunningJobs(JobsListener listener) throws JMSException, InterruptedException {
        new RunningJobsMessageListener(listener).query();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopGracefullyComp(String compId) throws MicroarrayException {
        SuccessMessageListener replyListener = new SuccessMessageListener();
        try {
            CommandMessage removeRequestMessage = new CommandMessage("shutdown-comp");
            removeRequestMessage.addNamedParameter("comp-id", compId);
            this.getTopic().sendReplyableMessage(removeRequestMessage, replyListener);
            SuccessMessage reply = replyListener.waitForReply(30L, this.TIMEOUT_UNIT);
            this.checkSuccessMessage(reply, "stop comp gracefully");
        }
        catch (JMSException e) {
            logger.error((Object)"stopping comp gracefully failed", (Throwable)e);
        }
        finally {
            replyListener.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelJob(String jobId) throws MicroarrayException {
        SuccessMessageListener replyListener = new SuccessMessageListener();
        try {
            CommandMessage removeRequestMessage = new CommandMessage("cancel");
            removeRequestMessage.addNamedParameter("job-id", jobId);
            this.getTopic().sendReplyableMessage(removeRequestMessage, replyListener);
            SuccessMessage reply = replyListener.waitForReply(30L, this.TIMEOUT_UNIT);
            this.checkSuccessMessage(reply, "cancel job");
        }
        catch (JMSException e) {
            logger.error((Object)"cancel job failed", (Throwable)e);
        }
        finally {
            replyListener.cleanUp();
        }
    }

    private class RunningJobsMessageListener
    extends TempTopicMessagingListenerBase {
        private Lock mutex = new ReentrantLock();
        private HashMap<String, JobsEntry> jobs;
        private JobsListener listener;

        public RunningJobsMessageListener(JobsListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void query() throws JMSException, InterruptedException {
            this.mutex.lock();
            try {
                CommandMessage request = new CommandMessage("get-running-jobs");
                CompAdminAPI.this.getTopic().sendReplyableMessage(request, this);
                this.jobs = new HashMap();
            }
            finally {
                this.mutex.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            this.mutex.lock();
            try {
                if (msg instanceof JobLogMessage) {
                    JobLogMessage jobMsg = (JobLogMessage)msg;
                    JobsEntry job = new JobsEntry();
                    job.setJobId(jobMsg.getJobId());
                    String state = jobMsg.getState().toString();
                    if (jobMsg.getStateDetail() != null) {
                        state = state + " (" + jobMsg.getStateDetail() + ")";
                    }
                    job.setStatus(state);
                    job.setStartTime(jobMsg.getStartTime());
                    job.setCompHost(jobMsg.getCompHost());
                    job.setOperation(jobMsg.getOperation());
                    job.setUsername(jobMsg.getUsername());
                    this.jobs.put(jobMsg.getJobId(), job);
                    this.listener.statusUpdated(this.jobs.values());
                }
            }
            finally {
                this.mutex.unlock();
            }
        }
    }

    public static interface JobsListener {
        public void statusUpdated(Collection<JobsEntry> var1);
    }
}

