/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.admin;

import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.messaging.admin.CompAdminAPI;
import fi.csc.microarray.messaging.admin.JobsEntry;
import fi.csc.microarray.messaging.admin.ServerAdminAPI;
import fi.csc.microarray.messaging.message.ServerStatusMessage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;

public class CompAdmin {
    public int waitTime = 3;
    private CompAdminAPI api;

    private void printHelp() {
        System.out.println("Chipster comp admin tool\n\nUsage:\n   java -cp path/to/jar/lib/directory/*: " + CompAdmin.class.getName() + " [-h] --config=CHIPSTER-CONFIG.XML [--wait=SECONDS] [--quiet] COMMAND\n" + "\n" + "Options\n" + "   -h --help                     show this help and exit\n" + "   --config=CHIPSTER-CONFIG.XML  Chipster manager config file\n" + "   --wait=SECONDS                wait time in seconds for server responses, default 3\n" + "   -q --quiet                    do not print table headers\n" + "Commands\n" + "   --list-comps                  list compute servers' ids, hosts and status reports\n" + "   --list-jobs                   list jobs on compute servers\n" + "   --cancel=JOB                  cancel a job with given id\n" + "   --stop-gracefully=COMP        wait for running jobs to complete and stop the service with given id\n" + "   --stop-gracefully-slowest     gracefully stop the slowest server\n");
    }

    public static void main(String[] argArray) {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(argArray));
        try {
            new CompAdmin().execute(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void execute(LinkedList<String> args) throws Exception {
        String config = null;
        String stopComp = null;
        String cancelJob = null;
        Integer wait = null;
        boolean listComps = false;
        boolean listJobs = false;
        boolean shutdownOne = false;
        boolean quiet = false;
        do {
            String cmd;
            if ((cmd = args.poll()) == null) {
                cmd = "-h";
            }
            String arg = null;
            if (cmd.contains("=")) {
                String[] split = cmd.split("=");
                cmd = split[0];
                arg = split[1];
            }
            switch (cmd) {
                case "-h": 
                case "--help": {
                    this.printHelp();
                    System.exit(0);
                    break;
                }
                case "--config": {
                    config = arg;
                    break;
                }
                case "--wait": {
                    wait = Integer.parseInt(arg);
                    break;
                }
                case "-q": 
                case "--quiet": {
                    quiet = true;
                    break;
                }
                case "--list-comps": {
                    listComps = true;
                    break;
                }
                case "--list-jobs": {
                    listJobs = true;
                    break;
                }
                case "--cancel": {
                    cancelJob = arg;
                    break;
                }
                case "--stop-gracefully": {
                    stopComp = arg;
                    break;
                }
                case "--stop-gracefully-slowest": {
                    shutdownOne = true;
                    break;
                }
            }
        } while (!args.isEmpty());
        this.initConfig(config);
        this.api = new CompAdminAPI();
        if (wait != null) {
            this.waitTime = wait;
        }
        if (listJobs) {
            this.listJobs(quiet);
        }
        if (listComps) {
            this.listComps(quiet);
        }
        if (cancelJob != null) {
            this.cancelJob(cancelJob);
        }
        if (stopComp != null) {
            this.stopGracefully(stopComp);
        }
        if (shutdownOne) {
            this.stopGracefully(null);
        }
        this.api.clean();
    }

    private void initConfig(String arg) throws MalformedURLException, IOException, ConfigurationLoader.IllegalConfigurationException {
        File config = new File(arg);
        if (!config.exists()) {
            System.err.println("config file not found: " + config.getAbsolutePath());
            System.exit(1);
        }
        File logs = this.mkdir("logs");
        File security = this.mkdir("security");
        DirectoryLayout.initialiseServerLayout(Arrays.asList("manager"), config.toURI().toURL().toString());
        if (logs != null) {
            this.deleteDirAndContent(logs);
        }
        if (security != null) {
            this.deleteDirAndContent(security);
        }
    }

    private void deleteDirAndContent(File dir) {
        for (File file : dir.listFiles()) {
            file.delete();
        }
        dir.delete();
    }

    private File mkdir(String name) {
        File dir;
        File userDir = new File(System.getProperty("user.dir"));
        if (!Arrays.asList(userDir.list()).contains(name) && (dir = new File(userDir.getAbsolutePath() + File.separator + name)).mkdir()) {
            return dir;
        }
        return null;
    }

    private void stopGracefully(String compId) throws Exception {
        if (compId == null) {
            List comps = new CompList().getComps(this.api, this.waitTime);
            compId = ((ServerStatusMessage)comps.get(comps.size() - 1)).getHostId();
        }
        this.api.stopGracefullyComp(compId);
    }

    private void listComps(boolean quiet) throws Exception {
        if (!quiet) {
            System.out.println(ServerStatusMessage.getStringLineHeaders());
        }
        List comps = new CompList().getComps(this.api, this.waitTime);
        for (ServerStatusMessage status : comps) {
            System.out.println(status.toStringLine());
        }
    }

    private void listJobs(boolean quiet) throws Exception {
        if (!quiet) {
            System.out.println(JobsEntry.getToStringHeaders());
        }
        Collection jobs = new JobList().getJobs(this.api, this.waitTime);
        for (JobsEntry job : jobs) {
            System.out.println(job.toString());
        }
    }

    private void cancelJob(String jobId) throws MicroarrayException, IOException, ConfigurationLoader.IllegalConfigurationException, JMSException {
        this.api.cancelJob(jobId);
    }

    class JobList {
        private Collection<JobsEntry> jobs;

        JobList() {
        }

        private Collection<JobsEntry> getJobs(CompAdminAPI api, int wait) throws Exception {
            this.jobs = new ArrayList<JobsEntry>();
            api.queryRunningJobs(new CompAdminAPI.JobsListener(){

                @Override
                public void statusUpdated(Collection<JobsEntry> collection) {
                    JobList.this.jobs = collection;
                }
            });
            Thread.sleep(wait * 1000);
            return this.jobs;
        }
    }

    class CompList {
        private List<ServerStatusMessage> comps;

        CompList() {
        }

        private List<ServerStatusMessage> getComps(CompAdminAPI api, int wait) throws Exception {
            this.comps = new ArrayList<ServerStatusMessage>();
            api.getStatusReports(new ServerAdminAPI.StatusReportListener(){

                @Override
                public void statusUpdated(List<ServerStatusMessage> statuses) {
                    CompList.this.comps = statuses;
                }
            });
            Thread.sleep(wait * 1000);
            return this.comps;
        }
    }
}

