/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.messaging.DirectMessagingTopic;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.auth.AuthenticationRequestListener;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import java.util.HashMap;
import javax.jms.JMSException;

public class DirectMessagingEndpoint
implements MessagingEndpoint {
    private String username;
    private HashMap<ChipsterMessage, DirectMessagingTopic> replyTopicMap = new HashMap();
    private HashMap<Topics.Name, DirectMessagingTopic> topicMap = new HashMap();

    public DirectMessagingEndpoint() {
    }

    public DirectMessagingEndpoint(String username) {
        this.username = username;
    }

    public void mapReplyTopic(ChipsterMessage original, DirectMessagingTopic replyTopic) {
        this.replyTopicMap.put(original, replyTopic);
    }

    @Override
    public MessagingTopic createTopic(Topics.Name topicName, MessagingTopic.AccessMode accessMode) throws JMSException {
        if (topicName == Topics.Name.FILEBROKER_TOPIC) {
            topicName = Topics.Name.AUTHORISED_FILEBROKER_TOPIC;
        } else if (topicName == Topics.Name.FEEDBACK_TOPIC) {
            topicName = Topics.Name.AUTHORISED_FEEDBACK_TOPIC;
        } else if (topicName == Topics.Name.REQUEST_TOPIC) {
            topicName = Topics.Name.AUTHORISED_REQUEST_TOPIC;
        }
        if (!this.topicMap.containsKey((Object)topicName)) {
            this.topicMap.put(topicName, new DirectMessagingTopic(topicName.name(), accessMode, this));
        }
        return this.topicMap.get((Object)topicName);
    }

    @Override
    public void replyToMessage(ChipsterMessage original, ChipsterMessage reply) throws JMSException {
        DirectMessagingTopic replyTopic = this.replyTopicMap.get(original);
        if (replyTopic == null) {
            throw new IllegalArgumentException("Can't send reply: " + reply + ", because there isn't reply topic for original message: " + original);
        }
        replyTopic.sendMessage(reply);
        this.replyTopicMap.remove(original);
    }

    @Override
    public void replyToMessage(ChipsterMessage original, ChipsterMessage reply, String replyChannel) throws JMSException {
        this.replyToMessage(original, reply);
    }

    @Override
    public void close() throws JMSException {
    }

    @Override
    public AuthenticationRequestListener getAuthenticationListener() {
        throw new UnsupportedOperationException("not supported by DirectMessagingEndpoint");
    }

    @Override
    public void setAuthenticationListener(AuthenticationRequestListener authenticationListener) {
        throw new UnsupportedOperationException("not supported by DirectMessagingEndpoint");
    }

    @Override
    public String getSessionID() {
        throw new UnsupportedOperationException("not supported by DirectMessagingEndpoint");
    }

    @Override
    public void setSessionID(String sessionID) {
        throw new UnsupportedOperationException("not supported by DirectMessagingEndpoint");
    }

    public String getUsername() {
        return this.username;
    }
}

