/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.manager;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class BackupRotation {
    private final Logger logger = Logger.getLogger(BackupRotation.class);
    private File backupRoot;
    private static final int ROTATION_COUNT = 30;
    private static final int ROTATION_DAYS = 30;
    private static final String filenamePrefix = "chipster-manager-db-backup-";
    private static final String filenamePostfix = ".zip";

    public BackupRotation(File backupRoot) {
        this.backupRoot = backupRoot;
    }

    public int rotate() {
        TreeMap<DateTime, File> filesToDelete = new TreeMap<DateTime, File>();
        this.parseFilenames(filesToDelete);
        this.removeLastItems(filesToDelete, 30);
        this.removeNewerThan(filesToDelete, 30);
        this.removeFirstOfEachMonth(filesToDelete);
        for (File file : filesToDelete.values()) {
            this.logger.debug((Object)("backup rotation deletes file " + file));
            file.delete();
        }
        return filesToDelete.size();
    }

    private void removeFirstOfEachMonth(TreeMap<DateTime, File> filesToDelete) {
        HashSet<DateTime> months = new HashSet<DateTime>();
        Iterator<DateTime> filesIter = filesToDelete.keySet().iterator();
        while (filesIter.hasNext()) {
            DateTime fileDate = filesIter.next();
            DateTime month = new DateTime(fileDate.getYear(), fileDate.getMonthOfYear(), 1, 0, 0);
            if (months.contains(month)) continue;
            filesIter.remove();
            months.add(month);
        }
    }

    private void removeNewerThan(TreeMap<DateTime, File> filesToDelete, int days) {
        DateTime date = new DateTime();
        date = date.minusDays(days);
        Iterator<DateTime> filesIter = filesToDelete.keySet().iterator();
        while (filesIter.hasNext()) {
            DateTime fileDate = filesIter.next();
            if (!fileDate.isAfter((ReadableInstant)date)) continue;
            filesIter.remove();
        }
    }

    private void removeLastItems(TreeMap<DateTime, File> filesToDelete, int count) {
        for (int i = 0; i < count && !filesToDelete.isEmpty(); ++i) {
            filesToDelete.remove(filesToDelete.lastKey());
        }
    }

    private void parseFilenames(TreeMap<DateTime, File> filesToDelete) {
        for (File file : this.backupRoot.listFiles()) {
            String filename = file.getName();
            if (!filename.startsWith(filenamePrefix) || !filename.endsWith(filenamePostfix)) continue;
            String dateString = filename.substring(filenamePrefix.length(), filename.length() - filenamePostfix.length());
            DateTime fileDate = null;
            try {
                fileDate = ISODateTimeFormat.dateTime().parseDateTime(dateString);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            filesToDelete.put(fileDate, file);
        }
    }

    public File getBackupFile(DateTime date) {
        return new File(this.backupRoot, filenamePrefix + date + filenamePostfix);
    }

    public static void main(String[] args) throws IOException {
        File backupRoot = new File("test-backups");
        backupRoot.mkdir();
        BackupRotation rotation = new BackupRotation(backupRoot);
        rotation.createFakeBackupFiles();
        rotation.rotate();
        TreeMap<DateTime, File> keptFiles = new TreeMap<DateTime, File>();
        rotation.parseFilenames(keptFiles);
        for (File file : keptFiles.values()) {
            System.out.println(file);
        }
    }

    private void createFakeBackupFiles() throws IOException {
        DateTime date = new DateTime(2010, 1, 1, 5, 0);
        while (date.isBeforeNow()) {
            File backupFile = this.getBackupFile(date);
            backupFile.createNewFile();
            date = date.plus(86400000L);
        }
    }
}

