/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.client.RemoteServiceAccessor;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.session.SessionManager;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.filebroker.JMSFileBrokerClient;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.module.ModuleManager;
import java.io.File;
import java.net.MalformedURLException;
import java.util.regex.Pattern;

public class ServerSessionImportExportTool {
    private static final String LOCAL_FILEBROKER_IP = "127.0.0.1";
    public DataManager dataManager = new DataManager();
    private SessionManager sessionManager;
    private static Pattern nameCheck = Pattern.compile("[a-zA-Z0-9_\\-\\.\\ \\(\\)]*");

    public ServerSessionImportExportTool(MessagingEndpoint endpoint) throws Exception {
        RemoteServiceAccessor serviceAccessor = new RemoteServiceAccessor();
        JMSFileBrokerClient fileBrokerClient = new JMSFileBrokerClient(endpoint.createTopic(Topics.Name.FILEBROKER_TOPIC, MessagingTopic.AccessMode.WRITE), null, LOCAL_FILEBROKER_IP);
        serviceAccessor.initialise(endpoint, this.dataManager, fileBrokerClient);
        this.sessionManager = new SessionManager(this.dataManager, fileBrokerClient, null);
        ModuleManager moduleManager = new ModuleManager();
        moduleManager.plugAll(this.dataManager, null);
        Session.getSession().setDataManager(this.dataManager);
        Session.getSession().setServiceAccessor(serviceAccessor);
        Session.getSession().setModuleManager(moduleManager);
    }

    public void importSession(File session) throws Exception {
        this.sessionManager.loadLocalSession(session, false);
        String saveName = this.filenameToBasename(session.getName());
        this.sessionManager.saveStorageSession(saveName);
        this.dataManager.deleteAllDataItems();
    }

    public void exportSession(String uuid, File zipFile) throws MalformedURLException, Exception {
        this.sessionManager.loadStorageSession(uuid);
        this.sessionManager.saveSession(zipFile);
        this.dataManager.deleteAllDataItems();
    }

    public String basenameToFileName(String dbSessionName) throws IllegalArgumentException {
        if (nameCheck.matcher(dbSessionName).matches()) {
            return dbSessionName + ".zip";
        }
        throw new IllegalArgumentException("Illegal character in server session name '" + dbSessionName + "'");
    }

    public String filenameToBasename(String filename) throws IllegalArgumentException {
        if (nameCheck.matcher(filename).matches()) {
            return filename.replaceAll(".zip$", "");
        }
        throw new IllegalArgumentException("Illegal character in filename '" + filename + "'");
    }
}

