/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.filebroker.AuthorisedUrlRepository;
import fi.csc.microarray.filebroker.DerbyMetadataServer;
import fi.csc.microarray.filebroker.DiskCleanUp;
import fi.csc.microarray.filebroker.RestServlet;
import fi.csc.microarray.util.KeyAndTrustManager;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyFileServer {
    private Server jettyInstance;
    private AuthorisedUrlRepository urlRepository;
    private DerbyMetadataServer metadataServer;
    private DiskCleanUp cacheCleanUp;

    public JettyFileServer(AuthorisedUrlRepository urlRepository, DerbyMetadataServer metadataServer, DiskCleanUp cacheCleanUp) {
        this.urlRepository = urlRepository;
        this.metadataServer = metadataServer;
        this.cacheCleanUp = cacheCleanUp;
    }

    public void start(String resourceBase, int port, String protocol) throws Exception {
        SelectChannelConnector connector;
        if (DirectoryLayout.getInstance().getConfiguration().getBoolean("filebroker", "jetty-debug")) {
            System.setProperty("org.eclipse.jetty.LEVEL", "DEBUG");
        }
        this.jettyInstance = new Server();
        this.jettyInstance.setThreadPool((ThreadPool)new QueuedThreadPool());
        switch (protocol) {
            case "http": {
                connector = new SelectChannelConnector();
                break;
            }
            case "https": {
                Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
                connector = new SslSocketConnector(KeyAndTrustManager.createSslContextFactory(configuration.getString("security", "filebroker-keystore"), configuration.getString("security", "storepass")));
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported protocol: " + protocol + " (supported are http and https)");
            }
        }
        connector.setServer(this.jettyInstance);
        connector.setPort(port);
        this.jettyInstance.setConnectors(new Connector[]{connector});
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)this.jettyInstance, "/", false, false);
        root.getInitParams().put("org.eclipse.jetty.servlet.Default.aliases", "true");
        root.setResourceBase(resourceBase);
        root.addServlet(new ServletHolder((Servlet)new RestServlet(this.urlRepository.getRootUrl(), this.urlRepository, this.metadataServer, this.cacheCleanUp)), "/*");
        this.jettyInstance.start();
    }

    public boolean isRunning() {
        return this.jettyInstance.isRunning();
    }
}

