/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.description;

import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLSyntax;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.chipster.ChipsterInputTypes;
import fi.csc.microarray.module.chipster.ChipsterSADLParser;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class SADLParserTest {
    @Test
    public void testVVSADLCompatibility() throws MicroarrayException, IOException {
        String vvsadl = "ANALYSIS \"Test utilities\"/\"Test tool\" (Just a test analysis for development. These descriptions are sometimes very\nlong and might get hard to read.)\nINPUT CDNA microarray[...].txt OUTPUT results.txt, messages.txt\nPARAMETER value1 INTEGER FROM 0 TO 200 DEFAULT 10 (the first value of the result set)\nPARAMETER value2 DECIMAL FROM 0 TO 200 DEFAULT 20 (the second value of the result set)\nPARAMETER value3 DECIMAL FROM 0 TO 200 DEFAULT 30.2 (the third value of the result set)\nPARAMETER method PERCENT DEFAULT 34 (how much we need)\nPARAMETER method [linear, logarithmic, exponential] DEFAULT logarithmic (which scale to use)\nPARAMETER genename STRING DEFAULT at_something (which gene we are interested in)\nPARAMETER key COLUMN_SEL (which column we use as a key)";
        SADLDescription parsedDescription = new ChipsterSADLParser().parse(vvsadl);
        Assert.assertNotNull((Object)parsedDescription);
        Assert.assertEquals((Object)parsedDescription.getName().getID(), (Object)"Test tool");
        Assert.assertEquals((Object)parsedDescription.getName().getDisplayName(), (Object)"Test tool");
        Assert.assertTrue((boolean)parsedDescription.getComment().startsWith("Just a test analysis"));
        Assert.assertEquals((long)parsedDescription.inputs().size(), (long)1L);
        Assert.assertTrue((boolean)parsedDescription.inputs().get(0).getName().isNameSet());
        Assert.assertEquals((long)parsedDescription.outputs().size(), (long)2L);
        Assert.assertEquals((long)parsedDescription.parameters().size(), (long)7L);
        Assert.assertEquals((long)parsedDescription.parameters().get(4).getSelectionOptions().length, (long)3L);
    }

    @Test
    public void testParsing() throws MicroarrayException, IOException {
        String sadl = "TOOL util-test.R: \"Test tool\" (Just a test analysis for development. These descriptions are sometimes very\nlong and might get hard to read. (Note that certain operators must be escaped.\\))\nINPUT microarray{...}.tsv: \"Raw data files\" TYPE CDNA\nINPUT phenodata.tsv: \"Experiment description\" TYPE GENERIC\nOUTPUT result{...}.txt: \"Result files\"\nOUTPUT OPTIONAL error.txt: \"Error, if any\" (Here's an example of a comment on an output file.)\nPARAMETER value1: \"The first value\" TYPE INTEGER FROM 0 TO 200 DEFAULT 10 (the first value of the result set)\nPARAMETER value2: \"The second value\" TYPE DECIMAL FROM 0 TO 200 DEFAULT 20 (the second value of the result set)\nPARAMETER OPTIONAL value3: \"The third value\" TYPE DECIMAL FROM 0 TO 200 DEFAULT 30.2 (the third value of the result set)\nPARAMETER value4: \"The fourth value\" TYPE PERCENT DEFAULT 34 (how much we need)\nPARAMETER method: \"The enumeration\" TYPE [option1: \"First option\", option2: \"Second option\", option3: \"Third option\"] FROM 1 TO 2 DEFAULT option1, option2 (which options are selected)\nPARAMETER genename: \"Gene name\" TYPE STRING DEFAULT at_something (which gene we are interested in)\nPARAMETER key: \"Key column\" TYPE COLUMN_SEL (which column we use as a key)";
        SADLDescription parsedDescription = new ChipsterSADLParser().parse(sadl);
        Assert.assertNotNull((Object)parsedDescription);
        Assert.assertEquals((Object)parsedDescription.getName().getID(), (Object)"util-test.R");
        Assert.assertEquals((Object)parsedDescription.getName().getDisplayName(), (Object)"Test tool");
        Assert.assertEquals((Object)parsedDescription.getName().toString(), (Object)"util-test.R: \"Test tool\"");
        Assert.assertTrue((boolean)parsedDescription.getComment().startsWith("Just a test analysis"));
        Assert.assertTrue((boolean)parsedDescription.getComment().endsWith("must be escaped.)"));
        Assert.assertEquals((long)parsedDescription.inputs().size(), (long)2L);
        Assert.assertTrue((boolean)parsedDescription.inputs().get(0).getName().isNameSet());
        Assert.assertEquals((Object)parsedDescription.inputs().get(0).getName().getPrefix(), (Object)"microarray");
        Assert.assertEquals((Object)parsedDescription.inputs().get(0).getName().getPostfix(), (Object)".tsv");
        Assert.assertEquals((Object)parsedDescription.inputs().get(0).getName().getDisplayName(), (Object)"Raw data files");
        Assert.assertEquals((Object)parsedDescription.inputs().get(0).getType().getName(), (Object)"CDNA");
        Assert.assertFalse((boolean)parsedDescription.inputs().get(0).isOptional());
        Assert.assertEquals((Object)parsedDescription.inputs().get(1).getName().toString(), (Object)"phenodata.tsv: \"Experiment description\"");
        Assert.assertEquals((Object)parsedDescription.inputs().get(1).getType().getName(), (Object)"GENERIC");
        Assert.assertFalse((boolean)parsedDescription.inputs().get(1).isOptional());
        Assert.assertEquals((long)parsedDescription.outputs().size(), (long)2L);
        Assert.assertTrue((boolean)parsedDescription.outputs().get(0).getName().isNameSet());
        Assert.assertEquals((Object)parsedDescription.outputs().get(0).getName().getPrefix(), (Object)"result");
        Assert.assertEquals((Object)parsedDescription.outputs().get(0).getName().getPostfix(), (Object)".txt");
        Assert.assertEquals((Object)parsedDescription.outputs().get(0).getName().getDisplayName(), (Object)"Result files");
        Assert.assertFalse((boolean)parsedDescription.outputs().get(0).isOptional());
        Assert.assertEquals((Object)parsedDescription.outputs().get(1).getName().toString(), (Object)"error.txt: \"Error, if any\"");
        Assert.assertEquals((Object)parsedDescription.outputs().get(1).getComment(), (Object)"Here's an example of a comment on an output file.");
        Assert.assertTrue((boolean)parsedDescription.outputs().get(1).isOptional());
        Assert.assertEquals((long)parsedDescription.parameters().size(), (long)7L);
        Assert.assertEquals((Object)parsedDescription.parameters().get(0).getName().toString(), (Object)"value1: \"The first value\"");
        Assert.assertEquals((Object)((Object)parsedDescription.parameters().get(0).getType()), (Object)((Object)SADLSyntax.ParameterType.INTEGER));
        Assert.assertEquals((Object)parsedDescription.parameters().get(0).getFrom(), (Object)"0");
        Assert.assertEquals((Object)parsedDescription.parameters().get(0).getTo(), (Object)"200");
        Assert.assertEquals((Object)parsedDescription.parameters().get(0).getDefaultValue(), (Object)"10");
        Assert.assertEquals((Object)parsedDescription.parameters().get(0).getComment(), (Object)"the first value of the result set");
        Assert.assertFalse((boolean)parsedDescription.parameters().get(0).isOptional());
        Assert.assertEquals((Object)parsedDescription.parameters().get(1).getName().toString(), (Object)"value2: \"The second value\"");
        Assert.assertEquals((Object)((Object)parsedDescription.parameters().get(1).getType()), (Object)((Object)SADLSyntax.ParameterType.DECIMAL));
        Assert.assertEquals((Object)parsedDescription.parameters().get(1).getFrom(), (Object)"0");
        Assert.assertEquals((Object)parsedDescription.parameters().get(1).getTo(), (Object)"200");
        Assert.assertEquals((Object)parsedDescription.parameters().get(1).getDefaultValue(), (Object)"20");
        Assert.assertEquals((Object)parsedDescription.parameters().get(1).getComment(), (Object)"the second value of the result set");
        Assert.assertFalse((boolean)parsedDescription.parameters().get(1).isOptional());
        Assert.assertEquals((Object)parsedDescription.parameters().get(2).getName().toString(), (Object)"value3: \"The third value\"");
        Assert.assertEquals((Object)((Object)parsedDescription.parameters().get(2).getType()), (Object)((Object)SADLSyntax.ParameterType.DECIMAL));
        Assert.assertEquals((Object)parsedDescription.parameters().get(2).getFrom(), (Object)"0");
        Assert.assertEquals((Object)parsedDescription.parameters().get(2).getTo(), (Object)"200");
        Assert.assertEquals((Object)parsedDescription.parameters().get(2).getDefaultValue(), (Object)"30.2");
        Assert.assertEquals((Object)parsedDescription.parameters().get(2).getComment(), (Object)"the third value of the result set");
        Assert.assertTrue((boolean)parsedDescription.parameters().get(2).isOptional());
        Assert.assertEquals((Object)parsedDescription.parameters().get(3).getName().toString(), (Object)"value4: \"The fourth value\"");
        Assert.assertEquals((Object)((Object)parsedDescription.parameters().get(3).getType()), (Object)((Object)SADLSyntax.ParameterType.PERCENT));
        Assert.assertEquals((Object)parsedDescription.parameters().get(3).getDefaultValue(), (Object)"34");
        Assert.assertEquals((Object)parsedDescription.parameters().get(3).getComment(), (Object)"how much we need");
        Assert.assertFalse((boolean)parsedDescription.parameters().get(3).isOptional());
        Assert.assertEquals((Object)parsedDescription.parameters().get(4).getName().toString(), (Object)"method: \"The enumeration\"");
        Assert.assertEquals((Object)((Object)parsedDescription.parameters().get(4).getType()), (Object)((Object)SADLSyntax.ParameterType.ENUM));
        Assert.assertEquals((long)parsedDescription.parameters().get(4).getDefaultValues().length, (long)2L);
        Assert.assertEquals((Object)parsedDescription.parameters().get(4).getDefaultValues()[0], (Object)"option1");
        Assert.assertEquals((Object)parsedDescription.parameters().get(4).getDefaultValues()[1], (Object)"option2");
        Assert.assertEquals((Object)parsedDescription.parameters().get(4).getComment(), (Object)"which options are selected");
        Assert.assertEquals((Object)parsedDescription.parameters().get(4).getFrom(), (Object)"1");
        Assert.assertEquals((Object)parsedDescription.parameters().get(4).getTo(), (Object)"2");
        Assert.assertEquals((long)parsedDescription.parameters().get(4).getSelectionOptions().length, (long)3L);
        Assert.assertEquals((Object)parsedDescription.parameters().get(4).getSelectionOptions()[0].toString(), (Object)"option1: \"First option\"");
        Assert.assertEquals((Object)parsedDescription.parameters().get(4).getSelectionOptions()[1].toString(), (Object)"option2: \"Second option\"");
        Assert.assertEquals((Object)parsedDescription.parameters().get(4).getSelectionOptions()[2].toString(), (Object)"option3: \"Third option\"");
        Assert.assertFalse((boolean)parsedDescription.parameters().get(4).isOptional());
        Assert.assertEquals((Object)parsedDescription.parameters().get(5).getName().toString(), (Object)"genename: \"Gene name\"");
        Assert.assertEquals((Object)((Object)parsedDescription.parameters().get(5).getType()), (Object)((Object)SADLSyntax.ParameterType.STRING));
        Assert.assertEquals((Object)parsedDescription.parameters().get(5).getDefaultValue(), (Object)"at_something");
        Assert.assertEquals((Object)parsedDescription.parameters().get(5).getComment(), (Object)"which gene we are interested in");
        Assert.assertFalse((boolean)parsedDescription.parameters().get(5).isOptional());
        Assert.assertEquals((Object)parsedDescription.parameters().get(6).getName().toString(), (Object)"key: \"Key column\"");
        Assert.assertEquals((Object)((Object)parsedDescription.parameters().get(6).getType()), (Object)((Object)SADLSyntax.ParameterType.COLUMN_SEL));
        Assert.assertEquals((Object)parsedDescription.parameters().get(6).getComment(), (Object)"which column we use as a key");
        Assert.assertFalse((boolean)parsedDescription.parameters().get(6).isOptional());
    }

    @Test
    public void testRoundtrip() throws MicroarrayException, IOException {
        SADLDescription description = this.generateDescription();
        String string = description.toString();
        SADLDescription parsedDescription = new ChipsterSADLParser().parse(string);
        String anotherString = parsedDescription.toString();
        Assert.assertEquals((Object)string, (Object)anotherString);
        Assert.assertEquals((Object)parsedDescription.inputs().get(0).getName().getID(), (Object)"input1");
        Assert.assertEquals((Object)parsedDescription.inputs().get(0).getComment(), (Object)"input comment");
        Assert.assertTrue((boolean)parsedDescription.inputs().get(0).isOptional());
        Assert.assertEquals((Object)parsedDescription.inputs().get(1).getName().getPrefix(), (Object)"input2");
        Assert.assertEquals((long)parsedDescription.inputs().size(), (long)4L);
        Assert.assertEquals((long)parsedDescription.parameters().size(), (long)3L);
        Assert.assertEquals((Object)parsedDescription.parameters().get(1).getFrom(), (Object)"1");
        Assert.assertEquals((Object)parsedDescription.parameters().get(2).getDefaultValue(), (Object)"");
    }

    @Test
    public void testEscapes() throws MicroarrayException, IOException {
        SADLDescription description = this.generateDescription();
        Assert.assertEquals((Object)description.getComment(), (Object)"main comment (funny)");
        String string = description.toString();
        Assert.assertTrue((boolean)string.contains("main comment (funny\\)"));
        SADLDescription parsedDescription = new ChipsterSADLParser().parse(string);
        Assert.assertEquals((Object)parsedDescription.getComment(), (Object)"main comment (funny)");
        String anotherString = parsedDescription.toString();
        Assert.assertTrue((boolean)anotherString.contains("main comment (funny\\)"));
    }

    private SADLDescription generateDescription() {
        SADLDescription description = new SADLDescription(SADLDescription.Name.createName("name", "longname/displayname"), "main comment (funny)");
        SADLDescription.Input input = new SADLDescription.Input(ChipsterInputTypes.GENE_EXPRS, SADLDescription.Name.createName("input1", "input1"), true);
        input.setComment("input comment");
        description.addInput(input);
        description.addInput(new SADLDescription.Input(ChipsterInputTypes.GENE_EXPRS, SADLDescription.Name.createNameSet("input2", ".ext", "input set 2")));
        description.addInput(new SADLDescription.Input(ChipsterInputTypes.GENE_EXPRS, SADLDescription.Name.createName("metainput1", "metainput1"), false, true));
        description.addInput(new SADLDescription.Input(ChipsterInputTypes.GENE_EXPRS, SADLDescription.Name.createNameSet("metainput2", ".ext", "meta input set 2"), false, true));
        description.addOutput(new SADLDescription.Output(SADLDescription.Name.createName("output1", "output1")));
        description.addOutput(new SADLDescription.Output(SADLDescription.Name.createName("metaoutput1", "metaoutput1"), false, true));
        description.addParameter(new SADLDescription.Parameter(SADLDescription.Name.createName("parameter1", "parameter1"), SADLSyntax.ParameterType.DECIMAL, null, "1", "3", "2", "param comment 1"));
        description.addParameter(new SADLDescription.Parameter(SADLDescription.Name.createName("parameter2", "parameter2"), SADLSyntax.ParameterType.ENUM, new SADLDescription.Name[]{SADLDescription.Name.createName("1"), SADLDescription.Name.createName("2"), SADLDescription.Name.createName("3")}, "1", "2", new String[]{"1", "2"}, "param comment 2"));
        description.addParameter(new SADLDescription.Parameter(SADLDescription.Name.createName("parameter3", "parameter3"), SADLSyntax.ParameterType.STRING, null, null, null, "", "empty default value"));
        return description;
    }

    public static void main(String[] args) throws MicroarrayException, IOException, ConfigurationLoader.IllegalConfigurationException {
        new SADLParserTest().testParsing();
        new SADLParserTest().testRoundtrip();
        new SADLParserTest().testEscapes();
        new SADLParserTest().testVVSADLCompatibility();
        System.out.println("SADLParserTest OK");
    }
}

