/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.chipster.MicroarrayModule;
import fi.csc.microarray.util.Strings;

public class HistoryText {
    private String[] sourceCodes;
    private DataBean data;
    private ClientApplication application = Session.getSession().getApplication();

    public HistoryText(DataBean data) {
        this.data = data;
        this.sourceCodes = null;
    }

    public String getHistoryText(boolean title, boolean name, boolean date, boolean oper, boolean code, boolean notes, boolean param) {
        if (this.data == null) {
            return null;
        }
        StringBuffer historyText = new StringBuffer();
        int i = 0;
        for (DataBean listData : MicroarrayModule.getSourcePath(this.data)) {
            String notesText;
            block17: {
                if (title) {
                    String titleText = "Step " + (i + 1);
                    historyText.append(titleText + "\n");
                    historyText.append(Strings.repeat("-", titleText.length()) + "\n\n");
                }
                if (name) {
                    historyText.append("Dataset name: " + listData.getName() + "\n");
                }
                if (date) {
                    historyText.append("Created " + listData.getDate().toString() + "\n");
                }
                if (oper) {
                    OperationRecord operationRecord = listData.getOperationRecord();
                    historyText.append("Created with operation: ");
                    if (operationRecord != null) {
                        historyText.append(operationRecord.getFullName() + "\n");
                        if (param) {
                            for (OperationRecord.ParameterRecord parameterRecord : operationRecord.getParameters()) {
                                OperationDefinition tool = this.application.getOperationDefinition(operationRecord.getNameID().getID());
                                String valueString = null;
                                valueString = tool != null ? tool.getHumanReadableParameterValue(parameterRecord) : parameterRecord.getValue();
                                historyText.append("Parameter " + parameterRecord.getNameID().getDisplayName() + ": " + valueString + "\n");
                            }
                        } else {
                            historyText.append("\n");
                        }
                        if (code) {
                            try {
                                String[] sources = this.getSourceCodes();
                                if (sources[i] != null) {
                                    historyText.append("Operation source code:\n" + Strings.indent(sources[i], 4) + "\n");
                                    break block17;
                                }
                                historyText.append("Operation source code: <not available>\n");
                            }
                            catch (MicroarrayException e) {
                                Session.getSession().getApplication().reportException(e);
                            }
                        }
                    } else {
                        historyText.append("<last operation unknown>\n");
                    }
                }
            }
            if (notes && (notesText = listData.getNotes()) != null) {
                historyText.append("Notes: " + notesText + "\n");
            }
            if (listData != this.data) {
                historyText.append("\n");
            }
            ++i;
        }
        return historyText.toString();
    }

    private String[] getSourceCodes() throws MicroarrayException {
        if (this.sourceCodes == null) {
            DataBean[] sourceDatas = MicroarrayModule.getSourcePath(this.data);
            this.sourceCodes = new String[sourceDatas.length];
            for (int i = 0; i < sourceDatas.length; ++i) {
                this.sourceCodes[i] = sourceDatas[i].getOperationRecord().getSourceCode();
            }
        }
        return this.sourceCodes;
    }
}

