/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans;

import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.databeans.ContentChangedEvent;
import fi.csc.microarray.databeans.ContentType;
import fi.csc.microarray.databeans.DataBeanSelector;
import fi.csc.microarray.databeans.DataItemBase;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.LinksChangedEvent;
import fi.csc.microarray.databeans.TypeTag;
import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.QueryResult;
import fi.csc.microarray.databeans.features.RequestExecuter;
import fi.csc.microarray.security.CryptoKey;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DataBean
extends DataItemBase {
    private DataManager dataManager;
    private HashMap<String, Object> contentBoundCache = new HashMap();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private LinkedList<LinkedBean> outgoingLinks = new LinkedList();
    private LinkedList<LinkedBean> incomingLinks = new LinkedList();
    private LinkedList<TypeTag> tags = new LinkedList();
    private boolean tagsSet = false;
    private String id;
    private Date date;
    private OperationRecord operationRecord;
    private String notes;
    private ContentType contentType;
    private LinkedList<DataManager.ContentLocation> contentLocations = new LinkedList();
    private Long size;
    private String checksum;
    private Integer x;
    private Integer y;

    public DataBean(String name, ContentType contentType, DataManager manager) {
        this(name, contentType, manager, CryptoKey.generateRandom());
    }

    public DataBean(String name, ContentType contentType, DataManager manager, String dataId) {
        this.name = name;
        this.contentType = contentType;
        this.dataManager = manager;
        this.id = dataId;
        this.date = new Date();
    }

    public String getId() {
        return this.id;
    }

    public OperationRecord getOperationRecord() {
        return this.operationRecord;
    }

    public void setOperationRecord(OperationRecord operationRecord) {
        this.operationRecord = operationRecord;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getNotes() {
        return this.notes;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public boolean isContentTypeCompatitible(String ... alternatives) {
        for (String alternative : alternatives) {
            if (!alternative.toLowerCase().equals(this.getContentType().getType().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public Date getDate() {
        return this.date;
    }

    public void setId(String newId) {
        this.id = newId;
    }

    @Override
    public void setName(String newName) {
        super.setName(newName);
        ContentChangedEvent cce = new ContentChangedEvent(this);
        this.dataManager.dispatchEventIfVisible(cce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult queryFeatures(String request) {
        try {
            this.lock.readLock().lock();
            Feature feature = new RequestExecuter(this.dataManager).execute(request, this);
            if (feature == null) {
                throw new UnsupportedOperationException("request " + request + " not possible from " + this.getName());
            }
            QueryResult queryResult = new QueryResult(feature);
            return queryResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        for (DataManager.ContentLocation contentLocation : this.contentLocations) {
            contentLocation.getHandler().markDeletable(contentLocation);
        }
        this.contentType = null;
    }

    public void putToContentBoundCache(String name, Object value) {
        this.contentBoundCache.put(name, value);
    }

    public Object getFromContentBoundCache(String name) {
        return this.contentBoundCache.get(name);
    }

    protected void resetContentBoundCache() {
        this.contentBoundCache.clear();
    }

    public void addLink(Link type, DataBean target) {
        if (target == null) {
            return;
        }
        target.incomingLinks.add(new LinkedBean(type, this));
        this.outgoingLinks.add(new LinkedBean(type, target));
        if (this.getParent() != null && target.getParent() != null) {
            LinksChangedEvent lce = new LinksChangedEvent(this, target, type, true);
            this.dataManager.dispatchEvent(lce);
        }
    }

    public void removeLink(Link type, DataBean target) {
        for (LinkedBean outgoingLink : this.outgoingLinks) {
            if (outgoingLink.bean != target || outgoingLink.link != type) continue;
            this.outgoingLinks.remove(outgoingLink);
            DataBean bean = outgoingLink.bean;
            for (LinkedBean incomingLink : bean.incomingLinks) {
                if (incomingLink.bean != this || incomingLink.link != type) continue;
                bean.incomingLinks.remove(incomingLink);
                LinksChangedEvent lce = new LinksChangedEvent(this, target, type, false);
                this.dataManager.dispatchEventIfVisible(lce);
                return;
            }
        }
        throw new RuntimeException("internal error: failed locate links for: " + this.getName() + " <" + (Object)((Object)type) + "> " + target.getName());
    }

    public List<DataBean> traverseLinks(Link[] types, Traversal traversal) {
        DataBeanSelector acceptAllSelector = new DataBeanSelector(){

            @Override
            public boolean shouldSelect(DataBean bean) {
                return true;
            }

            @Override
            public boolean shouldTraverse(DataBean bean) {
                return true;
            }
        };
        return this.traverseLinks(types, traversal, acceptAllSelector);
    }

    public List<DataBean> traverseLinks(Link[] types, Traversal traversal, DataBeanSelector selector) {
        LinkedHashSet<DataBean> newBeans;
        LinkedList<DataBean> selected = new LinkedList<DataBean>();
        LinkedList<DataBean> traversed = new LinkedList<DataBean>();
        traversed.add(this);
        this.conditionallySelect(selector, selected, this);
        do {
            newBeans = new LinkedHashSet<DataBean>();
            for (DataBean bean : traversed) {
                LinkedHashSet<DataBean> linkedBeans = new LinkedHashSet<DataBean>();
                if (traversal.isDirect()) {
                    for (Link type : types) {
                        linkedBeans.addAll(bean.getLinkTargets(type));
                    }
                }
                if (traversal.isReversed()) {
                    for (Link type : types) {
                        linkedBeans.addAll(bean.getLinkSources(type));
                    }
                }
                for (DataBean linkedBean : linkedBeans) {
                    if (traversed.contains(linkedBean) || !selector.shouldTraverse(linkedBean)) continue;
                    newBeans.add(linkedBean);
                }
            }
            for (DataBean newBean : newBeans) {
                traversed.add(newBean);
                this.conditionallySelect(selector, selected, newBean);
            }
        } while (newBeans.size() > 0);
        return selected;
    }

    public List<DataBean> getLinkTargets(Link ... types) {
        return this.getLinkedBeans(types, this.outgoingLinks);
    }

    public List<DataBean> getLinkSources(Link ... types) {
        return this.getLinkedBeans(types, this.incomingLinks);
    }

    public void addTypeTag(TypeTag tag) {
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    public void removeTypeTag(TypeTag tag) {
        this.tags.remove(tag);
    }

    public List<TypeTag> getTypeTags() {
        return this.tags;
    }

    public boolean hasTypeTag(TypeTag ... alternativeTags) {
        for (TypeTag alternativeTag : alternativeTags) {
            if (!this.tags.contains(alternativeTag)) continue;
            return true;
        }
        return false;
    }

    DataManager.ContentLocation getContentLocation(DataManager.StorageMethod ... methods) {
        if (methods.length == 0) {
            throw new IllegalArgumentException("must specify at least one method");
        }
        List<DataManager.ContentLocation> locations = this.getContentLocations(methods);
        return locations.isEmpty() ? null : locations.get(0);
    }

    List<DataManager.ContentLocation> getContentLocations() {
        return this.contentLocations;
    }

    List<DataManager.ContentLocation> getContentLocations(DataManager.StorageMethod ... methods) {
        LinkedList<DataManager.ContentLocation> locations = new LinkedList<DataManager.ContentLocation>();
        for (DataManager.ContentLocation contentLocation : this.contentLocations) {
            for (DataManager.StorageMethod method : methods) {
                if (contentLocation.method != method) continue;
                locations.add(contentLocation);
            }
        }
        return locations;
    }

    void addContentLocation(DataManager.ContentLocation contentLocation) {
        this.contentLocations.add(contentLocation);
    }

    void removeContentLocation(DataManager.ContentLocation contentLocation) {
        this.contentLocations.remove(contentLocation);
    }

    void removeContentLocations(DataManager.StorageMethod ... methods) {
        LinkedList<DataManager.ContentLocation> locationsToBeRemoved = new LinkedList<DataManager.ContentLocation>();
        for (DataManager.StorageMethod method : methods) {
            for (DataManager.ContentLocation location : this.contentLocations) {
                if (!method.equals((Object)location.getMethod())) continue;
                locationsToBeRemoved.add(location);
            }
        }
        for (DataManager.ContentLocation location : locationsToBeRemoved) {
            this.contentLocations.remove(location);
        }
    }

    public void setCreationDate(Date date) {
        this.date = date;
    }

    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    public String toString() {
        return this.getName();
    }

    public DataBean getUniqueAncestorRecursively(DataBean dataBean) {
        if (dataBean.getLinkTargets(Link.derivationalTypes()).size() != 1) {
            return dataBean;
        }
        return this.getUniqueAncestorRecursively(dataBean.getLinkTargets(Link.derivationalTypes()).get(0));
    }

    private void conditionallySelect(DataBeanSelector selector, LinkedList<DataBean> selected, DataBean bean) {
        if (!selected.contains(bean) && selector.shouldSelect(bean)) {
            selected.add(bean);
        }
    }

    private List<DataBean> getLinkedBeans(Link[] types, LinkedList<LinkedBean> links) {
        LinkedList<DataBean> targets = new LinkedList<DataBean>();
        block0: for (LinkedBean linkTarget : links) {
            for (Link type : types) {
                if (linkTarget.link != type) continue;
                targets.add(linkTarget.bean);
                continue block0;
            }
        }
        return targets;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public boolean isTagsSet() {
        return this.tagsSet;
    }

    public void setTagsSet(boolean tagsSet) {
        this.tagsSet = tagsSet;
    }

    public void setPosition(Integer x, Integer y) {
        this.x = x;
        this.y = y;
    }

    public Integer getX() {
        return this.x;
    }

    public Integer getY() {
        return this.y;
    }

    private static class LinkedBean {
        Link link;
        DataBean bean;

        LinkedBean(Link link, DataBean bean) {
            this.link = link;
            this.bean = bean;
        }
    }

    public static enum Link {
        ANNOTATION("Annotation"),
        DERIVATION("Derivation"),
        MODIFICATION("Modification"),
        GROUPING("Grouping");

        private String name;

        private Link(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Link[] userEditableValues() {
            return new Link[]{ANNOTATION, DERIVATION, MODIFICATION};
        }

        public static Link[] derivationalTypes() {
            return new Link[]{DERIVATION, MODIFICATION};
        }
    }

    public static enum Traversal {
        DIRECT,
        REVERSED,
        BIDIRECTIONAL;


        public boolean isDirect() {
            return this == DIRECT || this == BIDIRECTIONAL;
        }

        public boolean isReversed() {
            return this == REVERSED || this == BIDIRECTIONAL;
        }
    }

    public static enum DataNotAvailableHandling {
        EXCEPTION_ON_NA,
        NULL_ON_NA,
        EMPTY_ON_NA,
        INFOTEXT_ON_NA;

    }
}

