/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.SelectionManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.LayoutChild;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.PassiveItem;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Selectable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public abstract class Track
implements DataResultListener,
MouseListener,
LayoutChild {
    private JComponent component = new JComponent(){

        @Override
        public void paintComponent(Graphics g) {
            Track.this.printTime(null);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setPaint(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            int x = 0;
            List<Selectable> selectables = Track.this.getSelectables();
            Track.this.updateSelections(Track.this.getSelectionManager());
            for (Selectable selectable : selectables) {
                List<Drawable> drawables = selectable.getDrawables();
                this.drawDrawables(g2, x, drawables);
            }
            Track.this.printTime(Track.this.getTrackName() + "\tdraw " + selectables.size() + " drawables");
        }

        private void drawDrawables(Graphics2D g2, int x, Collection<Drawable> drawables) {
            if (LayoutTool.LayoutMode.FULL == Track.this.getLayoutMode()) {
                Track.this.setFullHeight(drawables);
            }
            int y = Track.this.convertGraphicsCoordinateToTrack(0);
            for (Drawable drawable : drawables) {
                if (drawable == null) continue;
                int maybeReversedY = y;
                if (Track.this.isReversed()) {
                    maybeReversedY -= this.getHeight();
                } else {
                    drawable.upsideDown();
                }
                drawable.draw(g2, x, maybeReversedY);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = LayoutTool.LayoutMode.FULL == Track.this.getLayoutMode() ? Track.this.getFullHeight() : Track.this.getTrackHeight();
            return size;
        }
    };
    private static final int NAME_VISIBLE_VIEW_RATIO = 20;
    private static final float MAX_SELECTION_DISTANCE = 10.0f;
    protected GBrowserView view;
    protected List<DataThread> dataThreads = new LinkedList<DataThread>();
    protected Strand strand = Strand.FORWARD;
    protected LayoutTool.LayoutMode layoutMode = LayoutTool.LayoutMode.FIXED;
    protected LayoutTool.LayoutMode defaultLayoutMode = LayoutTool.LayoutMode.FIXED;
    private Map<DataThread, Set<DataType>> dataTypeMap = new HashMap<DataThread, Set<DataType>>();
    private TrackGroup trackGroup;
    private long maxViewLength = Long.MAX_VALUE;
    private long minViewLength = 0L;
    private int trackHeight = 100;
    private String name = "Track";
    private int fullHeight;
    private int FULL_HEIGHT_MARGIN = 10;
    private long time = 0L;
    private Point2D[] arrowPoints = new Point2D[]{new Point2D.Double(0.0, 0.25), new Point2D.Double(0.5, 0.25), new Point2D.Double(0.5, 0.0), new Point2D.Double(1.0, 0.5), new Point2D.Double(0.5, 1.0), new Point2D.Double(0.5, 0.75), new Point2D.Double(0.0, 0.75), new Point2D.Double(0.0, 0.25)};

    public Track() {
        this.component.setBackground(Color.white);
        this.component.setInheritsPopupMenu(true);
        this.component.addMouseListener(this);
    }

    protected SelectionManager getSelectionManager() {
        return this.getView().getPlot().getSelectionManager();
    }

    public Track(int height) {
        this();
        this.trackHeight = height;
    }

    public void setView(GBrowserView view) {
        this.view = view;
        this.component.addMouseListener(view);
        this.component.addMouseMotionListener(view);
        this.component.addMouseWheelListener(view);
    }

    public int addDataThread(DataThread dataThread) {
        this.dataThreads.add(dataThread);
        return this.dataThreads.size() - 1;
    }

    public void initializeListener() {
        if (this.dataThreads != null) {
            for (DataThread handler : this.dataThreads) {
                this.view.getQueueManager().addDataResultListener(handler, this);
            }
        }
    }

    private void printTime(String operation) {
        if (operation == null) {
            this.time = System.currentTimeMillis();
        } else {
            long elapsed = System.currentTimeMillis() - this.time;
            this.time = System.currentTimeMillis();
            if (elapsed > 5L) {
                // empty if block
            }
        }
    }

    public Collection<Drawable> getDrawables() {
        return null;
    }

    protected GBrowserView getView() {
        return this.view;
    }

    public boolean hasData() {
        return this.dataThreads != null;
    }

    public void defineDataTypes() {
    }

    public void addDataType(DataType type) {
        this.addDataType(this.dataThreads.get(0), type);
    }

    public void addDataType(DataThread dataThread, DataType type) {
        Set<DataType> set = this.dataTypeMap.get(dataThread);
        if (set == null) {
            set = new HashSet<DataType>();
            this.dataTypeMap.put(dataThread, set);
        }
        set.add(type);
    }

    public Collection<Drawable> getEmptyDrawCollection() {
        return new LinkedList<Drawable>();
    }

    public int getTrackHeight() {
        return this.trackHeight;
    }

    public boolean isSuitableViewLength() {
        return this.getView().getBpRegion().getLength() >= this.minViewLength && this.getView().getBpRegion().getLength() < this.maxViewLength;
    }

    public void setStrand(Strand s) {
        this.strand = s;
    }

    public Strand getStrand() {
        return this.strand;
    }

    public boolean isReversed() {
        return this.strand == Strand.REVERSE;
    }

    protected Collection<? extends Drawable> getArrowDrawables(int x, int y, int width, int height) {
        Collection<Drawable> parts = this.getEmptyDrawCollection();
        for (int i = 1; i < this.arrowPoints.length; ++i) {
            Point2D p1 = this.arrowPoints[i - 1];
            Point2D p2 = this.arrowPoints[i];
            Point2D.Double p1Scaled = new Point2D.Double((double)x + p1.getX() * (double)width, (double)y + p1.getY() * (double)height);
            Point2D.Double p2Scaled = new Point2D.Double((double)x + p2.getX() * (double)width, (double)y + p2.getY() * (double)height);
            parts.add(new LineDrawable((int)((Point2D)p1Scaled).getX(), (int)((Point2D)p1Scaled).getY(), (int)((Point2D)p2Scaled).getX(), (int)((Point2D)p2Scaled).getY(), Color.black));
        }
        return parts;
    }

    public String getTrackName() {
        return this.name;
    }

    public void setTrackName(String name) {
        this.name = name;
    }

    public boolean isNameVisible(Rectangle rect) {
        boolean wideEnough = rect.width > this.getView().getWidth() / 20;
        return wideEnough;
    }

    protected void drawTextAboveRectangle(String text, Collection<Drawable> drawables, Rectangle rect, int offset) {
        int x = rect.x < 0 ? 0 : rect.x;
        int y = rect.y + offset;
        drawables.add(new TextDrawable(x, y, text, Color.DARK_GRAY));
    }

    public void setFullHeight(Collection<Drawable> drawables) {
        int maxY = 0;
        for (Drawable drawable : drawables) {
            if (drawable.getMaxY() <= maxY || this.view.getWidth() <= drawable.x) continue;
            maxY = drawable.getMaxY();
        }
        if (this.getLayoutMode() == LayoutTool.LayoutMode.FULL) {
            maxY += this.FULL_HEIGHT_MARGIN;
        }
        this.fullHeight = maxY;
        if (this.fullHeight != this.getLayoutComponent().getHeight()) {
            this.getLayoutComponent().revalidate();
        }
    }

    public int getFullHeight() {
        return Math.max(this.fullHeight, Math.max(this.component.getHeight(), this.getTrackHeight()));
    }

    public void setLayoutMode(LayoutTool.LayoutMode mode) {
        this.layoutMode = mode;
    }

    public void setDefaultLayoutMode(LayoutTool.LayoutMode mode) {
        this.defaultLayoutMode = mode;
    }

    public void setDefaultLayoutMode() {
        this.layoutMode = this.defaultLayoutMode;
    }

    @Override
    public LayoutTool.LayoutMode getLayoutMode() {
        return this.layoutMode;
    }

    public void clearDataTypes() {
        this.dataTypeMap.clear();
    }

    public Map<DataThread, Set<DataType>> getDataTypeMap() {
        return this.dataTypeMap;
    }

    public void setViewLimits(long minViewLength, long maxViewLength) {
        this.minViewLength = minViewLength;
        this.maxViewLength = maxViewLength;
    }

    public TrackGroup getTrackGroup() {
        return this.trackGroup;
    }

    public void setTrackGroup(TrackGroup trackGroup) {
        this.trackGroup = trackGroup;
    }

    public void setVisible(boolean state) {
        this.component.setVisible(state);
    }

    public boolean isVisible() {
        return this.component.isVisible();
    }

    @Override
    public JComponent getLayoutComponent() {
        return this.component;
    }

    public List<Selectable> getSelectables() {
        Collection<Drawable> drawables = this.getDrawables();
        PassiveItem item = new PassiveItem((List)drawables);
        LinkedList<Selectable> itemList = new LinkedList<Selectable>();
        itemList.add(item);
        return itemList;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Selectable selectable;
        final Point point = e.getPoint();
        point.y = this.convertGraphicsCoordinateToTrack(point.y);
        LinkedList<Selectable> closestSelectables = new LinkedList<Selectable>();
        for (Selectable selectable2 : this.getSelectables()) {
            double distance = selectable2.getDistance(point);
            if (!(distance < 10.0)) continue;
            closestSelectables.add(selectable2);
        }
        Collections.sort(closestSelectables, new Comparator<Selectable>(){

            @Override
            public int compare(Selectable s1, Selectable s2) {
                double d2;
                double d1 = s1.getDistance(point);
                if (d1 < (d2 = s2.getDistance(point))) {
                    return -1;
                }
                if (d1 > d2) {
                    return 1;
                }
                return 0;
            }
        });
        SelectionManager selectionManager = this.getSelectionManager();
        if (!e.isControlDown()) {
            selectionManager.set(this.getDataUrl(), null);
        }
        Iterator i$ = closestSelectables.iterator();
        while (i$.hasNext() && !((selectable = (Selectable)i$.next()).getDistance(point) > ((Selectable)closestSelectables.getFirst()).getDistance(point))) {
            selectionManager.toggle(this.getDataUrl(), selectable);
        }
        this.updateSelections(selectionManager);
        this.getView().redraw();
    }

    private void updateSelections(SelectionManager selectionManager) {
        for (Selectable selectable : this.getSelectables()) {
            selectable.setSelected(selectionManager.isSelected(this.getDataUrl(), selectable));
        }
    }

    private int convertGraphicsCoordinateToTrack(int y) {
        int height = this.getLayoutComponent().getHeight();
        return height - y;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public DataUrl getDataUrl() {
        if (this.dataThreads.size() > 0) {
            return this.dataThreads.get(0).getDataSource().getDataUrl();
        }
        return null;
    }

    public boolean isShowMoreCapable() {
        return false;
    }

    public int getVisibleWidth() {
        JScrollBar bar = this.getTrackGroup().getScrollGroup().getLayoutComponent().getVerticalScrollBar();
        int width = this.view.getWidth();
        if (bar.isVisible()) {
            return width - bar.getWidth();
        }
        return width;
    }

    @Override
    public void updateLayout() {
    }
}

