/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.LayoutChild;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.LayoutParent;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import net.miginfocom.swing.MigLayout;

public class LayoutUpdater<ChildType extends LayoutChild, ParentType extends LayoutParent> {
    public void update(List<ChildType> children, ParentType parent) {
        JComponent newComponent;
        LayoutChild child;
        int i;
        for (LayoutChild child2 : children) {
            child2.updateLayout();
        }
        Component[] array = parent.getLayoutContainer().getComponents();
        ArrayList<Component> oldComponents = new ArrayList<Component>(Arrays.asList(array));
        ArrayList<JComponent> newComponents = new ArrayList<JComponent>();
        for (LayoutChild child3 : children) {
            JComponent newComponent2 = child3.getLayoutComponent();
            newComponents.add(newComponent2);
        }
        for (Component oldComponent : oldComponents) {
            if (newComponents.contains(oldComponent)) continue;
            parent.getLayoutContainer().remove(oldComponent);
        }
        boolean keepOld = true;
        for (i = 0; i < children.size(); ++i) {
            child = (LayoutChild)children.get(i);
            newComponent = child.getLayoutComponent();
            Component oldComponent = null;
            if (parent.getLayoutContainer().getComponentCount() > i) {
                oldComponent = parent.getLayoutContainer().getComponent(i);
            }
            if (newComponent == oldComponent) continue;
            keepOld = false;
            break;
        }
        if (!keepOld) {
            parent.getLayoutContainer().removeAll();
        }
        for (i = 0; i < children.size(); ++i) {
            child = (LayoutChild)children.get(i);
            newComponent = child.getLayoutComponent();
            if (keepOld) {
                MigLayout migLayout = (MigLayout)parent.getLayoutContainer().getLayout();
                migLayout.setComponentConstraints((Component)newComponent, (Object)this.getConstraint(child.getLayoutMode()));
                continue;
            }
            parent.getLayoutContainer().add((Component)newComponent, this.getConstraint(child.getLayoutMode()));
        }
    }

    public String getConstraint(LayoutTool.LayoutMode mode) {
        String constraints = LayoutTool.LayoutMode.FILL == mode ? "grow" : "growx";
        return constraints;
    }
}

