/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.GeneResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.SearchRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.LineDataSource;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class SearchIndexConversion
extends DataThread {
    ArrayList<SearchIndex> indexes = new ArrayList();

    public SearchIndexConversion(List<DataUrl> indexUrls, GBrowser browser) {
        super(browser, null);
        try {
            for (DataUrl dataUrl : indexUrls) {
                this.indexes.add(new SearchIndex(dataUrl));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void processDataRequest(DataRequest req) throws InterruptedException {
        SearchRequest request = (SearchRequest)req;
        String searchString = request.getSearchString().toLowerCase();
        for (SearchIndex index : this.indexes) {
            Region region = index.search(searchString);
            if (region == null) continue;
            this.reply(request, region);
            return;
        }
        this.reply(request, null);
    }

    private void reply(SearchRequest request, Region region) throws InterruptedException {
        LinkedList<Feature> resultList = new LinkedList<Feature>();
        resultList.add(new Feature(region, null));
        super.createDataResult(new GeneResult(request.getStatus(), resultList, request.getSearchString()));
    }

    public static class SearchIndex {
        private LineDataSource dataSource;
        private HashMap<String, Region> indexMap;

        public SearchIndex(DataUrl dataUrl) throws URISyntaxException, IOException {
            this.dataSource = new LineDataSource(dataUrl);
        }

        public Region search(String searchString) {
            if (this.indexMap == null) {
                this.indexMap = new HashMap();
                try {
                    this.readFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return this.indexMap.get(searchString);
        }

        private void readFile() throws IOException {
            String line;
            while ((line = this.dataSource.readLine()) != null) {
                String[] cols = line.split("\t");
                String chr = cols[0];
                long start = Long.parseLong(cols[1]);
                long end = Long.parseLong(cols[2]);
                String string = cols[3];
                this.indexMap.put(string.toLowerCase(), new Region(start, end, new Chromosome(chr)));
            }
        }
    }
}

