/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.RandomAccessLineReader;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class RandomAccessLineDataSourceHttpTest {
    @Test
    public void run() throws URISyntaxException, IOException, GBrowserException {
        URL httpUrl = RandomAccessLineDataSourceHttpTest.getRemoteGtfUrl();
        URL fileUrl = RandomAccessLineDataSourceHttpTest.getLocalGtfUrl();
        URL bigHttpUrl = RandomAccessLineDataSourceHttpTest.getBigRemoteGtfUrl();
        DataUrl fileDataUrl = new DataUrl(fileUrl, "file");
        RandomAccessLineReader fileReader = new RandomAccessLineReader(fileDataUrl);
        DataUrl httpDataUrl = new DataUrl(httpUrl, "http");
        RandomAccessLineReader httpReader = new RandomAccessLineReader(httpDataUrl);
        RandomAccessLineDataSourceHttpTest.iterativeTest(fileReader, httpReader);
        RandomAccessLineDataSourceHttpTest.removeLocalGtfFile(fileUrl);
        DataUrl bigHttpDataUrl = new DataUrl(bigHttpUrl, "http");
        RandomAccessLineReader bigHttpReader = new RandomAccessLineReader(bigHttpDataUrl);
        RandomAccessLineDataSourceHttpTest.testRemoteRandomAccess(bigHttpReader);
    }

    public static URL getRemoteGtfUrl() throws MalformedURLException {
        return new URL("http://nic.funet.fi/pub/sci/molbio/chipster/devel/junit-test-data/Homo_sapiens.GRCh37.70-500k.gtf");
    }

    public static URL getBigRemoteGtfUrl() throws MalformedURLException {
        return new URL("http://nic.funet.fi/pub/sci/molbio/chipster/devel/junit-test-data/Homo_sapiens.GRCh37.70-sort.gtf");
    }

    public static URL getLocalGtfUrl() throws MalformedURLException, IOException {
        File file = RandomAccessLineDataSourceHttpTest.download(RandomAccessLineDataSourceHttpTest.getRemoteGtfUrl());
        return file.toURI().toURL();
    }

    public static void removeLocalGtfFile(URL url) throws URISyntaxException {
        new File(url.toURI()).delete();
    }

    private static File download(URL httpUrl) throws IOException {
        ReadableByteChannel rbc = Channels.newChannel(httpUrl.openStream());
        File out = File.createTempFile("RandomAccessLineDataSourceHttpTest", "");
        FileOutputStream fos = new FileOutputStream(out);
        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        fos.close();
        return out;
    }

    private static void iterativeTest(RandomAccessLineReader file, RandomAccessLineReader http) throws IOException, GBrowserException {
        for (int j = 0; j < 3; ++j) {
            file.setPosition(j * 100);
            http.setPosition(j * 100);
            for (int i = 0; i < 500; ++i) {
                String fileLine = file.readLine();
                String httpLine = http.readLine();
                Assert.assertEquals((Object)fileLine, (Object)httpLine);
            }
        }
    }

    private static void testRemoteRandomAccess(RandomAccessLineReader reader) throws IOException, GBrowserException {
        Random rand = new Random();
        long size = reader.length();
        int MB = 0x100000;
        long SAMPLES = 10L;
        long t = System.currentTimeMillis();
        int i = 0;
        while ((long)i < 10L) {
            reader.setPosition(rand.nextInt(0x100000));
            reader.readLine();
            ++i;
        }
        long headSeek = (System.currentTimeMillis() - t) / 10L;
        t = System.currentTimeMillis();
        int i2 = 0;
        while ((long)i2 < 10L) {
            reader.setPosition(size - (long)rand.nextInt(0x100000));
            reader.readLine();
            ++i2;
        }
        long tailSeek = (System.currentTimeMillis() - t) / 10L;
        Assert.assertFalse((String)("Random access read in the end of the file is too slow (" + tailSeek + "ms) " + "in comparison to reading in the beginning of the file (" + headSeek + "ms)"), (tailSeek > headSeek * 2L ? 1 : 0) != 0);
    }
}

