/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.TabixDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Exon;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Gene;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.GeneResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.GeneSet;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.IndexKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.SearchRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.BinarySearchIndex;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.ChromosomeBinarySearch;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.GtfLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.Index;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.RandomAccessLineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.UnsortedDataException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.broad.tribble.readers.TabixReader;

public class GtfToFeatureConversion
extends DataThread {
    public static int MAX_INTRON_LENGTH = 500000;
    private Index index;
    private GtfLineParser parser;
    private boolean isTabix;
    private TabixDataSource tabixDataSource;
    private RandomAccessLineDataSource gtfDataSource;
    private ChromosomeBinarySearch chrSearch;

    public GtfToFeatureConversion(DataUrl gtfTabixUrl, DataUrl gtfIndexUrl, final GBrowser browser) {
        super(browser, null);
        this.isTabix = gtfIndexUrl != null;
        this.parser = new GtfLineParser();
        try {
            if (this.isTabix) {
                this.tabixDataSource = new TabixDataSource(gtfTabixUrl, gtfIndexUrl);
                super.setDataSource(this.tabixDataSource);
            } else {
                this.gtfDataSource = new RandomAccessLineDataSource(gtfTabixUrl);
                this.index = new BinarySearchIndex(this.gtfDataSource, this.parser);
                super.setDataSource(this.gtfDataSource);
                this.chrSearch = new ChromosomeBinarySearch(gtfTabixUrl, new GtfLineParser());
            }
        }
        catch (UnsortedDataException e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    browser.showDialog("Unsorted data", e.getMessage(), null, true, false, true, true);
                }
            });
            this.index = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (GBrowserException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void processDataRequest(DataRequest request) throws InterruptedException {
        if (!this.isTabix && this.index == null) {
            return;
        }
        if (request instanceof SearchRequest) {
            SearchRequest geneRequest = (SearchRequest)request;
            try {
                List<Feature> resultList = this.processGeneSearch(geneRequest);
                this.createDataResult(new GeneResult(geneRequest.getStatus(), resultList, geneRequest.getSearchString()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            long start = request.start.bp;
            long end = request.end.bp;
            start = Math.max(start - (long)MAX_INTRON_LENGTH, 1L);
            Region requestRegion = new Region(start, end += (long)MAX_INTRON_LENGTH, request.start.chr);
            long CHUNK_SIZE = 1000000L;
            for (long chunkStart = requestRegion.start.bp.longValue(); chunkStart <= requestRegion.end.bp; chunkStart += 1000000L) {
                Region chunkRegion = new Region(chunkStart, Math.min(chunkStart + 1000000L, requestRegion.end.bp), requestRegion.start.chr);
                this.processDataRequestChunk(request, chunkRegion);
            }
        }
    }

    protected void processDataRequestChunk(DataRequest request, Region chunkRegion) throws InterruptedException {
        LinkedList<Feature> resultList = new LinkedList<Feature>();
        LinkedList<Exon> exons = this.fetchExons(request, chunkRegion);
        for (Exon exon : exons) {
            LinkedHashMap<DataType, Object> valueMap = new LinkedHashMap<DataType, Object>();
            valueMap.put(DataType.VALUE, exon);
            Feature feature = new Feature(exon.getRegion(), valueMap);
            resultList.add(feature);
        }
        super.createDataResult(new DataResult(request.getStatus(), resultList));
    }

    private LinkedList<Exon> fetchExons(DataRequest request, Region chunkRegion) {
        LinkedList<Exon> exons = new LinkedList<Exon>();
        TreeMap<IndexKey, String> lines = null;
        try {
            lines = this.getLines(request, chunkRegion);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (GBrowserException e) {
            e.printStackTrace();
        }
        for (String line : lines.values()) {
            Exon exon = GtfToFeatureConversion.parseLine(this.parser, line);
            if (exon == null) continue;
            exons.add(exon);
        }
        return exons;
    }

    public static Exon parseLine(GtfLineParser parser, String line) {
        if (!parser.setLine(line)) {
            return null;
        }
        Region region = parser.getRegion();
        String feature = parser.getFeature();
        String geneId = parser.getGeneId();
        String transcId = parser.getTranscriptId();
        String exonString = parser.getAttribute("exon_number");
        int exonNumber = -1;
        if (exonString != null) {
            exonNumber = new Integer(exonString);
        }
        String geneName = parser.getAttribute("gene_name");
        String transcName = parser.getAttribute("transcript_name");
        String biotype = null;
        Exon exon = null;
        if ("exon".equals(feature) || "CDS".equals(feature)) {
            exon = new Exon(region, feature, exonNumber, geneId, transcId, geneName, transcName, biotype);
        } else if (feature.startsWith("GenBank")) {
            if (geneId == null || transcId == null) {
                return null;
            }
            if ("GenBank gene".equals(feature)) {
                feature = "exon";
            } else if ("GenBank CDS".equals(feature)) {
                feature = "CDS";
            } else {
                geneId = feature + geneId;
                transcId = feature + transcId;
                if (geneName != null) {
                    geneName = feature + " " + geneName;
                }
                if (transcName != null) {
                    transcName = feature + " " + transcName;
                }
                feature = "exon";
            }
            exonNumber = 1;
            exon = new Exon(region, feature, exonNumber, geneId, transcId, geneName, transcName, biotype);
        }
        return exon;
    }

    private TreeMap<IndexKey, String> getLines(DataRequest request, Region chunkRegion) throws IOException, GBrowserException {
        TreeMap<IndexKey, String> lines;
        if (this.isTabix) {
            lines = new TreeMap();
            TabixReader.Iterator iter = this.tabixDataSource.getTabixIterator(request);
            if (iter != null) {
                String line;
                while ((line = iter.next()) != null) {
                    IndexKey key;
                    this.parser.setLine(line);
                    BpCoord start = this.parser.getRegion().start;
                    int i = 0;
                    do {
                        key = new IndexKey(start, i);
                        ++i;
                    } while (lines.containsKey(key));
                    lines.put(key, line);
                }
            }
        } else {
            lines = this.index.getFileLines(new DataRequest(chunkRegion, request.getRequestedContents(), request.getStatus()));
        }
        return lines;
    }

    private List<Feature> processGeneSearch(SearchRequest request) throws IOException, UnsortedDataException, GBrowserException {
        String searchString = request.getSearchString().toLowerCase();
        LinkedList<Feature> resultList = new LinkedList<Feature>();
        for (String chrName : this.getChromosomes()) {
            Chromosome chr = new Chromosome(chrName);
            Region region = new Region(1L, Long.MAX_VALUE, new Chromosome(chr));
            request.start.chr = chr;
            request.end.chr = chr;
            LinkedList<Exon> exons = this.fetchExons(request, region);
            GeneSet genes = new GeneSet();
            genes.add(exons.iterator(), region);
            for (Gene gene : genes.values()) {
                if ((gene.getName() == null || !gene.getName().toLowerCase().equals(searchString)) && (gene.getId() == null || !gene.getId().toLowerCase().equals(searchString))) continue;
                LinkedHashMap<DataType, Object> values = new LinkedHashMap<DataType, Object>();
                values.put(DataType.VALUE, gene);
                resultList.add(new Feature(gene.getRegion(), values));
            }
        }
        return resultList;
    }

    private Collection<String> getChromosomes() throws UnsortedDataException, IOException, GBrowserException {
        if (this.isTabix) {
            return this.tabixDataSource.getChromosomes();
        }
        TreeSet<Chromosome> chrNames = this.chrSearch.getChromosomes();
        ArrayList<String> chrs = new ArrayList<String>();
        for (Chromosome chr : chrNames) {
            chrs.add(chr.toString());
        }
        return chrs;
    }
}

