/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Feature;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.BaseStorage;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CoverageTool {
    public static final int BIN_SIZE = 16;

    public static TreeMap<BpCoord, BaseStorage.Base> getTotalBases(Iterator<Map.Entry<BpCoord, BaseStorage.Base>> forward, Iterator<Map.Entry<BpCoord, BaseStorage.Base>> reverse) {
        TreeMap<BpCoord, BaseStorage.Base> totalBases = new TreeMap<BpCoord, BaseStorage.Base>();
        CoverageTool.addBaseCounts(forward, totalBases);
        CoverageTool.addBaseCounts(reverse, totalBases);
        return totalBases;
    }

    public static TreeMap<Region, Float> getTotalAverageCoverage(Iterator<Map.Entry<Region, Float>> forward, Iterator<Map.Entry<Region, Float>> reverse) {
        TreeMap<Region, Float> totals = new TreeMap<Region, Float>();
        CoverageTool.addFloatCounts(forward, totals);
        CoverageTool.addFloatCounts(reverse, totals);
        return totals;
    }

    private static void addBaseCounts(Iterator<Map.Entry<BpCoord, BaseStorage.Base>> iterator, TreeMap<BpCoord, BaseStorage.Base> totalBases) {
        while (iterator.hasNext()) {
            Map.Entry<BpCoord, BaseStorage.Base> entry = iterator.next();
            BaseStorage.Base totalBase = totalBases.get(entry.getKey());
            if (totalBase == null) {
                totalBase = new BaseStorage.Base(entry.getKey().bp, null);
                totalBases.put(entry.getKey(), totalBase);
            }
            int[] counts = entry.getValue().getNucleotideCounts();
            int[] totalCounts = totalBase.getNucleotideCounts();
            for (int i = 0; i < totalCounts.length; ++i) {
                int n = i;
                totalCounts[n] = totalCounts[n] + counts[i];
            }
            totalBase.setNucleotideCounts(totalCounts);
        }
    }

    private static void addFloatCounts(Iterator<Map.Entry<Region, Float>> iterator, TreeMap<Region, Float> totals) {
        while (iterator.hasNext()) {
            Map.Entry<Region, Float> entry = iterator.next();
            Region region = entry.getKey();
            if (!totals.containsKey(region)) {
                totals.put(region, Float.valueOf(0.0f));
            }
            float value = totals.get(region).floatValue();
            totals.put(region, Float.valueOf(value + entry.getValue().floatValue()));
        }
    }

    public static void convertRegionContentListToBaseList(List<Feature> regionContentList, TreeMap<BpCoord, BaseStorage.Base> forwardBases, TreeMap<BpCoord, BaseStorage.Base> reverseBases) {
        for (Feature regCont : regionContentList) {
            Object value = regCont.values.get((Object)DataType.VALUE);
            if (value == null || !(value instanceof BaseStorage.Base)) continue;
            BaseStorage.Base base = (BaseStorage.Base)value;
            if (regCont.values.get((Object)DataType.STRAND) == Strand.FORWARD) {
                forwardBases.put(regCont.region.start, base);
                continue;
            }
            if (regCont.values.get((Object)DataType.STRAND) != Strand.REVERSE) continue;
            reverseBases.put(regCont.region.start, base);
        }
    }

    public static void convertRegionContentListToFloatList(List<Feature> regionContentList, TreeMap<Region, Float> forwardAverages, TreeMap<Region, Float> reverseAverages) {
        for (Feature regCont : regionContentList) {
            Object value = regCont.values.get((Object)DataType.COVERAGE_AVERAGE);
            if (value == null || !(value instanceof Float)) continue;
            Float floatValue = (Float)value;
            if (regCont.values.get((Object)DataType.STRAND) == Strand.FORWARD) {
                forwardAverages.put(regCont.region, floatValue);
                continue;
            }
            if (regCont.values.get((Object)DataType.STRAND) != Strand.REVERSE) continue;
            reverseAverages.put(regCont.region, floatValue);
        }
    }

    public static TreeMap<Long, LinkedList<BaseStorage.Base>> binBases(TreeMap<BpCoord, BaseStorage.Base> bases) {
        TreeMap<Long, LinkedList<BaseStorage.Base>> bins = new TreeMap<Long, LinkedList<BaseStorage.Base>>();
        for (BaseStorage.Base base : bases.values()) {
            Long bin = CoverageTool.getBin(base.getBpLocation());
            if (!bins.containsKey(bin)) {
                bins.put(bin, new LinkedList());
            }
            bins.get(bin).add(base);
        }
        return bins;
    }

    public static long getBin(long location) {
        return location / 16L * 16L;
    }

    public static LinkedList<Feature> average(TreeMap<Long, LinkedList<BaseStorage.Base>> bins, Chromosome chr, Strand strand) {
        LinkedList<Feature> resultList = new LinkedList<Feature>();
        for (Map.Entry<Long, LinkedList<BaseStorage.Base>> entry : bins.entrySet()) {
            float average = 0.0f;
            for (BaseStorage.Base base : entry.getValue()) {
                average += (float)base.getCoverage();
            }
            Region region = new Region(entry.getKey(), entry.getKey() + 16L, chr);
            LinkedHashMap<DataType, Object> values = new LinkedHashMap<DataType, Object>();
            values.put(DataType.COVERAGE_AVERAGE, Float.valueOf(average /= (float)entry.getValue().size()));
            values.put(DataType.STRAND, (Object)strand);
            resultList.add(new Feature(region, values));
        }
        return resultList;
    }

    public static LinkedList<Feature> average(LinkedList<Feature> resultList, Chromosome chr) {
        TreeMap<BpCoord, BaseStorage.Base> forwardBases = new TreeMap<BpCoord, BaseStorage.Base>();
        TreeMap<BpCoord, BaseStorage.Base> reverseBases = new TreeMap<BpCoord, BaseStorage.Base>();
        CoverageTool.convertRegionContentListToBaseList(resultList, forwardBases, reverseBases);
        TreeMap<Long, LinkedList<BaseStorage.Base>> forwardBins = CoverageTool.binBases(forwardBases);
        TreeMap<Long, LinkedList<BaseStorage.Base>> reverseBins = CoverageTool.binBases(reverseBases);
        LinkedList<Feature> averageCoverage = new LinkedList<Feature>();
        averageCoverage.addAll(CoverageTool.average(forwardBins, chr, Strand.FORWARD));
        averageCoverage.addAll(CoverageTool.average(reverseBins, chr, Strand.REVERSE));
        return averageCoverage;
    }
}

