/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser;

import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamToCoverageConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamToCoverageEstimateConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.BamToDetailsConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.GtfToFeatureConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex.IndexedFastaConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.AnnotationManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserPlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserSettings;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GeneIndexActions;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Interpretation;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.ScrollGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.SelectionManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.ViewLimiter;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.BedTabixToRegionConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.CnaConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.CytobandConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.FileLineConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.ScatterplotFileLineConversion;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.AnnotationTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.BedTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CnaCallsTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CnaFrequenciesTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CnaLogRatiosTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CytobandTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.RegionTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SampleTrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack3D;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackFactory;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.UnsortedDataException;
import fi.csc.microarray.util.BrowserLauncher;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GBrowser {
    static final String WAITPANEL = "waitpanel";
    static final String PLOTPANEL = "plotpanel";
    private GBrowserPlot plot;
    private JPanel plotPanel = new JPanel(new CardLayout());
    private AnnotationManager annotationManager;
    private GeneIndexActions gia;
    private ViewLimiter viewLimiter;
    protected volatile boolean geneSearchDone;
    private GBrowserSettings settings;
    private List<Interpretation> interpretations;
    private LinkedList<String> sampleNames;
    private SelectionManager selectionManager;

    public void initialise() throws Exception {
        this.annotationManager = new AnnotationManager(this);
        this.annotationManager.initialize();
        this.settings = new GBrowserSettings();
        this.settings.initialise(this);
        this.selectionManager = new SelectionManager(this);
    }

    public JComponent getVisualisation(List<Interpretation> interpretations) throws IOException, UnsortedDataException, URISyntaxException, GBrowserException {
        this.interpretations = interpretations;
        this.settings.updateInterpretations();
        JPanel waitPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        waitPanel.add((Component)new JLabel("<html><p style=\"font-size: larger\">Please select genome and click " + this.settings.getGoButtonText() + "</p></html>"), c);
        this.plotPanel.add((Component)waitPanel, WAITPANEL);
        return this.plotPanel;
    }

    public void updateCoverageScale() {
        this.plot.setReadScale(this.settings.getCoverageScale());
    }

    public AnnotationManager.Genome getGenome() {
        return this.settings.getGenome();
    }

    public void updateTracks() throws URISyntaxException, IOException, GBrowserException {
        GBrowserView dataView = this.plot.getDataView();
        GBrowserView overviewView = this.plot.getOverviewView();
        overviewView.clean();
        dataView.clean();
        ScrollGroup overviewScrollGroup = new ScrollGroup("Overview");
        this.createOverviewTracks(dataView, overviewView, overviewScrollGroup);
        overviewView.addScrollGroup(overviewScrollGroup);
        SeparatorTrack3D separator = new SeparatorTrack3D(true);
        separator.setView(dataView);
        dataView.addTrackGroup(new TrackGroup(separator));
        ScrollGroup annotations = new ScrollGroup("Annotations", true);
        this.createAnnotationTracks(dataView, annotations);
        dataView.addScrollGroup(annotations);
        dataView.addTrackGroup(TrackFactory.getThickSeparatorTrackGroup(this.plot));
        ScrollGroup samples = new ScrollGroup("Samples", true);
        this.createSampleTracks(dataView, samples);
        dataView.addScrollGroup(samples);
        ScrollGroup analyses = new ScrollGroup("Analyses", false);
        this.createAnalysisTracks(dataView, analyses);
        dataView.addScrollGroup(analyses);
        SeparatorTrack3D separator2 = new SeparatorTrack3D(false);
        separator2.setView(dataView);
        dataView.addTrackGroup(new TrackGroup(separator2));
        this.plot.initializeDataResultListeners();
    }

    private void createAnalysisTracks(GBrowserView dataView, ScrollGroup analyses) throws URISyntaxException, IOException, GBrowserException {
        boolean firstAnalysisTrack = true;
        for (Interpretation interpretation : this.interpretations) {
            switch (interpretation.getType()) {
                case REGIONS: 
                case VCF: 
                case GTF: 
                case CNA: {
                    if (!firstAnalysisTrack) {
                        analyses.addTrackGroup(TrackFactory.getThinSeparatorTrackGroup(this.plot));
                        break;
                    }
                    firstAnalysisTrack = false;
                    break;
                }
            }
            String title = this.getTitle(interpretation);
            switch (interpretation.getType()) {
                case REGIONS: {
                    ScatterplotFileLineConversion bed = interpretation.getBedLineDataThread(this);
                    BedTrackGroup bedTrackGroup = new BedTrackGroup(dataView, bed, title);
                    analyses.addTrackGroup(bedTrackGroup);
                    break;
                }
                case VCF: {
                    FileLineConversion vcf = interpretation.getVcfDataThread(this);
                    RegionTrackGroup vcfTrackGroup = new RegionTrackGroup(dataView, vcf, title);
                    analyses.addTrackGroup(vcfTrackGroup);
                    break;
                }
                case TSV: {
                    FileLineConversion tsv = interpretation.getTsvDataThread(this);
                    analyses.addTrackGroup(new RegionTrackGroup(dataView, tsv, title));
                    break;
                }
                case TSV_WITH_ROW_ID: {
                    FileLineConversion tsv = interpretation.getTsvDataThread(this);
                    analyses.addTrackGroup(new RegionTrackGroup(dataView, tsv, title));
                    break;
                }
                case GTF: {
                    GtfToFeatureConversion gtfConversion = interpretation.getGtfDataThread(this);
                    AnnotationTrackGroup geneGroup = new AnnotationTrackGroup(dataView, gtfConversion, null, true);
                    analyses.setScrollEnabled(true);
                    geneGroup.setSettingsEnabled(true);
                    analyses.addTrackGroup(geneGroup);
                    break;
                }
                case REFERENCE: {
                    if (this.getCustomGenome(this.getGenome()).equals(interpretation)) break;
                    IndexedFastaConversion fastaConversion = interpretation.getFastaDataThread(this);
                    SampleTrackGroup fastaGroup = new SampleTrackGroup(dataView, null, null, null, fastaConversion, this.getTitle(interpretation));
                    analyses.addTrackGroup(fastaGroup);
                    break;
                }
                case CNA: {
                    analyses.setScrollEnabled(true);
                    CnaConversion cnaData = interpretation.getCnaDataThread(this);
                    LinkedList<String> internalSampleNames = cnaData.getSampleNames();
                    this.sampleNames = this.getSampleNames(internalSampleNames, interpretation.getPrimaryData());
                    CnaFrequenciesTrackGroup frequencies = new CnaFrequenciesTrackGroup(dataView, cnaData, this.sampleNames, title);
                    CnaCallsTrackGroup calls = new CnaCallsTrackGroup(dataView, cnaData, this.sampleNames, title);
                    CnaLogRatiosTrackGroup logRatios = new CnaLogRatiosTrackGroup(dataView, cnaData, this.sampleNames, title);
                    analyses.addTrackGroup(frequencies);
                    analyses.addTrackGroup(TrackFactory.getThinSeparatorTrackGroup(this.plot));
                    analyses.addTrackGroup(calls);
                    analyses.addTrackGroup(TrackFactory.getThinSeparatorTrackGroup(this.plot));
                    analyses.addTrackGroup(logRatios);
                    break;
                }
            }
        }
        if (analyses.getTrackGroups().size() > 0) {
            dataView.addTrackGroup(TrackFactory.getThickSeparatorTrackGroup(this.plot));
        }
    }

    private void createSampleTracks(GBrowserView dataView, ScrollGroup samples) throws URISyntaxException, IOException {
        boolean firstReadTrack = true;
        for (Interpretation interpretation : this.interpretations) {
            if (interpretation.getType() != Interpretation.TrackType.READS) continue;
            String title = this.getTitle(interpretation);
            if (!firstReadTrack) {
                samples.addTrackGroup(TrackFactory.getThinSeparatorTrackGroup(this.plot));
            } else {
                firstReadTrack = false;
            }
            IndexedFastaConversion refSeqRequestHandler = Interpretation.getReferenceDataThread(this);
            BamToDetailsConversion details = interpretation.getBamDetailsDataThread(this);
            BamToCoverageConversion coverage = interpretation.getBamCoverageDataThread(this);
            BamToCoverageEstimateConversion estimate = interpretation.getBamCoverageEstimateDataThread(this);
            SampleTrackGroup readGroup = new SampleTrackGroup(dataView, details, coverage, estimate, refSeqRequestHandler, title);
            readGroup.initialise();
            samples.addTrackGroup(readGroup);
        }
        if (firstReadTrack) {
            samples.setScrollEnabled(false);
            IndexedFastaConversion refSeqRequestHandler = Interpretation.getReferenceDataThread(this);
            if (refSeqRequestHandler != null) {
                SampleTrackGroup readGroup = new SampleTrackGroup(dataView, null, null, null, refSeqRequestHandler, this.settings.getGenome().toString());
                readGroup.initialise();
                samples.addTrackGroup(readGroup);
            }
        }
    }

    private void createAnnotationTracks(GBrowserView dataView, ScrollGroup annotations) {
        GtfToFeatureConversion gtfRequestHandler = Interpretation.getAnnotationDataThread(this);
        BedTabixToRegionConversion repeatRequestHandler = Interpretation.getRepeatDataThread(this);
        this.gia = Interpretation.getGeneSearchDataThread(this);
        AnnotationTrackGroup geneGroup = new AnnotationTrackGroup(dataView, gtfRequestHandler, repeatRequestHandler, false);
        annotations.addTrackGroup(geneGroup);
    }

    private void createOverviewTracks(GBrowserView dataView, GBrowserView overviewView, ScrollGroup overviewScrollGroup) {
        CytobandConversion cytobandDataThread = Interpretation.getCytobandDataThread(this);
        if (cytobandDataThread != null) {
            CytobandTrack overviewCytobands = new CytobandTrack(false);
            overviewCytobands.setView(overviewView);
            overviewCytobands.addDataThread(cytobandDataThread);
            TrackGroup cytobandTrackGroup = new TrackGroup(overviewCytobands);
            overviewScrollGroup.addTrackGroup(cytobandTrackGroup);
            this.viewLimiter = new ViewLimiter(overviewView.getQueueManager(), cytobandDataThread, overviewView);
            dataView.setViewLimiter(this.viewLimiter);
            overviewView.setViewLimiter(this.viewLimiter);
        }
    }

    private String getTitle(Interpretation interpretation) {
        if (interpretation != null && interpretation.getPrimaryData() != null) {
            return interpretation.getPrimaryData().getName();
        }
        return null;
    }

    public DataUrl getAnnotationUrl(AnnotationManager.Genome genome, AnnotationManager.AnnotationType type) {
        AnnotationManager.GenomeAnnotation annotation = this.annotationManager.getAnnotation(genome, type);
        if (annotation != null) {
            return annotation.getUrl();
        }
        Interpretation customGenome = this.getCustomGenome(genome);
        if (customGenome != null) {
            if (type == AnnotationManager.AnnotationType.REFERENCE) {
                return customGenome.getPrimaryData();
            }
            if (type == AnnotationManager.AnnotationType.REFERENCE_INDEX) {
                return customGenome.getIndexData();
            }
        }
        return null;
    }

    private Interpretation getCustomGenome(AnnotationManager.Genome genome) {
        for (Interpretation interpretation : this.interpretations) {
            if (!interpretation.getName().equals(genome.speciesId)) continue;
            return interpretation;
        }
        return null;
    }

    public void showVisualisation() throws URISyntaxException, IOException, GBrowserException {
        if (this.plot != null) {
            this.plot.clean();
        }
        Region defaultLocation = new Region((long)((double)this.settings.getLocation().longValue() - (double)this.settings.getViewSize().longValue() / 2.0), (long)((double)this.settings.getLocation().longValue() + (double)this.settings.getViewSize().longValue() / 2.0), this.settings.getChromosome());
        this.plot = new GBrowserPlot(this, true, defaultLocation);
        this.plot.addDataRegionListener(this.settings);
        this.updateCoverageScale();
        this.updateTracks();
        this.settings.updateTracks();
        if (this.plotPanel.getComponentCount() == 2) {
            this.plotPanel.remove(1);
        }
        this.plotPanel.add(this.plot.getComponent(), PLOTPANEL);
        CardLayout cl = (CardLayout)this.plotPanel.getLayout();
        cl.show(this.plotPanel, PLOTPANEL);
    }

    private GeneIndexActions getGeneIndexActions() {
        if (this.gia == null) {
            this.showDialog("Gene search not available", "Gene search is disabled, because there is no annotation data for this genome.", null, true, false, true, false);
        }
        return this.gia;
    }

    public void requestGeneSearch(String gene) {
        if (this.getGeneIndexActions() != null) {
            this.runBlockingTask("searching gene", new Runnable(){

                @Override
                public void run() {
                    int TIME_OUT = 30000;
                    int INTERVAL = 100;
                    long startTime = System.currentTimeMillis();
                    while (System.currentTimeMillis() < startTime + (long)TIME_OUT && !GBrowser.this.geneSearchDone) {
                        try {
                            Thread.sleep(INTERVAL);
                        }
                        catch (InterruptedException e) {}
                    }
                    if (GBrowser.this.geneSearchDone) {
                        GBrowser.this.geneSearchDone = false;
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GBrowser.this.showDialog("Search failed", "Unexpected error happened in the search. Please inform the developers if the problem persists.", null, true, false, false, false);
                            }
                        });
                    }
                }
            });
            this.getGeneIndexActions().requestLocation(gene, new GeneIndexActions.GeneLocationListener(){

                @Override
                public void geneLocation(Region geneLocation) {
                    GBrowser.this.geneSearchDone = true;
                    if (geneLocation == null) {
                        GBrowser.this.settings.processLocationPanelInput();
                        GBrowser.this.showDialog("Not found", "Gene was not found", null, false, false, false, false);
                    } else {
                        Chromosome resultChr = new Chromosome(geneLocation.start.chr);
                        if (GBrowser.this.settings.setChromosome(resultChr)) {
                            GBrowser.this.setLocation(GBrowser.this.settings.getChromosome(), geneLocation.start.bp, geneLocation.end.bp);
                        } else {
                            GBrowser.this.showDialog("Different chromosome", "Searched gene was found from chromosome " + resultChr + " but there is no data for that chromosome", "" + geneLocation, true, false, false, false);
                        }
                    }
                }
            });
        }
    }

    public void setLocation(Chromosome chr, Long start, Long end) {
        this.settings.setChromosome(chr);
        if (end == null) {
            end = start;
        }
        this.settings.setCoordinateFields((end + start) / 2L, (end - start) * 2L);
        this.plot.moveDataBpRegion(this.settings.getChromosome(), this.settings.getLocation(), this.settings.getViewSize());
        this.plot.setReadScale(this.settings.getCoverageScale());
    }

    public void removeVisualisation() {
        this.plotPanel.removeAll();
        if (this.plot != null) {
            this.plot.clean();
            this.plot = null;
        }
        if (this.interpretations != null) {
            this.interpretations.clear();
        }
        this.gia = null;
    }

    public LinkedList<Chromosome> getChromosomeNames() throws IOException, UnsortedDataException, URISyntaxException, GBrowserException {
        TreeSet<Chromosome> chromosomes = new TreeSet<Chromosome>();
        for (Interpretation interpretation : this.interpretations) {
            if (interpretation.getType() != Interpretation.TrackType.READS) continue;
            chromosomes.addAll(interpretation.getChromosomeNames());
        }
        if (chromosomes.isEmpty()) {
            for (Interpretation interpretation : this.getInterpretations()) {
                if (interpretation.getType() == Interpretation.TrackType.READS) continue;
                chromosomes.addAll(interpretation.getChromosomeNames());
            }
        }
        LinkedList<Chromosome> list = new LinkedList<Chromosome>();
        for (Chromosome chromosome : chromosomes) {
            list.add(chromosome);
        }
        return list;
    }

    public List<Interpretation> getInterpretations() {
        return this.interpretations;
    }

    public String getExternalLinkUrl(AnnotationManager.AnnotationType browser) {
        this.settings.getGenome();
        AnnotationManager.GenomeAnnotation urlAnnotation = this.annotationManager.getAnnotation(this.settings.getGenome(), browser);
        if (urlAnnotation != null) {
            URL url = null;
            try {
                url = urlAnnotation.getUrl().getUrl();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (url != null && this.plot != null && this.plot.getDataView() != null && this.plot.getDataView().getBpRegion() != null) {
                String stringUrl = url.toString();
                Region region = this.plot.getDataView().getBpRegion();
                stringUrl = stringUrl.replace("[CHR]", region.start.chr.toNormalisedString());
                stringUrl = stringUrl.replace("[START]", region.start.bp.toString());
                stringUrl = stringUrl.replace("[END]", region.end.bp.toString());
                return stringUrl;
            }
        }
        return "";
    }

    public void openExternalBrowser(String url) {
        try {
            BrowserLauncher.openURL(url);
        }
        catch (Exception e) {
            this.reportException(e);
        }
    }

    public JPanel getParameterPanel() {
        return this.settings.getParameterPanel();
    }

    public AnnotationManager getAnnotationManager() {
        return this.annotationManager;
    }

    public void reportException(Exception e) {
        e.printStackTrace();
    }

    public void showDialog(String title, String message, String details, boolean warning, boolean dialogShowDetails, boolean modal, boolean closeBrowser) {
        System.out.println("showDialog not implemented: " + title + "\t" + message + "\t" + details);
    }

    public void runBlockingTask(String taskName, Runnable runnable) {
        System.out.println("runBlockingTask: " + taskName);
        new Thread(runnable).start();
    }

    public void initialiseUserDatas() throws IOException {
    }

    public ImageIcon getIcon(String path) {
        System.out.println("getIcon not implemented");
        return new ImageIcon();
    }

    public void openDownloadAnnotationsDialog(AnnotationManager.Genome genome) {
        try {
            this.getAnnotationManager().downloadAnnotations(genome);
        }
        catch (IOException e) {
            this.reportException(e);
        }
    }

    public List<URL> getRemoteAnnotationFiles() throws Exception {
        System.out.println("getRemoteAnnotationFiles not implemented");
        return null;
    }

    public File getLocalAnnotationDir() throws IOException {
        System.out.println("getLocalAnnotationDir not implemented");
        return null;
    }

    public LinkedList<String> getSampleNames(LinkedList<String> internalSampleNames, DataUrl dataUrl) {
        return internalSampleNames;
    }

    public void updateData() throws URISyntaxException, IOException, GBrowserException {
        this.updateTracks();
        this.settings.updateVisibilityForTracks();
        this.plot.updateData();
    }

    public GBrowserPlot getPlot() {
        return this.plot;
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public void initializeDataResultListeners() {
        this.plot.initializeDataResultListeners();
        if (this.gia != null) {
            this.gia.initializeDataResultListeners();
        }
    }
}

