/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.selection.IntegratedEntity;
import fi.csc.microarray.client.selection.IntegratedSelectionManager;
import fi.csc.microarray.client.visualisation.ExtendedJXTable;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationUtilities;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.QueryResult;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.module.Module;
import fi.csc.microarray.module.basic.BasicModule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.hyperlink.AbstractHyperlinkAction;
import org.jdesktop.swingx.hyperlink.LinkModel;
import org.jdesktop.swingx.hyperlink.LinkModelAction;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.HyperlinkProvider;

public class Spreadsheet
extends Visualisation {
    private final int COLUMNS_REQUIRES_SCROLLING = 8;
    private ExtendedJXTable table;

    @Override
    public void initialise(VisualisationFrame frame) throws Exception {
        super.initialise(frame);
    }

    @Override
    public JComponent getVisualisation(final DataBean data) throws Exception {
        int columnCount;
        int rowCount;
        List<Object> linkableFlags;
        Object rowData;
        Object[] columnTitles;
        JPanel panel = new JPanel(new BorderLayout());
        Module primaryModule = Session.getSession().getPrimaryModule();
        QueryResult columnsFeature = data.queryFeatures("restrict(/column/*)");
        Table columns = columnsFeature.asTable();
        if (columns == null) {
            columnTitles = new String[]{"Info"};
            rowData = new String[][]{{"Data currently not available"}};
            linkableFlags = new LinkedList<Boolean>();
            linkableFlags.add(false);
            rowCount = 1;
            columnCount = 1;
        } else {
            columnTitles = new String[columns.getColumnCount()];
            int counter = 0;
            String[] arr$ = columns.getColumnNames();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String column;
                columnTitles[counter] = column = arr$[i$];
                ++counter;
            }
            columnCount = columns.getColumnCount();
            linkableFlags = primaryModule.flagLinkableColumns(columns, data);
            Table rowCounter = data.queryFeatures("/column/*").asTable();
            rowCount = 0;
            while (rowCounter.nextRow()) {
                ++rowCount;
            }
            rowData = new Object[10000 < rowCount ? 10000 : rowCount][columns.getColumnCount()];
            int row = 0;
            while (columns.nextRow()) {
                int column = 0;
                for (String columnName : columns.getColumnNames()) {
                    Object value = columns.getValue(columnName);
                    IntegratedEntity linkedEntity = null;
                    if (((Boolean)linkableFlags.get(column)).booleanValue()) {
                        linkedEntity = primaryModule.createLinkableEntity(columns, data);
                    }
                    ExtendedCellValue cell = value instanceof Float ? new ExtendedCellValue(columns.getStringValue(columnName), (Float)value, linkedEntity) : new ExtendedCellValue(columns.getStringValue(columnName), null, linkedEntity);
                    rowData[row][column] = cell;
                    ++column;
                }
                ++row;
            }
        }
        this.table = new ExtendedJXTable(data);
        DefaultTableModel tableModel = new DefaultTableModel((Object[][])rowData, columnTitles){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table.setModel(tableModel);
        for (int i = 0; i < linkableFlags.size(); ++i) {
            if (!((Boolean)linkableFlags.get(i)).booleanValue()) continue;
            LinkModelAction<ExtendedCellValue> linkAction = new LinkModelAction<ExtendedCellValue>(){

                public void actionPerformed(ActionEvent e) {
                    IntegratedSelectionManager selectionManager = Spreadsheet.this.application.getSelectionManager().getSelectionManager(data);
                    selectionManager.setPointSelection(((ExtendedCellValue)this.target).getLinkedEntity(), (Object)this);
                }
            };
            this.table.getColumn(i).setCellRenderer((TableCellRenderer)new DefaultTableRenderer((ComponentProvider)new HyperlinkProvider((AbstractHyperlinkAction)linkAction)));
        }
        this.table.setColumnControlVisible(true);
        JScrollPane tableScroller = new JScrollPane((Component)((Object)this.table));
        this.table.setBackground(Color.white);
        this.table.setHorizontalScrollEnabled(columnCount > 8);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    SpreadsheetPopupMenu popup = new SpreadsheetPopupMenu(Spreadsheet.this.table, Session.getSession().getPrimaryModule());
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        panel.add((Component)new JLabel("Showing " + ((Object[][])rowData).length + " rows of " + rowCount), "North");
        panel.add((Component)tableScroller, "Center");
        this.table.updateSelectionsFromApplication();
        this.table.sendEvents(true);
        return panel;
    }

    @Override
    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        return bean.hasTypeTag(BasicModule.TypeTags.TABLE_WITH_COLUMN_NAMES) || bean.hasTypeTag(BasicModule.TypeTags.TABLE_WITHOUT_COLUMN_NAMES);
    }

    @Override
    public void removeVisualisation() {
        this.application.removeClientEventListener(this.table);
    }

    public static class ExtendedCellValue
    extends LinkModel
    implements Comparable {
        private String value;
        private Float numericValue;
        private IntegratedEntity linkedEntity;

        public ExtendedCellValue(String value, Float numericValue, IntegratedEntity linkedEntity) {
            this.value = value;
            this.numericValue = numericValue;
            this.linkedEntity = linkedEntity;
        }

        public IntegratedEntity getLinkedEntity() {
            return this.linkedEntity;
        }

        public boolean equals(Object otherObj) {
            if (!(otherObj instanceof ExtendedCellValue)) {
                throw new IllegalArgumentException("cannot compare to instance of " + otherObj.getClass().getSimpleName());
            }
            ExtendedCellValue other = (ExtendedCellValue)otherObj;
            if (this.numericValue != null && other.numericValue != null) {
                return this.numericValue.equals(other.numericValue);
            }
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.numericValue != null ? this.numericValue.hashCode() : this.value.hashCode();
        }

        public String toString() {
            return this.getText();
        }

        public String getText() {
            return this.value;
        }

        public int compareTo(Object otherObj) {
            if (!(otherObj instanceof ExtendedCellValue)) {
                throw new IllegalArgumentException("cannot compare to instance of " + otherObj.getClass().getSimpleName());
            }
            ExtendedCellValue other = (ExtendedCellValue)otherObj;
            if (this.numericValue != null && other.numericValue != null) {
                return this.numericValue.compareTo(other.numericValue);
            }
            return this.value.compareTo(other.value);
        }
    }

    public class SpreadsheetPopupMenu
    extends JPopupMenu {
        public SpreadsheetPopupMenu(final ExtendedJXTable table, Module primaryModule) {
            JMenuItem copyMenuItem = new JMenuItem();
            copyMenuItem.setText("Copy");
            copyMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    table.copy();
                }
            });
            this.add(copyMenuItem);
            this.add(new JSeparator());
            JMenuItem filterMenuItem = new JMenuItem();
            filterMenuItem.setText("Create dataset from selected");
            filterMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VisualisationUtilities.filterBySelection(Spreadsheet.this.getFrame().getDatas(), false);
                }
            });
            this.add(filterMenuItem);
            JMenuItem filter2MenuItem = new JMenuItem();
            filter2MenuItem.setText("Create dataset from unselected");
            filter2MenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VisualisationUtilities.filterBySelection(Spreadsheet.this.getFrame().getDatas(), true);
                }
            });
            this.add(filter2MenuItem);
        }
    }
}

