/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.tasks;

import fi.csc.chipster.tools.ngs.LocalNGSPreprocess;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.tasks.Task;
import fi.csc.microarray.client.tasks.TaskException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.filebroker.NotEnoughDiskSpaceException;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.TempTopicMessagingListenerBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.messaging.message.ResultMessage;
import fi.csc.microarray.util.Exceptions;
import fi.csc.microarray.util.IOUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.SwingPropertyChangeSupport;
import org.apache.log4j.Logger;

public class TaskExecutor {
    private static final Logger logger = Logger.getLogger(TaskExecutor.class);
    private DataManager manager;
    private MessagingTopic requestTopic;
    private LinkedList<Task> tasks = new LinkedList();
    private LinkedList<Task> runningTasks = new LinkedList();
    private SwingPropertyChangeSupport jobExecutorStateChangeSupport;
    private boolean eventsEnabled = false;

    public TaskExecutor(MessagingEndpoint endpoint, DataManager manager) throws Exception {
        this.manager = manager;
        this.requestTopic = endpoint.createTopic(Topics.Name.REQUEST_TOPIC, MessagingTopic.AccessMode.WRITE);
        this.jobExecutorStateChangeSupport = new SwingPropertyChangeSupport(this);
    }

    protected TaskExecutor(DataManager manager) throws JMSException {
        this.manager = manager;
        this.jobExecutorStateChangeSupport = new SwingPropertyChangeSupport(this);
    }

    public Task createTask(Operation operation) {
        return new Task(operation);
    }

    public void startExecuting(Task task) throws TaskException {
        this.startExecuting(task, -1);
    }

    public void startExecuting(final Task task, int timeout) throws TaskException {
        logger.debug((Object)("Starting task " + task.getName()));
        if (task.isLocal()) {
            LocalNGSPreprocess taskRunnable = new LocalNGSPreprocess(task);
            ClientApplication app = Session.getSession().getApplication();
            app.runBlockingTask("running " + task.getNamePrettyPrinted(), taskRunnable);
            return;
        }
        try {
            List<String> parameters = task.getParameters();
            logger.debug((Object)("we have " + parameters.size() + " parameters"));
            for (String parameter : parameters) {
                logger.debug((Object)("parameter: " + parameter));
            }
        }
        catch (MicroarrayException e1) {
            logger.error((Object)"Could not log parameters.");
        }
        task.setStartTime(System.currentTimeMillis());
        this.addToRunningTasks(task);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JobMessage jobMessage = new JobMessage(task.getId(), task.getOperationID(), task.getParameters());
                    logger.debug((Object)"adding inputs to job message");
                    TaskExecutor.this.updateTaskState(task, Task.State.TRANSFERRING_INPUTS, null, -1);
                    int i = 0;
                    for (final String name : task.getInputNames()) {
                        final int fi = i++;
                        IOUtils.CopyProgressListener progressListener = new IOUtils.CopyProgressListener(){
                            long length;
                            {
                                this.length = Session.getSession().getApplication().getDataManager().getContentLength(task.getInput(name));
                            }

                            @Override
                            public void progress(long bytes) {
                                float overall = (float)fi / (float)task.getInputCount();
                                float current = (float)bytes / (float)this.length;
                                float total = overall + current / (float)task.getInputCount();
                                TaskExecutor.this.updateTaskState(task, Task.State.TRANSFERRING_INPUTS, null, Math.round(total * 100.0f));
                            }
                        };
                        DataBean bean = task.getInput(name);
                        TaskExecutor.this.manager.uploadToCacheIfNeeded(bean, progressListener);
                        jobMessage.addPayload(name, bean.getId());
                        logger.debug((Object)("added input " + name + " to job message."));
                    }
                    TaskExecutor.this.updateTaskState(task, Task.State.WAITING, null, -1);
                    ResultMessageListener replyListener = new ResultMessageListener(task);
                    logger.debug((Object)("sending job message, jobId: " + jobMessage.getJobId()));
                    TaskExecutor.this.requestTopic.sendReplyableMessage(jobMessage, replyListener);
                }
                catch (NotEnoughDiskSpaceException nedse) {
                    logger.warn((Object)"received not enough disk space when uploading input", (Throwable)nedse);
                    TaskExecutor.this.updateTaskState(task, Task.State.FAILED_USER_ERROR, "Not enough disk space", -1);
                    task.setErrorMessage("There was not enough disk space in Chipster server to run the task. Please try again later.");
                    TaskExecutor.this.removeFromRunningTasks(task);
                }
                catch (Exception e) {
                    logger.error((Object)"Could not send job message.", (Throwable)e);
                    TaskExecutor.this.updateTaskState(task, Task.State.ERROR, "Sending message failed: " + e.getMessage(), -1);
                    TaskExecutor.this.removeFromRunningTasks(task);
                }
            }
        }).start();
        logger.debug((Object)"task starter thread started");
        if (timeout != -1) {
            Timer timer = new Timer(timeout, new TimeoutListener(task));
            timer.setRepeats(false);
            timer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Task task) throws TaskException {
        this.startExecuting(task);
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            while (!task.getState().isFinished()) {
                try {
                    this.runningTasks.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(Task task) {
        logger.debug((Object)("TaskExecutor killing task " + task.getId()));
        Task task2 = task;
        synchronized (task2) {
            if (task.getState().isFinished()) {
                logger.debug((Object)"Task already finished, no need to cancel.");
                return;
            }
            this.updateTaskState(task, Task.State.CANCELLED, null, -1);
        }
        this.sendCancelMessage(task);
        this.removeFromRunningTasks(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAll() {
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            LinkedList<Task> tasksToKill = new LinkedList<Task>();
            for (Task task : this.runningTasks) {
                tasksToKill.add(task);
            }
            for (Task task : tasksToKill) {
                this.kill(task);
            }
            this.runningTasks.clear();
            SwingUtilities.invokeLater(new TaskExecutorChangeNotifier(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Task> getTasks(boolean onlyRunning, boolean showHidden) {
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            LinkedList<Task> taskList;
            LinkedList<Task> linkedList2 = taskList = onlyRunning ? this.runningTasks : this.tasks;
            if (showHidden) {
                return taskList;
            }
            LinkedList<Task> prunedTaskList = new LinkedList<Task>();
            for (Task task : taskList) {
                if (task.isHidden()) continue;
                prunedTaskList.add(task);
            }
            return prunedTaskList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunningTaskCount() {
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            Collection<Task> taskList = this.getTasks(true, false);
            return taskList.size();
        }
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.jobExecutorStateChangeSupport.addPropertyChangeListener(listener);
    }

    public boolean isEventsEnabled() {
        return this.eventsEnabled;
    }

    public void setEventsEnabled(boolean eventsEnabled) {
        this.eventsEnabled = eventsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTaskState(Task task, Task.State state, String stateDetail, int completionPercentage) {
        Task.State oldState;
        Task task2 = task;
        synchronized (task2) {
            if (task.getState().isFinished()) {
                return;
            }
            oldState = task.getState();
            task.setState(state);
            if (stateDetail != null) {
                task.setStateDetail(stateDetail);
            }
            task.setCompletionPercentage(completionPercentage);
            SwingUtilities.invokeLater(new TaskExecutorChangeNotifier(this));
        }
        if (oldState != null) {
            task.notifyTaskStateChangeListener(oldState, state);
        }
    }

    private void dispatch(PropertyChangeEvent event) {
        if (this.eventsEnabled) {
            this.jobExecutorStateChangeSupport.firePropertyChange(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToRunningTasks(Task task) {
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            this.tasks.add(task);
            this.runningTasks.add(task);
            this.runningTasks.notifyAll();
        }
        SwingUtilities.invokeLater(new TaskExecutorChangeNotifier(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromRunningTasks(Task task) {
        LinkedList<Task> linkedList = this.runningTasks;
        synchronized (linkedList) {
            this.runningTasks.remove(task);
            this.runningTasks.notifyAll();
        }
        SwingUtilities.invokeLater(new TaskExecutorChangeNotifier(this));
    }

    private void sendCancelMessage(final Task task) {
        logger.debug((Object)("Sending cancel message for " + task.getId()));
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CommandMessage commandMessage = new CommandMessage("cancel");
                    commandMessage.addParameter(task.getId());
                    logger.debug((Object)"Sending cancel message.");
                    TaskExecutor.this.requestTopic.sendMessage(commandMessage);
                }
                catch (Exception e) {
                    logger.error((Object)("Could not send cancel message for " + task.getId()), (Throwable)e);
                }
            }
        }).start();
        logger.debug((Object)"Message cancel thread started.");
    }

    private void resendJobMessage(Task task, Destination replyTo) throws Exception {
        JobMessage jobMessage = new JobMessage(task.getId(), task.getOperationID(), task.getParameters());
        for (String name : task.getInputNames()) {
            DataBean bean = task.getInput(name);
            this.manager.uploadToCacheIfNeeded(bean, null);
            jobMessage.addPayload(name, bean.getId());
        }
        jobMessage.setReplyTo(replyTo);
        logger.debug((Object)("Retry replyTo is: " + jobMessage.getReplyTo()));
        this.requestTopic.sendMessage(jobMessage);
    }

    private class ResultMessageListener
    extends TempTopicMessagingListenerBase {
        Task pendingTask;
        ResultListenerState internalState;
        String asId;

        public ResultMessageListener(Task pendingTask) {
            this.pendingTask = pendingTask;
            this.internalState = ResultListenerState.WAIT_FOR_ACK;
        }

        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            ResultMessage resultMessage;
            logger.debug((Object)("Task " + this.pendingTask.getId() + " got message (" + msg.getMessageID() + ") of type " + msg.getClass().getName()));
            if (this.internalState.equals((Object)ResultListenerState.FINISHED)) {
                return;
            }
            if (this.pendingTask.getState().isFinished()) {
                logger.debug((Object)("Task " + this.pendingTask.getId() + " already finished, ignoring message."));
                this.internalState = ResultListenerState.FINISHED;
                return;
            }
            if (msg instanceof ResultMessage) {
                resultMessage = (ResultMessage)msg;
                if (JobState.ERROR.equals((Object)resultMessage.getState())) {
                    logger.debug((Object)("Task " + this.pendingTask.getId() + " got result message with ERROR."));
                    this.taskFinished(Task.State.ERROR, resultMessage.getStateDetail(), resultMessage);
                    return;
                }
                if (JobState.FAILED_USER_ERROR.equals((Object)resultMessage.getState())) {
                    this.taskFinished(Task.State.FAILED_USER_ERROR, resultMessage.getStateDetail(), resultMessage);
                    return;
                }
            }
            block4 : switch (this.internalState) {
                case WAIT_FOR_ACK: {
                    if (!(msg instanceof CommandMessage)) break;
                    CommandMessage commandMessage = (CommandMessage)msg;
                    if ("acknowledge".equals(commandMessage.getCommand())) {
                        logger.debug((Object)"Got ACK message.");
                        this.internalState = ResultListenerState.WAIT_FOR_OFFER;
                        break;
                    }
                    if (!"offer".equals(commandMessage.getCommand())) break;
                    this.asId = commandMessage.getNamedParameter("as-id");
                    logger.debug((Object)("Got OFFER from " + this.asId));
                    this.internalState = ResultListenerState.WAIT_FOR_STATUS;
                    CommandMessage acceptMessage = new CommandMessage("choose");
                    acceptMessage.addNamedParameter("job-id", this.pendingTask.getId());
                    acceptMessage.addNamedParameter("as-id", this.asId);
                    logger.debug((Object)("Sending ACCEPT_OFFER to " + this.asId));
                    try {
                        TaskExecutor.this.requestTopic.sendMessage(acceptMessage);
                    }
                    catch (JMSException e) {
                        logger.error((Object)"Could not send accept message.", (Throwable)e);
                        this.pendingTask.setErrorMessage(e.toString());
                        this.taskFinished(Task.State.ERROR, "Sending message failed", null);
                    }
                    break;
                }
                case WAIT_FOR_OFFER: {
                    CommandMessage commandMessage;
                    if (!(msg instanceof CommandMessage) || !"offer".equals((commandMessage = (CommandMessage)msg).getCommand())) break;
                    this.asId = commandMessage.getNamedParameter("as-id");
                    this.internalState = ResultListenerState.WAIT_FOR_STATUS;
                    CommandMessage acceptMessage = new CommandMessage("choose");
                    acceptMessage.addNamedParameter("job-id", this.pendingTask.getId());
                    acceptMessage.addNamedParameter("as-id", this.asId);
                    try {
                        TaskExecutor.this.requestTopic.sendMessage(acceptMessage);
                    }
                    catch (JMSException e) {
                        logger.error((Object)"Could not send accept message.", (Throwable)e);
                        this.pendingTask.setErrorMessage(e.toString());
                        this.taskFinished(Task.State.ERROR, "Sending message failed", null);
                    }
                    break;
                }
                case WAIT_FOR_STATUS: {
                    if (!(msg instanceof ResultMessage)) break;
                    resultMessage = (ResultMessage)msg;
                    JobState jobState = resultMessage.getState();
                    switch (jobState) {
                        case NEW: {
                            break block4;
                        }
                        case RUNNING: {
                            TaskExecutor.this.updateTaskState(this.pendingTask, Task.State.RUNNING, resultMessage.getStateDetail(), -1);
                            break block4;
                        }
                        case COMPLETED: {
                            TaskExecutor.this.updateTaskState(this.pendingTask, Task.State.TRANSFERRING_OUTPUTS, null, -1);
                            try {
                                this.extractOutputs(resultMessage);
                            }
                            catch (Exception e) {
                                logger.error((Object)"Getting outputs failed", (Throwable)e);
                                e.printStackTrace();
                                this.pendingTask.setErrorMessage(Exceptions.getStackTrace(e));
                                this.taskFinished(Task.State.ERROR, "Transferring outputs failed", null);
                                break block4;
                            }
                            this.taskFinished(Task.State.COMPLETED, null, resultMessage);
                            break block4;
                        }
                        case FAILED: {
                            this.taskFinished(Task.State.FAILED, resultMessage.getStateDetail(), resultMessage);
                            break block4;
                        }
                        case FAILED_USER_ERROR: {
                            this.taskFinished(Task.State.FAILED_USER_ERROR, resultMessage.getStateDetail(), resultMessage);
                            break block4;
                        }
                        case TIMEOUT: {
                            this.taskFinished(Task.State.FAILED, resultMessage.getStateDetail(), resultMessage);
                            break block4;
                        }
                        case RETRY: {
                            if (!this.pendingTask.hasBeenRetried()) {
                                logger.debug((Object)("Resending job " + this.pendingTask.getId()));
                                this.pendingTask.changeId();
                                try {
                                    TaskExecutor.this.resendJobMessage(this.pendingTask, resultMessage.getReplyTo());
                                }
                                catch (Exception e) {
                                    logger.error((Object)("Could not resend job " + this.pendingTask.getId()), (Throwable)e);
                                    this.pendingTask.setErrorMessage(e.toString());
                                    this.taskFinished(Task.State.ERROR, "Resending job failed", null);
                                }
                                this.pendingTask.setHasBeenRetried(true);
                                break block4;
                            }
                            logger.error((Object)("Not resending the job message for the second time " + this.pendingTask.getId()));
                            this.pendingTask.setErrorMessage("Resending task failed.");
                            this.taskFinished(Task.State.ERROR, "Retransferring data failed", null);
                        }
                    }
                }
            }
            if (this.pendingTask.getState().isFinished() && this.internalState != ResultListenerState.FINISHED) {
                this.internalState = ResultListenerState.FINISHED;
            }
        }

        private void extractOutputs(ResultMessage resultMessage) throws JMSException, MicroarrayException, IOException {
            for (String name : resultMessage.payloadNames()) {
                logger.debug((Object)("output " + name));
                String dataId = resultMessage.getPayload(name);
                DataBean bean = TaskExecutor.this.manager.createDataBean(name, dataId, true);
                this.pendingTask.addOutput(name, bean);
            }
        }

        private void taskFinished(Task.State state, String stateDetail, ResultMessage resultMessage) {
            this.cleanUp();
            if (resultMessage != null) {
                if (resultMessage.getOutputText() != null) {
                    this.pendingTask.setScreenOutput(resultMessage.getOutputText());
                }
                if (resultMessage.getErrorMessage() != null) {
                    this.pendingTask.setErrorMessage(resultMessage.getErrorMessage());
                }
                this.pendingTask.setSourceCode(resultMessage.getSourceCode());
            }
            this.pendingTask.setEndTime(System.currentTimeMillis());
            TaskExecutor.this.updateTaskState(this.pendingTask, state, stateDetail, -1);
            this.internalState = ResultListenerState.FINISHED;
            TaskExecutor.this.removeFromRunningTasks(this.pendingTask);
        }
    }

    private static enum ResultListenerState {
        WAIT_FOR_ACK,
        WAIT_FOR_OFFER,
        WAIT_FOR_STATUS,
        FINISHED,
        TIMEOUT;

    }

    private class TaskExecutorChangeNotifier
    implements Runnable {
        private TaskExecutor parent;

        public TaskExecutorChangeNotifier(TaskExecutor parent) {
            this.parent = parent;
        }

        @Override
        public void run() {
            TaskExecutor.this.dispatch(new PropertyChangeEvent(this.parent, "runningJobCount", null, TaskExecutor.this.getRunningTaskCount()));
        }
    }

    private class TimeoutListener
    implements ActionListener {
        Task taskToMonitor;

        TimeoutListener(Task taskToMonitor) {
            this.taskToMonitor = taskToMonitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Task task = this.taskToMonitor;
            synchronized (task) {
                if (!this.taskToMonitor.getState().isFinished()) {
                    TaskExecutor.this.updateTaskState(this.taskToMonitor, Task.State.TIMEOUT, null, -1);
                }
            }
            TaskExecutor.this.removeFromRunningTasks(this.taskToMonitor);
            TaskExecutor.this.sendCancelMessage(this.taskToMonitor);
        }
    }
}

