/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.tasks;

import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.tasks.TaskEventListener;
import fi.csc.microarray.client.tasks.TaskException;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.util.ThreadUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Task {
    private Operation operation;
    private String id;
    private State state = State.NEW;
    private String stateDetail = "";
    private int completionPercentage = -1;
    private long startTime;
    private long endTime;
    private String errorMessage;
    private String screenOutput;
    private String sourceCode;
    private Map<String, DataBean> outputs = new HashMap<String, DataBean>();
    private boolean hasBeenRetried = false;
    private boolean hidden = false;
    private List<TaskEventListener> listeners = new LinkedList<TaskEventListener>();
    private boolean isLocal;

    public Task(Operation operation) {
        this.operation = operation;
        this.id = this.generateId();
        this.isLocal = operation.getDefinition().isLocal();
    }

    public String getName() {
        return this.operation.getDefinition().getFullName();
    }

    public String getOperationID() {
        return this.operation.getID();
    }

    public String getNamePrettyPrinted() {
        return this.operation.getDefinition().getFullName();
    }

    public Iterable<DataBean> getInputs() {
        LinkedList<DataBean> beans = new LinkedList<DataBean>();
        for (Operation.DataBinding binding : this.operation.getBindings()) {
            beans.add(binding.getData());
        }
        return beans;
    }

    public List<String> getParameters() throws TaskException, MicroarrayException {
        LinkedList<String> parameterStrings = new LinkedList<String>();
        for (Parameter parameter : this.operation.getParameters()) {
            parameterStrings.add(parameter.getValueAsString());
        }
        return parameterStrings;
    }

    public DataBean getOutput(String name) {
        return this.outputs.get(name);
    }

    public DataBean getInput(String name) {
        Operation.DataBinding binding = this.operation.getBinding(name);
        if (binding != null) {
            return binding.getData();
        }
        return null;
    }

    public Iterable<String> getInputNames() {
        LinkedList<String> bindingNames = new LinkedList<String>();
        for (Operation.DataBinding binding : this.operation.getBindings()) {
            bindingNames.add(binding.getName());
        }
        return bindingNames;
    }

    public int getInputCount() {
        return this.operation.getBindings().size();
    }

    public void addOutput(String outputName, DataBean bean) {
        this.outputs.put(outputName, bean);
    }

    public synchronized void setState(State newState) {
        this.state = newState;
        this.stateDetail = "";
    }

    public void notifyTaskStateChangeListener(State oldState, State newState) {
        TaskStateChangeNotifier changeNotifier = new TaskStateChangeNotifier(oldState, newState);
        ThreadUtils.runInEDT(changeNotifier);
    }

    public synchronized State getState() {
        return this.state;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Iterable<String> outputNames() {
        return this.outputs.keySet();
    }

    public Iterable<DataBean> outputs() {
        return this.outputs.values();
    }

    public String getScreenOutput() {
        return this.screenOutput;
    }

    public void setScreenOutput(String screenOutput) {
        this.screenOutput = screenOutput;
    }

    public String getStateDetail() {
        if (this.stateDetail != null) {
            return this.stateDetail;
        }
        return "";
    }

    public void setStateDetail(String stateDetail) {
        this.stateDetail = stateDetail;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void changeId() {
        this.id = this.generateId();
    }

    public boolean hasBeenRetried() {
        return this.hasBeenRetried;
    }

    public void setHasBeenRetried(boolean hasBeenRetried) {
        this.hasBeenRetried = hasBeenRetried;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getExecutionTime() {
        if (this.endTime > this.startTime) {
            return this.endTime - this.startTime;
        }
        if (this.startTime > 0L) {
            return System.currentTimeMillis() - this.startTime;
        }
        return 0L;
    }

    private String generateId() {
        return UUID.randomUUID().toString();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void addTaskEventListener(TaskEventListener listener) {
        this.listeners.add(listener);
    }

    public void setCompletionPercentage(int completionPercentage) {
        this.completionPercentage = completionPercentage;
    }

    public int getCompletionPercentage() {
        return this.completionPercentage;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    private class TaskStateChangeNotifier
    implements Runnable {
        private State oldState;
        private State newState;

        public TaskStateChangeNotifier(State oldState, State newState) {
            this.oldState = oldState;
            this.newState = newState;
        }

        @Override
        public void run() {
            for (TaskEventListener listener : Task.this.listeners) {
                listener.onStateChange(Task.this, this.oldState, this.newState);
            }
        }
    }

    public static enum State {
        NEW("New"),
        TRANSFERRING_INPUTS("Transferring inputs"),
        WAITING("Waiting"),
        RUNNING("Running"),
        TRANSFERRING_OUTPUTS("Transferring outputs"),
        COMPLETED("Completed"),
        FAILED("Failed"),
        FAILED_USER_ERROR("Failed, fixable"),
        ERROR("Error"),
        CANCELLED("Cancelled"),
        TIMEOUT("Timeout");

        private String description;

        private State(String description) {
            this.description = description;
        }

        public boolean isFinished() {
            return this.equals((Object)COMPLETED) || this.equals((Object)FAILED) || this.equals((Object)FAILED_USER_ERROR) || this.equals((Object)ERROR) || this.equals((Object)CANCELLED) || this.equals((Object)TIMEOUT);
        }

        public boolean finishedSuccesfully() {
            return this.equals((Object)COMPLETED);
        }

        public String toString() {
            return this.description;
        }
    }
}

