/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.session;

import de.schlichtherle.truezip.zip.ZipFile;
import fi.csc.microarray.client.NameID;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.session.NonStoppingValidationEventHandler;
import fi.csc.microarray.client.session.UserSession;
import fi.csc.microarray.client.session.schema.DataType;
import fi.csc.microarray.client.session.schema.FolderType;
import fi.csc.microarray.client.session.schema.InputType;
import fi.csc.microarray.client.session.schema.LinkType;
import fi.csc.microarray.client.session.schema.NameType;
import fi.csc.microarray.client.session.schema.OperationType;
import fi.csc.microarray.client.session.schema.ParameterType;
import fi.csc.microarray.client.session.schema.SessionType;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.filebroker.ContentLengthException;
import fi.csc.microarray.util.IOUtils;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.zip.ZipException;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.eclipse.jetty.io.WriterOutputStream;
import org.xml.sax.SAXException;

public class SessionLoaderImpl1 {
    private static final Logger logger = Logger.getLogger(SessionLoaderImpl1.class);
    private DataManager dataManager;
    private File sessionFile;
    private SessionType sessionType;
    private boolean isDatalessSession;
    private LinkedHashMap<String, DataFolder> folders = new LinkedHashMap();
    private HashMap<DataFolder, FolderType> folderTypes = new HashMap();
    private LinkedHashMap<String, DataBean> dataBeans = new LinkedHashMap();
    private HashMap<DataBean, DataType> dataTypes = new HashMap();
    private LinkedHashMap<String, OperationRecord> operationRecords = new LinkedHashMap();
    private HashMap<OperationRecord, OperationType> operationTypes = new HashMap();

    public SessionLoaderImpl1(File sessionFile, DataManager dataManager, boolean isDatalessSession) {
        this.sessionFile = sessionFile;
        this.dataManager = dataManager;
        this.isDatalessSession = isDatalessSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMetadata() throws ZipException, IOException, JAXBException, SAXException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.sessionFile);
            InputStream metadataStream = zipFile.getInputStream(zipFile.getEntry("session.xml"));
            Unmarshaller unmarshaller = UserSession.getPreviousJAXBContext().createUnmarshaller();
            unmarshaller.setSchema(UserSession.getPreviousSchema());
            NonStoppingValidationEventHandler validationEventHandler = new NonStoppingValidationEventHandler();
            unmarshaller.setEventHandler((ValidationEventHandler)validationEventHandler);
            this.sessionType = (SessionType)unmarshaller.unmarshal((Source)new StreamSource(metadataStream), SessionType.class).getValue();
            if (validationEventHandler.hasEvents()) {
                throw new JAXBException("Invalid session file:\n" + validationEventHandler.getValidationEventsAsString());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeIfPossible(zipFile);
            throw throwable;
        }
        IOUtils.closeIfPossible(zipFile);
    }

    private void createFolders() {
        for (FolderType folderType : this.sessionType.getFolder()) {
            String name = folderType.getName();
            String id = folderType.getId();
            if (this.getDataItem(id) != null) {
                logger.warn((Object)("duplicate folder id: " + id + " , ignoring folder: " + name));
                continue;
            }
            DataFolder dataFolder = "0".equals(id) ? this.dataManager.getRootFolder() : this.dataManager.createFolder(name);
            this.folders.put(id, dataFolder);
            this.folderTypes.put(dataFolder, folderType);
        }
    }

    private void createDataBeans() {
        for (DataType dataType : this.sessionType.getData()) {
            DataBean dataBean;
            String id;
            block16: {
                String name = dataType.getName();
                id = dataType.getId();
                if (this.getDataItem(id) != null) {
                    logger.warn((Object)("duplicate data bean id: " + id + " , ignoring data bean: " + name));
                    continue;
                }
                String storageMethodString = dataType.getStorageType();
                DataManager.StorageMethod storageMethod = DataManager.StorageMethod.valueOfConverted(storageMethodString);
                String urlString = dataType.getUrl();
                URL url = null;
                try {
                    url = new URL(urlString);
                }
                catch (MalformedURLException e) {
                    logger.warn((Object)("could not parse url: " + urlString + " for data bean: " + name));
                    continue;
                }
                dataBean = null;
                if (storageMethod == DataManager.StorageMethod.LOCAL_SESSION_ZIP && !this.isDatalessSession) {
                    try {
                        url = new URL(this.sessionFile.toURI().toURL(), "#" + url.getRef());
                        dataBean = this.dataManager.createDataBean(name);
                        this.dataManager.addContentLocationForDataBean(dataBean, DataManager.StorageMethod.LOCAL_SESSION_ZIP, url);
                        break block16;
                    }
                    catch (MicroarrayException e1) {
                        logger.warn((Object)("could not create data bean: " + name));
                        continue;
                    }
                    catch (MalformedURLException e) {
                        logger.warn((Object)("could not create data bean: " + name));
                        continue;
                    }
                    catch (ContentLengthException e) {
                        logger.error((Object)e, (Throwable)e);
                        break block16;
                    }
                }
                try {
                    switch (storageMethod) {
                        case LOCAL_SESSION_ZIP: {
                            dataBean = this.dataManager.createDataBean(name);
                            this.dataManager.addContentLocationForDataBean(dataBean, DataManager.StorageMethod.LOCAL_SESSION_ZIP, url);
                            break;
                        }
                        case LOCAL_ORIGINAL: 
                        case LOCAL_TEMP: {
                            dataBean = this.dataManager.createDataBean(name);
                            this.dataManager.addContentLocationForDataBean(dataBean, DataManager.StorageMethod.LOCAL_ORIGINAL, url);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("unsupported storage method: " + storageMethodString);
                        }
                    }
                }
                catch (MicroarrayException e) {
                    logger.warn((Object)("could not create data bean: " + name));
                    continue;
                }
                catch (ContentLengthException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
            dataBean.setNotes(dataType.getNotes());
            dataBean.setContentType(this.dataManager.guessContentType(dataBean.getName()));
            this.dataBeans.put(id, dataBean);
            this.dataTypes.put(dataBean, dataType);
        }
    }

    private void createOperations() {
        for (OperationType operationType : this.sessionType.getOperation()) {
            OperationDefinition currentTool;
            String operationSessionId = operationType.getId();
            if (this.operationRecords.containsKey(operationSessionId)) {
                logger.warn((Object)("duplicate operation id: " + operationSessionId));
                continue;
            }
            OperationRecord operationRecord = new OperationRecord();
            operationRecord.setNameID(this.createNameID(operationType.getName()));
            operationRecord.setCategoryName(operationType.getCategory());
            String colorString = operationType.getCategoryColor();
            if (colorString != null) {
                operationRecord.setCategoryColor(Color.decode(colorString));
            }
            operationRecord.setModule(operationType.getModule());
            for (ParameterType parameterType : operationType.getParameter()) {
                operationRecord.addParameter(parameterType.getName().getId(), parameterType.getName().getDisplayName(), parameterType.getName().getDescription(), parameterType.getValue());
            }
            String sourceCodeFileName = operationType.getSourceCodeFile();
            if (sourceCodeFileName != null && !sourceCodeFileName.isEmpty()) {
                String sourceCode = null;
                try {
                    sourceCode = this.getSourceCode(sourceCodeFileName);
                }
                catch (Exception e) {
                    logger.warn((Object)("could not load source code from " + sourceCodeFileName));
                }
                operationRecord.setSourceCode(sourceCode);
            }
            if ((currentTool = Session.getSession().getApplication().getOperationDefinitionBestMatch(operationRecord.getNameID().getID(), operationRecord.getModule(), operationRecord.getCategoryName())) != null) {
                operationRecord.getNameID().setDisplayName(currentTool.getDisplayName());
                operationRecord.getNameID().setDescription(currentTool.getDescription());
                if (currentTool.getCategory().getModule() != null) {
                    operationRecord.setModule(currentTool.getCategory().getModule().getModuleName());
                }
                operationRecord.setCategoryName(currentTool.getCategoryName());
                operationRecord.setCategoryColor(currentTool.getCategory().getColor());
                for (OperationRecord.ParameterRecord parameterRecord : operationRecord.getParameters()) {
                    Parameter currentParameter = currentTool.getParameter(parameterRecord.getNameID().getID());
                    if (currentParameter == null) continue;
                    parameterRecord.getNameID().setDisplayName(currentParameter.getDisplayName());
                    parameterRecord.getNameID().setDescription(currentParameter.getDescription());
                }
            }
            this.operationRecords.put(operationSessionId, operationRecord);
            this.operationTypes.put(operationRecord, operationType);
        }
    }

    private void linkDataItemChildren(DataFolder parent) {
        for (String childId : this.folderTypes.get(parent).getChild()) {
            DataItem child = this.getDataItem(childId);
            if (child == null) {
                logger.warn((Object)("child with id: " + childId + " does not exist"));
                continue;
            }
            this.dataManager.connectChild(child, parent);
            if (!(child instanceof DataFolder)) continue;
            this.linkDataItemChildren((DataFolder)child);
        }
    }

    private void linkInputsToOperations() {
        for (OperationRecord operationRecord : this.operationRecords.values()) {
            for (InputType inputType : this.operationTypes.get(operationRecord).getInput()) {
                DataBean inputBean;
                String inputID = inputType.getData();
                if (inputID == null || (inputBean = this.dataBeans.get(inputID)) == null || inputBean.queryFeatures("/phenodata/").exists()) continue;
                operationRecord.addInput(this.createNameID(inputType.getName()), inputBean);
            }
        }
    }

    private void linkOperationsToOutputs() {
        for (DataBean dataBean : this.dataBeans.values()) {
            String operationId = this.dataTypes.get(dataBean).getResultOf();
            OperationRecord operationRecord = null;
            if (operationId != null) {
                operationRecord = this.operationRecords.get(operationId);
            }
            if (operationRecord == null) {
                operationRecord = OperationRecord.getUnkownOperationRecord();
            }
            dataBean.setOperationRecord(operationRecord);
        }
    }

    private void linkDataBeans() {
        for (DataBean dataBean : this.dataBeans.values()) {
            for (LinkType linkType : this.dataTypes.get(dataBean).getLink()) {
                try {
                    DataBean targetBean;
                    String targetID = linkType.getTarget();
                    if (targetID == null || (targetBean = this.dataBeans.get(targetID)) == null) continue;
                    dataBean.addLink(DataBean.Link.valueOf(linkType.getType()), targetBean);
                }
                catch (Exception e) {
                    logger.warn((Object)"could not add link", (Throwable)e);
                }
            }
        }
    }

    private DataItem getDataItem(String id) {
        DataItem dataItem = this.folders.get(id);
        if (dataItem != null) {
            return dataItem;
        }
        return this.dataBeans.get(id);
    }

    private NameID createNameID(NameType name) {
        return new NameID(name.getId(), name.getDisplayName(), name.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSourceCode(String sourceCodeFileName) throws ZipException, IOException {
        ZipFile zipFile = null;
        InputStream sourceCodeInputStream = null;
        StringWriter stringWriter = null;
        try {
            zipFile = new ZipFile(this.sessionFile);
            sourceCodeInputStream = zipFile.getInputStream(zipFile.getEntry(sourceCodeFileName));
            stringWriter = new StringWriter();
            IOUtils.copy(sourceCodeInputStream, (OutputStream)new WriterOutputStream((Writer)stringWriter));
            stringWriter.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeIfPossible(sourceCodeInputStream);
            IOUtils.closeIfPossible(stringWriter);
            if (zipFile != null) {
                zipFile.close();
            }
            throw throwable;
        }
        IOUtils.closeIfPossible(sourceCodeInputStream);
        IOUtils.closeIfPossible(stringWriter);
        if (zipFile != null) {
            zipFile.close();
        }
        return stringWriter.toString();
    }

    public void loadSession() throws ZipException, IOException, JAXBException, SAXException {
        this.parseMetadata();
        this.createFolders();
        this.createDataBeans();
        this.createOperations();
        this.linkOperationsToOutputs();
        this.linkDataItemChildren(this.dataManager.getRootFolder());
        this.linkDataBeans();
        this.linkInputsToOperations();
    }
}

