/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.serverfiles;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.LinkedList;

public class ServerFile
extends File {
    public static final String SERVER_SESSION_ROOT_FOLDER = "Sessions at server";
    private String name;
    private String url;
    private LinkedList<ServerFile> children = new LinkedList();
    private boolean isDirectory;
    private ServerFile parent;

    public ServerFile(String url) {
        super(url);
        this.url = url;
        this.isDirectory = url.endsWith("/");
        String p = url;
        this.name = this.isDirectory ? p.substring(p.substring(0, p.length() - 1).lastIndexOf("/") + 1, p.length() - 1) : p.substring(p.lastIndexOf("/") + 1, p.length());
    }

    public ServerFile(File dir, String filename) {
        this(ServerFile.concatenate(dir, filename));
    }

    private static String concatenate(File dir, String filename) {
        String dirString = dir.getPath();
        if (dirString.endsWith("/")) {
            dirString = dirString.substring(0, dirString.length() - 1);
        }
        return dirString + "/" + filename;
    }

    public void addChild(ServerFile child) {
        if (!this.isDirectory) {
            throw new UnsupportedOperationException("cannot add children if not a directory");
        }
        this.children.add(child);
        child.setParent(this);
    }

    @Override
    public boolean canExecute() {
        return false;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public int compareTo(File pathname) {
        if (pathname instanceof ServerFile) {
            return this.url.compareTo(((ServerFile)pathname).url);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean createNewFile() throws IOException {
        return false;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public void deleteOnExit() {
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ServerFile) {
            return this.url.equals(((ServerFile)obj).url);
        }
        return false;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public File getAbsoluteFile() {
        return this;
    }

    @Override
    public String getAbsolutePath() {
        return this.url;
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return this;
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.url;
    }

    @Override
    public long getFreeSpace() {
        return 0L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getParent() {
        return super.getParent();
    }

    @Override
    public File getParentFile() {
        return this.parent;
    }

    public void setParent(ServerFile parent) {
        this.parent = parent;
    }

    @Override
    public String getPath() {
        return this.url;
    }

    @Override
    public long getTotalSpace() {
        return 0L;
    }

    @Override
    public long getUsableSpace() {
        return 0L;
    }

    @Override
    public int hashCode() {
        return this.url.hashCode();
    }

    @Override
    public boolean isAbsolute() {
        return this.url.startsWith(SERVER_SESSION_ROOT_FOLDER);
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @Override
    public boolean isFile() {
        return !this.isDirectory;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public String[] list() {
        return this.list(null);
    }

    @Override
    public String[] list(FilenameFilter filter) {
        LinkedList<String> names = new LinkedList<String>();
        for (ServerFile child : this.children) {
            if (filter != null && !filter.accept(this, child.getName())) continue;
            names.add(child.getName());
        }
        return names.toArray(new String[0]);
    }

    @Override
    public File[] listFiles() {
        return this.children.toArray(new File[0]);
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        LinkedList<ServerFile> filtered = new LinkedList<ServerFile>();
        for (ServerFile child : this.children) {
            if (!filter.accept(child)) continue;
            filtered.add(child);
        }
        return filtered.toArray(new File[0]);
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        LinkedList<ServerFile> filtered = new LinkedList<ServerFile>();
        for (ServerFile child : this.children) {
            if (!filter.accept(this, child.getName())) continue;
            filtered.add(child);
        }
        return filtered.toArray(new File[0]);
    }

    @Override
    public boolean mkdir() {
        return false;
    }

    @Override
    public boolean mkdirs() {
        return false;
    }

    @Override
    public boolean renameTo(File dest) {
        return false;
    }

    @Override
    public boolean setExecutable(boolean executable) {
        return false;
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        return false;
    }

    @Override
    public boolean setLastModified(long time) {
        return false;
    }

    @Override
    public boolean setReadable(boolean readable) {
        return false;
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        return false;
    }

    @Override
    public boolean setReadOnly() {
        return false;
    }

    @Override
    public boolean setWritable(boolean writable) {
        return false;
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        return false;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public URI toURI() {
        try {
            return this.toURL().toURI();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return new URL(this.url);
    }
}

