/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.parameter.Parameter;
import java.math.BigDecimal;

public class DecimalParameter
extends Parameter {
    private Float minValue;
    private Float maxValue;
    private Float value;

    public DecimalParameter(String id, String displayName, String description, Float minValue, Float maxValue, Float initValue) throws IllegalArgumentException {
        super(id, displayName, description);
        this.minValue = minValue;
        this.maxValue = maxValue;
        if (initValue == null) {
            this.value = initValue;
            return;
        }
        if (maxValue.floatValue() < minValue.floatValue()) {
            throw new IllegalArgumentException("Minimum value for decimal parameter " + this.getID() + " cannot be bigger than the maximum value.");
        }
        if (initValue.floatValue() < minValue.floatValue() || initValue.floatValue() > maxValue.floatValue()) {
            throw new IllegalArgumentException("Initial value for decimal parameter " + this.getID() + " must be inside given limits.");
        }
        this.value = initValue;
    }

    public Float getMinValue() {
        return this.minValue;
    }

    public Float getMaxValue() {
        return this.maxValue;
    }

    public Float getDecimalValue() {
        return this.value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setMinValue(float newMinValue) throws IllegalArgumentException {
        if (newMinValue > this.maxValue.floatValue()) {
            throw new IllegalArgumentException("New minimum value for " + this.getID() + " cannot exceed current maximum value.");
        }
        this.minValue = Float.valueOf(newMinValue);
        if (this.value.floatValue() < this.minValue.floatValue()) {
            this.value = this.minValue;
        }
    }

    public void setMaxValue(float newMaxValue) throws IllegalArgumentException {
        if (newMaxValue < this.minValue.floatValue()) {
            throw new IllegalArgumentException("New maximum value for " + this.getID() + " cannot fall below current minimum value.");
        }
        this.maxValue = Float.valueOf(newMaxValue);
        if (this.value.floatValue() > this.maxValue.floatValue()) {
            this.value = this.maxValue;
        }
    }

    public void setDecimalValue(float newValue) throws IllegalArgumentException {
        if (newValue < this.minValue.floatValue() || newValue > this.maxValue.floatValue()) {
            throw new IllegalArgumentException("New value for decimal parameter " + this.getID() + " must be inside given limits.");
        }
        this.value = Float.valueOf(newValue);
    }

    @Override
    public void setValue(Object newValue) {
        if (newValue == null) {
            this.value = null;
        } else if (newValue instanceof Float) {
            this.value = (Float)newValue;
        } else if (newValue instanceof Double) {
            double doubleValue = (Double)newValue;
            this.value = Float.valueOf((float)doubleValue);
        } else {
            throw new IllegalArgumentException(newValue + " is an illegal " + "value for decimal parameter " + this.getID() + ".");
        }
    }

    @Override
    public boolean checkValidityOf(Object valueObject) {
        double doubleValue;
        float floatValue;
        if (valueObject == null) {
            return true;
        }
        if (valueObject instanceof Float && (floatValue = ((Float)valueObject).floatValue()) >= this.minValue.floatValue() && floatValue <= this.maxValue.floatValue()) {
            return true;
        }
        return valueObject instanceof Double && (doubleValue = ((Double)valueObject).doubleValue()) >= (double)this.minValue.floatValue() && doubleValue <= (double)this.maxValue.floatValue();
    }

    @Override
    public String toString() {
        return this.getID() + ": " + this.value;
    }

    @Override
    public String getValueAsJava() {
        return "" + this.value;
    }

    @Override
    public void parseValue(String stringValue) throws IllegalArgumentException {
        if (stringValue == null || stringValue.equals("")) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(Double.parseDouble(stringValue));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("cannot parse String value \"" + stringValue + "\"");
        }
    }

    @Override
    public String getValueAsString() {
        return this.value != null ? new BigDecimal(this.value.toString()).toPlainString() : "";
    }
}

