/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport.table;

import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.uif_lite.panel.SimpleInternalFrame;
import fi.csc.microarray.client.ToolBarComponentFactory;
import fi.csc.microarray.client.dataimport.ColumnType;
import fi.csc.microarray.client.dataimport.ImportScreen;
import fi.csc.microarray.client.dataimport.events.ChipCountChangeEvent;
import fi.csc.microarray.client.dataimport.events.ChipNumberChangedEvent;
import fi.csc.microarray.client.dataimport.events.ColumnTitlesChangedEvent;
import fi.csc.microarray.client.dataimport.events.ColumnTypeChangeListener;
import fi.csc.microarray.client.dataimport.events.ColumnTypeChangedEvent;
import fi.csc.microarray.client.dataimport.events.ConversionModelChangeListener;
import fi.csc.microarray.client.dataimport.events.DecimalSeparatorChangedEvent;
import fi.csc.microarray.client.dataimport.events.DelimiterChangedEvent;
import fi.csc.microarray.client.dataimport.events.FooterChangedEvent;
import fi.csc.microarray.client.dataimport.events.HeaderChangedEvent;
import fi.csc.microarray.client.dataimport.events.InputFileChangedEvent;
import fi.csc.microarray.client.dataimport.events.TitleRowChangedEvent;
import fi.csc.microarray.client.dataimport.table.ImportPreviewTable;
import fi.csc.microarray.client.dataimport.table.PanelTableHeaderRenderer;
import fi.csc.microarray.constants.VisualConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TableInternalFrame
extends SimpleInternalFrame
implements ActionListener,
ChangeListener,
ConversionModelChangeListener,
ColumnTypeChangeListener {
    private static final String NOT_ENOUGH_CHIPS_TOOLTIP = "Number of selections of this column type is bigger than chip count";
    private static final String CHIP_NUMBER_NOT_SET_TOOLTIP = "Select the chip number";
    private static final Dimension SPINNER_SIZE = new Dimension(90, 20);
    private JToolBar toolBarFirstStep;
    private JToolBar toolBarSecondStep;
    private ImportPreviewTable table;
    private ImportScreen screen;
    private JScrollPane tableScroller;
    private JButton toTopButton;
    private JButton toBottomButton;
    private JButton resetButtonFirstStep;
    private JToggleButton markHeaderButton;
    private JToggleButton markFooterButton;
    private JToggleButton markTitleButton;
    private List<JToggleButton> markHeaderFooterButtons;
    private JSpinner headerSpinner;
    private JSpinner footerSpinner;
    private JLabel showingColumnsLabel;
    private Map<JToggleButton, ColumnType> markColumnsButtons;
    private JButton resetButtonSecondStep;

    public TableInternalFrame(ImportScreen screen) {
        super("Import data");
        this.screen = screen;
    }

    public void initializeFirstStep() {
        this.updateTitle();
        this.screen.getConversionModel().setLimits(Integer.MAX_VALUE, 6);
        this.setToolBar(this.getToolbarFirstStep());
        this.setContent(this.getContentPanel());
        this.updateHilighter();
    }

    private void updateTitle() {
        if (this.screen.getCurrentStep() == ImportScreen.Step.FIRST) {
            this.setTitle("Select rows (" + this.screen.getConversionModel().getInputFileName() + ")");
        } else {
            this.setTitle("Select columns (" + this.screen.getConversionModel().getInputFileName() + ")");
        }
    }

    private JPanel getContentPanel() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)this.getShowingColumnsLabel(), "North");
        contentPanel.add((Component)this.getTableScroller(), "Center");
        return contentPanel;
    }

    private JLabel getShowingColumnsLabel() {
        if (this.showingColumnsLabel == null) {
            this.showingColumnsLabel = new JLabel();
            this.updateShowingColumnsLabel();
            return this.showingColumnsLabel;
        }
        return this.showingColumnsLabel;
    }

    public void updateShowingColumnsLabel() {
        if (this.screen.getCurrentStep() == ImportScreen.Step.FIRST) {
            int cols = this.screen.getConversionModel().getLimitedColumnCount() - 1;
            int colsTotal = this.screen.getConversionModel().getUnlimitedColumnCount() - 1;
            if (cols == -1 && colsTotal == -1) {
                cols = 0;
                colsTotal = 0;
            }
            this.showingColumnsLabel.setText("Showing columns " + cols + " of " + colsTotal);
        } else {
            int rows = this.screen.getConversionModel().getLimitedRowCount();
            int rowsTotal = this.screen.getConversionModel().getUnlimitedRowCount();
            this.showingColumnsLabel.setText("Showing rows " + rows + " of " + rowsTotal);
        }
    }

    public void initializeSecondStep() {
        this.updateTitle();
        this.screen.getConversionModel().setLimits(100, Integer.MAX_VALUE);
        this.setToolBar(this.getToolbarSecondStep());
        this.setContent(this.getContentPanel());
        this.updateHilighter();
    }

    private void updateHilighter() {
        boolean rowHilight = false;
        boolean columnHilight = false;
        if (this.screen.getCurrentStep() == ImportScreen.Step.FIRST) {
            rowHilight = this.markFooterButton.isSelected() || this.markHeaderButton.isSelected() || this.markTitleButton.isSelected();
        } else if (this.screen.getCurrentStep() == ImportScreen.Step.SECOND) {
            columnHilight = true;
        }
        this.table.setColumnHighlight(columnHilight);
        this.table.setRowHighlight(rowHilight);
    }

    private JToolBar getToolbarFirstStep() {
        if (this.toolBarFirstStep == null) {
            this.toolBarFirstStep = new JToolBar();
            this.toolBarFirstStep.setLayout(new GridBagLayout());
            this.toolBarFirstStep.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
            this.markHeaderButton = ToolBarComponentFactory.createToggleButton("Mark header", "/eclipse/import_header.png", true, true);
            this.markHeaderButton.addActionListener(this);
            this.markFooterButton = ToolBarComponentFactory.createToggleButton("Mark footer", "/eclipse/import_footer.png", true, true);
            this.markFooterButton.addActionListener(this);
            this.markTitleButton = ToolBarComponentFactory.createToggleButton("Mark title row", "/eclipse/import_title.png", true, true);
            this.markTitleButton.addActionListener(this);
            this.headerSpinner = ToolBarComponentFactory.createSpinner();
            this.headerSpinner.addChangeListener(this);
            this.headerSpinner.setEditor(new JSpinner.NumberEditor(this.headerSpinner, "0"));
            this.headerSpinner.setValue(0);
            this.headerSpinner.setPreferredSize(SPINNER_SIZE);
            this.footerSpinner = ToolBarComponentFactory.createSpinner();
            this.footerSpinner.addChangeListener(this);
            this.footerSpinner.setEditor(new JSpinner.NumberEditor(this.footerSpinner, "0"));
            this.footerSpinner.setValue(Integer.MAX_VALUE);
            this.footerSpinner.setPreferredSize(SPINNER_SIZE);
            this.resetButtonFirstStep = ToolBarComponentFactory.createButton("Reset", "/eclipse/import_reset.png", true, false);
            this.resetButtonFirstStep.addActionListener(this);
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 0.0;
            c.anchor = 17;
            c.fill = 3;
            this.toolBarFirstStep.add((Component)this.markHeaderButton, c);
            this.toolBarFirstStep.add((Component)this.headerSpinner, c);
            this.toolBarFirstStep.addSeparator();
            this.toolBarFirstStep.add((Component)this.markFooterButton, c);
            this.toolBarFirstStep.add((Component)this.footerSpinner, c);
            this.toolBarFirstStep.addSeparator();
            this.toolBarFirstStep.add((Component)this.markTitleButton, c);
            c.weightx = 1.0;
            c.fill = 1;
            this.toolBarFirstStep.add((Component)new JLabel(), c);
            c.weightx = 0.0;
            c.fill = 3;
            this.toolBarFirstStep.add((Component)this.resetButtonFirstStep, c);
            this.markHeaderFooterButtons = new ArrayList<JToggleButton>();
            this.markHeaderFooterButtons.add(this.markHeaderButton);
            this.markHeaderFooterButtons.add(this.markFooterButton);
            this.markHeaderFooterButtons.add(this.markTitleButton);
        }
        return this.toolBarFirstStep;
    }

    private JToolBar getToolbarSecondStep() {
        if (this.toolBarSecondStep == null) {
            this.toolBarSecondStep = new JToolBar();
            this.toolBarSecondStep.setLayout(new GridLayout(1, ColumnType.values().length));
            this.toolBarSecondStep.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
            this.markColumnsButtons = new HashMap<JToggleButton, ColumnType>();
            for (int i = 0; i < ColumnType.values().length; ++i) {
                if (ColumnType.values()[i].equals((Object)ColumnType.ROW_NUMBER)) continue;
                JToggleButton button = ToolBarComponentFactory.createToggleButton(ColumnType.values()[i].toString(), null, false, true);
                if (i == 0) {
                    button.setSelected(true);
                }
                button.addActionListener(this);
                this.markColumnsButtons.put(button, ColumnType.values()[i]);
                this.toolBarSecondStep.add(button);
            }
            this.resetButtonSecondStep = ToolBarComponentFactory.createButton("Reset", "/eclipse/import_reset.png", true, true);
            this.resetButtonSecondStep.addActionListener(this);
            this.toolBarSecondStep.add(this.resetButtonSecondStep);
            this.setToolBar(this.toolBarSecondStep);
        }
        return this.toolBarSecondStep;
    }

    private static void selectButton(JToggleButton selected, Collection<JToggleButton> buttons) {
        for (JToggleButton button : buttons) {
            if (button == selected) {
                button.setSelected(true);
                continue;
            }
            button.setSelected(false);
        }
    }

    public JScrollPane getTableScroller() {
        this.tableScroller = new JScrollPane((Component)((Object)this.getTable()));
        if (this.screen.getCurrentStep() == ImportScreen.Step.FIRST) {
            this.addCornerComponents();
        }
        return this.tableScroller;
    }

    public void addCornerComponents() {
        this.toTopButton = new JButton(VisualConstants.getIcon(VisualConstants.TO_TOP_ICON));
        this.toBottomButton = new JButton(VisualConstants.getIcon(VisualConstants.TO_BOTTOM_ICON));
        this.toTopButton.setToolTipText("Go to beginning of the table");
        this.toBottomButton.setToolTipText("Go to end of the table");
        this.toTopButton.addActionListener(this);
        this.toBottomButton.addActionListener(this);
        this.toTopButton.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 0, UIManager.getColor("ScrollBar.darkShadow")));
        this.toBottomButton.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, UIManager.getColor("ScrollBar.darkShadow")));
        this.tableScroller.setCorner("UPPER_RIGHT_CORNER", this.toTopButton);
        this.tableScroller.setCorner("LOWER_RIGHT_CORNER", this.toBottomButton);
        this.tableScroller.setHorizontalScrollBarPolicy(32);
        this.tableScroller.getHorizontalScrollBar().setEnabled(false);
    }

    public ImportPreviewTable getTable() {
        if (this.table == null) {
            this.table = new ImportPreviewTable(this.screen, this);
            this.table.setCellSelectionEnabled(false);
            this.screen.getConversionModel().addConversionChangeListener(this.table);
            return this.table;
        }
        return this.table;
    }

    public void updateAllChipCountComboBoxes() {
        int columnCount = this.screen.getColumnTypeManager().getColumnCount();
        for (int columnIndex = 1; columnIndex < columnCount; ++columnIndex) {
            this.updateChipCountComboBox(columnIndex);
        }
    }

    public void updateChipCountComboBox(int columnIndex) {
        Integer[] items;
        int chipCount = this.screen.getColumnTypeManager().getChipCount();
        Integer selectedItem = null;
        if (this.screen.getColumnTypeManager().getColumnType(columnIndex).equals((Object)ColumnType.UNUSED_LABEL) || this.screen.getColumnTypeManager().getColumnType(columnIndex).equals((Object)ColumnType.ANNOTATION_LABEL) || this.screen.getColumnTypeManager().getColumnType(columnIndex).equals((Object)ColumnType.IDENTIFIER_LABEL)) {
            items = new Integer[]{};
        } else {
            items = new Integer[chipCount];
            for (int chipNum = 1; chipNum <= chipCount; ++chipNum) {
                items[chipNum - 1] = chipNum;
                if (chipNum != this.screen.getColumnTypeManager().getColumnChipNumber(columnIndex)) continue;
                selectedItem = chipNum;
            }
        }
        DefaultComboBoxModel<Integer> model = new DefaultComboBoxModel<Integer>(items);
        model.setSelectedItem(selectedItem);
        this.table.getHeaderRenderer(columnIndex).getCombo().setModel(model);
        this.table.getHeaderRenderer(columnIndex).getCombo().setEnabled(model.getSize() > 0);
        this.table.getHeaderRenderer(columnIndex).update();
    }

    public void updateAllColumnTitleLabels() {
        for (int i = 1; i < this.table.getColumnCount(); ++i) {
            this.updateColumnTitleLabel(i);
        }
    }

    public void updateColumnTitleLabel(int columnIndex) {
        if (this.screen.getColumnTypeManager().getColumnCount() > columnIndex) {
            ColumnType type = this.screen.getColumnTypeManager().getColumnType(columnIndex);
            PanelTableHeaderRenderer head = this.table.getHeaderRenderer(columnIndex);
            head.setTypeText(type.toString());
            if (this.screen.getColumnTypeManager().getColumnType(columnIndex).equals((Object)ColumnType.IDENTIFIER_LABEL)) {
                if (this.screen.getColumnTypeManager().getCountOfType(ColumnType.IDENTIFIER_LABEL) > 1) {
                    head.setTypeColor(Color.RED);
                } else {
                    head.setTypeColor(Color.BLACK);
                }
            } else if (this.screen.getColumnTypeManager().isChipNumberSetProperly(columnIndex)) {
                head.setTypeColor(Color.BLACK);
                head.setTypeToolTipText("");
            } else {
                head.setTypeColor(Color.RED);
                if (this.screen.getColumnTypeManager().getChipCount() < this.screen.getColumnTypeManager().getCountOfType(type)) {
                    head.setTypeToolTipText(NOT_ENOUGH_CHIPS_TOOLTIP);
                } else {
                    head.setTypeToolTipText(CHIP_NUMBER_NOT_SET_TOOLTIP);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.screen.getCurrentStep() == ImportScreen.Step.FIRST) {
            if (e.getSource() == this.toTopButton) {
                this.tableScroller.getVerticalScrollBar().setValue(this.tableScroller.getVerticalScrollBar().getMinimum());
            } else if (e.getSource() == this.toBottomButton) {
                this.tableScroller.getVerticalScrollBar().setValue(this.tableScroller.getVerticalScrollBar().getMaximum());
            } else if (e.getSource() == this.markHeaderButton) {
                if (this.markHeaderButton.isSelected()) {
                    TableInternalFrame.selectButton(this.markHeaderButton, this.markHeaderFooterButtons);
                }
                this.updateHilighter();
            } else if (e.getSource() == this.markFooterButton) {
                if (this.markFooterButton.isSelected()) {
                    TableInternalFrame.selectButton(this.markFooterButton, this.markHeaderFooterButtons);
                }
                this.updateHilighter();
            } else if (e.getSource() == this.markTitleButton) {
                if (this.markTitleButton.isSelected()) {
                    TableInternalFrame.selectButton(this.markTitleButton, this.markHeaderFooterButtons);
                }
                this.updateHilighter();
            } else if (e.getSource() == this.resetButtonFirstStep) {
                this.screen.getConversionModel().setColumnTitleLine(-1);
                this.screen.getConversionModel().setHeaderEndsRow(-1);
                this.screen.getConversionModel().setFooterBeginsRow(this.screen.getConversionModel().getLimitedRowCount());
            }
        }
        if (this.screen.getCurrentStep() == ImportScreen.Step.SECOND) {
            if (this.markColumnsButtons != null && this.markColumnsButtons.containsKey(e.getSource())) {
                TableInternalFrame.selectButton((JToggleButton)e.getSource(), this.markColumnsButtons.keySet());
                this.updateHilighter();
            } else if (e.getSource() == this.resetButtonSecondStep) {
                this.screen.getColumnTypeManager().resetColumnTypes();
            }
        }
    }

    public boolean isInHeaderMarkingMode() {
        if (this.screen.getCurrentStep() == ImportScreen.Step.FIRST) {
            return this.markHeaderButton.isSelected();
        }
        return false;
    }

    public boolean isInFooterMarkingMode() {
        if (this.screen.getCurrentStep() == ImportScreen.Step.FIRST) {
            return this.markFooterButton.isSelected();
        }
        return false;
    }

    public boolean isInTitleMarkingMode() {
        if (this.screen.getCurrentStep() == ImportScreen.Step.FIRST) {
            return this.markTitleButton.isSelected();
        }
        return false;
    }

    public ColumnType getSelectedColumnType() {
        if (this.markColumnsButtons == null) {
            return null;
        }
        for (JToggleButton button : this.markColumnsButtons.keySet()) {
            if (!button.isSelected()) continue;
            return this.markColumnsButtons.get(button);
        }
        return null;
    }

    public void setFooterStartRow(int footer) {
        int header = Integer.parseInt(this.headerSpinner.getValue().toString());
        if (footer <= header) {
            footer = header + 1;
        } else if (this.table != null && footer > this.table.getRowCount() + 1) {
            footer = this.table.getRowCount() + 1;
        }
        this.footerSpinner.setValue(footer);
    }

    public void resetSpinners() {
        this.setHeaderEndRow(-1);
        this.setFooterStartRow(Integer.MAX_VALUE);
    }

    public void setHeaderEndRow(int header) {
        int footer = Integer.parseInt(this.footerSpinner.getValue().toString());
        if (header >= footer) {
            header = footer - 1;
        } else if (header < 0) {
            header = 0;
        }
        this.headerSpinner.setValue(header);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int footer;
        if (e.getSource() == this.headerSpinner) {
            int header = Integer.parseInt(this.headerSpinner.getValue().toString());
            if (header - 1 != this.screen.getConversionModel().getHeaderEnd()) {
                this.screen.getConversionModel().setHeaderEndsRow(header - 1);
            }
        } else if (e.getSource() == this.footerSpinner && (footer = Integer.parseInt(this.footerSpinner.getValue().toString())) - 1 != this.screen.getConversionModel().getFooterStart() && footer != Integer.MAX_VALUE) {
            this.screen.getConversionModel().setFooterBeginsRow(footer - 1);
        }
    }

    @Override
    public void decimalSeparatorChanged(DecimalSeparatorChangedEvent e) {
    }

    @Override
    public void delimiterChanged(DelimiterChangedEvent e) {
    }

    @Override
    public void footerChanged(FooterChangedEvent e) {
        if (e.getNewValue() == -1) {
            this.setFooterStartRow(this.table.getRowCount() + 1);
        } else {
            this.setFooterStartRow(e.getNewValue() + 1);
        }
    }

    @Override
    public void headerChanged(HeaderChangedEvent e) {
        this.setHeaderEndRow(e.getNewValue() + 1);
    }

    @Override
    public void titleRowChanged(TitleRowChangedEvent e) {
    }

    @Override
    public void chipNumberChanged(ChipNumberChangedEvent event) {
        this.updateChipCountComboBox(event.getColumnIndex());
        this.updateColumnTitleLabel(event.getColumnIndex());
    }

    @Override
    public void columnTypeChanged(ColumnTypeChangedEvent event) {
        this.updateColumnTitleLabel(event.getColumnIndex());
    }

    @Override
    public void chipCountChanged(ChipCountChangeEvent event) {
        this.updateAllChipCountComboBoxes();
        this.updateAllColumnTitleLabels();
    }

    @Override
    public void columnTitlesChanged(ColumnTitlesChangedEvent e) {
    }

    @Override
    public void inputFileChanged(InputFileChangedEvent e) {
        this.updateTitle();
    }
}

