/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import fi.csc.microarray.client.ServiceAccessor;
import fi.csc.microarray.client.operation.ToolModule;
import fi.csc.microarray.client.tasks.TaskExecutor;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.JMSFileBrokerClient;
import fi.csc.microarray.messaging.DescriptionMessageListener;
import fi.csc.microarray.messaging.JMSMessagingEndpoint;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.NodeBase;
import fi.csc.microarray.messaging.SourceMessageListener;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.admin.AdminAPI;
import fi.csc.microarray.messaging.auth.AuthenticationRequestListener;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.FeedbackMessage;
import fi.csc.microarray.module.Module;
import java.util.Collection;

public class RemoteServiceAccessor
implements ServiceAccessor {
    protected MessagingEndpoint endpoint;
    protected MessagingTopic requestTopic;
    protected TaskExecutor taskExecutor;
    protected FileBrokerClient filebrokerClient;
    private NodeBase nodeSupport = new NodeBase(){

        @Override
        public String getName() {
            return "client";
        }
    };
    private Collection<ToolModule> modules = null;

    @Override
    public void initialise(DataManager manager, AuthenticationRequestListener authenticationRequestListener) throws Exception {
        this.endpoint = new JMSMessagingEndpoint(this.nodeSupport, authenticationRequestListener);
        this.initialise(this.endpoint, manager, new JMSFileBrokerClient(this.endpoint.createTopic(Topics.Name.FILEBROKER_TOPIC, MessagingTopic.AccessMode.WRITE)));
    }

    public void initialise(MessagingEndpoint endpoint, DataManager manager, FileBrokerClient fileBrokerClient) throws Exception {
        this.endpoint = endpoint;
        this.requestTopic = endpoint.createTopic(Topics.Name.REQUEST_TOPIC, MessagingTopic.AccessMode.WRITE);
        this.filebrokerClient = fileBrokerClient;
        this.taskExecutor = new TaskExecutor(endpoint, manager);
    }

    @Override
    public TaskExecutor getTaskExecutor() {
        if (this.taskExecutor == null) {
            throw new IllegalStateException("initialise(...) must be called first");
        }
        return this.taskExecutor;
    }

    @Override
    public String checkRemoteServices() throws Exception {
        AdminAPI api = new AdminAPI(this.endpoint.createTopic(Topics.Name.ADMIN_TOPIC, MessagingTopic.AccessMode.READ_WRITE), null);
        if (api.areAllServicesUp(true)) {
            return "ok";
        }
        return "required services are not available (" + api.getErrorStatus() + ")";
    }

    @Override
    public String fetchDescriptions(Module module) throws Exception {
        DescriptionMessageListener descriptionListener = new DescriptionMessageListener(module.getServerModuleNames());
        this.requestTopic.sendReplyableMessage(new CommandMessage("describe"), descriptionListener);
        descriptionListener.waitForResponse();
        this.modules = descriptionListener.getModules();
        descriptionListener.cleanUp();
        return descriptionListener.getParseErrors();
    }

    @Override
    public Collection<ToolModule> getModules() {
        if (this.modules == null) {
            throw new IllegalStateException("fetchDescriptions(...) must be called first");
        }
        return this.modules;
    }

    @Override
    public void close() throws Exception {
        this.endpoint.close();
    }

    @Override
    public SourceMessageListener retrieveSourceCode(String id) throws Exception {
        SourceMessageListener sourceListener = new SourceMessageListener();
        CommandMessage commandMessage = new CommandMessage("get-source");
        commandMessage.addParameter(id);
        this.requestTopic.sendReplyableMessage(commandMessage, sourceListener);
        return sourceListener;
    }

    @Override
    public FileBrokerClient getFileBrokerClient() {
        return this.filebrokerClient;
    }

    @Override
    public void sendFeedbackMessage(FeedbackMessage message) throws Exception {
        MessagingTopic requestTopic = this.endpoint.createTopic(Topics.Name.FEEDBACK_TOPIC, MessagingTopic.AccessMode.WRITE);
        requestTopic.sendMessage(message);
    }

    @Override
    public boolean isStandalone() {
        return false;
    }
}

