/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.python;

import fi.csc.microarray.analyser.AnalysisJob;
import fi.csc.microarray.analyser.JobCancelledException;
import fi.csc.microarray.analyser.OnDiskAnalysisJobBase;
import fi.csc.microarray.analyser.ProcessPool;
import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.util.Exceptions;
import fi.csc.microarray.util.IOUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;

public class PythonAnalysisJob
extends OnDiskAnalysisJobBase {
    public static final String STRING_DELIMETER = "'";
    public static PythonParameterSecurityPolicy PARAMETER_SECURITY_POLICY = new PythonParameterSecurityPolicy();
    static final Logger logger = Logger.getLogger(PythonAnalysisJob.class);
    private CountDownLatch waitPythonLatch = new CountDownLatch(1);
    private ProcessPool processPool;
    private Process process;

    protected PythonAnalysisJob() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() throws JobCancelledException {
        List<String> parameterValues;
        this.cancelCheck();
        this.updateStateDetailToClient("initialising Python");
        ArrayList<BufferedReader> inputReaders = new ArrayList<BufferedReader>();
        inputReaders.add(new BufferedReader(new StringReader(this.analysis.getInitialiser())));
        logger.debug((Object)("job work dir: " + this.jobWorkDir.getPath()));
        inputReaders.add(new BufferedReader(new StringReader("import os\nos.chdir('" + this.jobWorkDir.getName() + "')\n")));
        int i = 0;
        try {
            parameterValues = this.inputMessage.getParameters(PARAMETER_SECURITY_POLICY, this.analysis);
        }
        catch (JobMessage.ParameterValidityException e) {
            this.outputMessage.setErrorMessage(e.getMessage());
            this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
            this.updateState(JobState.FAILED_USER_ERROR, "");
            return;
        }
        for (ToolDescription.ParameterDescription param : this.analysis.getParameters()) {
            String value = new String(parameterValues.get(i));
            String pythonSnippet = PythonAnalysisJob.transformVariable(param, value);
            logger.debug((Object)("added parameter (" + pythonSnippet + ")"));
            inputReaders.add(new BufferedReader(new StringReader(pythonSnippet)));
            ++i;
        }
        String script = (String)this.analysis.getImplementation();
        inputReaders.add(new BufferedReader(new StringReader(script)));
        inputReaders.add(new BufferedReader(new StringReader("print '" + SCRIPT_SUCCESSFUL_STRING + "'\n")));
        this.cancelCheck();
        logger.debug((Object)"getting a process.");
        try {
            this.process = this.processPool.getProcess();
        }
        catch (Exception e) {
            this.outputMessage.setErrorMessage("Starting Python failed.");
            this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
            this.updateState(JobState.ERROR, "");
            return;
        }
        boolean processAlive = false;
        try {
            this.process.exitValue();
        }
        catch (IllegalThreadStateException itse) {
            processAlive = true;
        }
        if (!processAlive) {
            this.outputMessage.setErrorMessage("Starting Python failed.");
            String output = "";
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            try {
                String line = reader.readLine();
                while (line != null) {
                    output = output + line + "\n";
                    line = reader.readLine();
                }
                reader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
                line = reader.readLine();
                while (line != null) {
                    output = output + line + "\n";
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                logger.warn((Object)"could not read output stream");
            }
            this.outputMessage.setOutputText("Python already finished.\n\n" + output);
            this.updateState(JobState.ERROR, "");
            return;
        }
        this.updateStateDetailToClient("running Python");
        this.cancelCheck();
        logger.debug((Object)"about to start the Python process monitor.");
        PythonProcessMonitor processMonitor = new PythonProcessMonitor();
        new Thread(processMonitor).start();
        StringBuilder inputStringBuilder = new StringBuilder();
        try {
            for (BufferedReader reader : inputReaders) {
                String line = reader.readLine();
                while (line != null) {
                    inputStringBuilder.append(line + "\n");
                    line = reader.readLine();
                }
            }
        }
        catch (IOException ioe) {
            logger.warn((Object)"creating Python input failed");
        }
        this.outputMessage.setSourceCode(inputStringBuilder.toString());
        logger.debug((Object)"writing the input to Python.");
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
            writer.write(inputStringBuilder.toString());
            writer.newLine();
            writer.flush();
            IOUtils.closeIfPossible(writer);
        }
        catch (IOException ioe) {
            logger.debug((Object)"writing input failed", (Throwable)ioe);
        }
        finally {
            IOUtils.closeIfPossible(writer);
        }
        this.cancelCheck();
        logger.debug((Object)"waiting for the script to finish.");
        try {
            this.waitPythonLatch.await();
        }
        catch (InterruptedException e) {
            this.outputMessage.setErrorMessage("Running Python was interrupted.");
            this.outputMessage.setOutputText(Exceptions.getStackTrace(e));
            this.updateState(JobState.ERROR, "");
            return;
        }
        this.cancelCheck();
        logger.debug((Object)("done waiting for " + this.analysis.getID() + ", state is " + (Object)((Object)this.getState())));
        String output = processMonitor.getOutput();
        this.outputMessage.setOutputText(output);
        switch (this.getState()) {
            case RUNNING: {
                this.outputMessage.setErrorMessage("Python did not finish before timeout.");
                this.updateState(JobState.TIMEOUT, "");
                return;
            }
            case COMPLETED: {
                this.updateState(JobState.RUNNING, "Python script finished successfully");
                this.updateStateDetailToClient("Python script finished successfully");
                return;
            }
            case FAILED: {
                if (this.outputMessage.getErrorMessage() == null || this.outputMessage.getErrorMessage().equals("")) {
                    this.outputMessage.setErrorMessage("Running Python script failed.");
                }
                return;
            }
            case FAILED_USER_ERROR: {
                return;
            }
            case ERROR: {
                this.outputMessage.setErrorMessage("Reading Python output failed.");
                return;
            }
        }
        throw new IllegalStateException("Illegal job state: " + (Object)((Object)this.getState()));
    }

    @Override
    protected void preExecute() throws JobCancelledException {
        super.preExecute();
    }

    @Override
    protected void postExecute() throws JobCancelledException {
        super.postExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanUp() {
        try {
            if (this.process != null) {
                this.processPool.releaseProcess(this.process, false);
            }
        }
        catch (Exception e) {
            logger.error((Object)"error when releasing process. ", (Throwable)e);
        }
        finally {
            super.cleanUp();
        }
    }

    public static String transformVariable(ToolDescription.ParameterDescription param, String value) {
        if (!param.isNumeric()) {
            value = STRING_DELIMETER + value + STRING_DELIMETER;
        }
        if (param.isNumeric() && value.trim().isEmpty()) {
            value = "float('NaN')";
        }
        String name = param.getName();
        name = name.replaceAll(" ", "_");
        return name + " = " + value;
    }

    @Override
    protected void cancelRequested() {
        this.waitPythonLatch.countDown();
    }

    public void setProcessPool(ProcessPool processPool) {
        this.processPool = processPool;
    }

    private class PythonProcessMonitor
    implements Runnable {
        private ArrayList<String> outputLines;

        private PythonProcessMonitor() {
        }

        @Override
        public void run() {
            logger.debug((Object)"Python process monitor started.");
            this.outputLines = new ArrayList();
            BufferedReader reader = new BufferedReader(new InputStreamReader(PythonAnalysisJob.this.process.getInputStream()));
            boolean readMore = true;
            try {
                String line = reader.readLine();
                while (readMore) {
                    if (line == null || line.contains(AnalysisJob.SCRIPT_FAILED_STRING)) {
                        PythonAnalysisJob.this.updateState(JobState.FAILED, "Python script failed");
                        readMore = false;
                    } else if (line.contains(AnalysisJob.SCRIPT_SUCCESSFUL_STRING)) {
                        PythonAnalysisJob.this.updateState(JobState.COMPLETED, "Python script finished successfully");
                        readMore = false;
                    } else {
                        this.outputLines.add(line);
                    }
                    line = reader.readLine();
                }
                if (PythonAnalysisJob.this.getState() == JobState.FAILED) {
                    int errorLineNumber = -1;
                    for (int i = this.outputLines.size(); i > 0 && errorLineNumber == -1; --i) {
                        if (!this.outputLines.get(i - 1).startsWith("Error")) continue;
                        errorLineNumber = i - 1;
                    }
                    if (errorLineNumber != -1) {
                        String errorMessage = "";
                        errorMessage = errorMessage + this.outputLines.get(errorLineNumber).substring("Error".length()) + "\n";
                        for (int i = errorLineNumber + 1; i < this.outputLines.size(); ++i) {
                            errorMessage = errorMessage + this.outputLines.get(i) + "\n";
                        }
                        errorMessage = errorMessage.substring(0, errorMessage.lastIndexOf("\n"));
                        if ((errorMessage = errorMessage.trim()).contains("CHIPSTER-NOTE:")) {
                            errorMessage = errorMessage.substring(errorMessage.indexOf("CHIPSTER-NOTE:") + "CHIPSTER-NOTE:".length());
                            errorMessage = errorMessage.trim();
                            PythonAnalysisJob.this.updateState(JobState.FAILED_USER_ERROR, "");
                        }
                        PythonAnalysisJob.this.outputMessage.setErrorMessage(errorMessage);
                    }
                }
            }
            catch (IOException e) {
                logger.debug((Object)"error in monitoring Python process.");
                PythonAnalysisJob.this.updateState(JobState.ERROR, "reading Python output failed.");
            }
            PythonAnalysisJob.this.waitPythonLatch.countDown();
        }

        public String getOutput() {
            StringBuilder output = new StringBuilder();
            for (String line : this.outputLines) {
                output.append(line + "\n");
            }
            return output.toString();
        }
    }

    public static class PythonParameterSecurityPolicy
    implements JobMessage.ParameterSecurityPolicy {
        private static final int MAX_VALUE_LENGTH = 1000;
        public static String NUMERIC_VALUE_PATTERN = "-?\\d*\\.?\\d*";
        public static String TEXT_VALUE_PATTERN = "[\\w+\\-_:\\.,*() ]*";

        @Override
        public boolean isValueValid(String value, ToolDescription.ParameterDescription parameterDescription) {
            if (value.length() > 1000) {
                return false;
            }
            if (parameterDescription.isNumeric()) {
                return value.matches(NUMERIC_VALUE_PATTERN);
            }
            if (value.contains(PythonAnalysisJob.STRING_DELIMETER)) {
                return false;
            }
            return value.matches(TEXT_VALUE_PATTERN);
        }
    }
}

