/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.emboss;

import fi.csc.microarray.analyser.emboss.ACDDescription;
import fi.csc.microarray.analyser.emboss.ACDParameter;
import fi.csc.microarray.analyser.emboss.ACDToSADL;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLParser;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public class ACDToSADLTest {
    private static String path = "src/test/resources/";

    public static ACDDescription getTestDescription(String appName) {
        ACDDescription acd = new ACDDescription(new File(path + appName + ".acd"));
        return acd;
    }

    @Test
    public void testACDToSADL() {
        ACDDescription acd = ACDToSADLTest.getTestDescription("water");
        SADLDescription sadl = ACDToSADL.convert(acd, "water.acd");
        Assert.assertEquals((long)sadl.parameters().size(), (long)3L);
        Assert.assertEquals((long)sadl.inputs().size(), (long)2L);
        Assert.assertEquals((long)sadl.outputs().size(), (long)1L);
        Assert.assertEquals((Object)sadl.parameters().get(0).getFrom(), (Object)"0.0");
        Assert.assertEquals((Object)sadl.parameters().get(0).getTo(), (Object)"100.0");
        ACDParameter acdParam = new ACDParameter("list", "param", "", null);
        String[] titles = new String[]{"all", "your", "base"};
        String[] values = new String[]{"a", "y", "b"};
        acdParam.setList(titles, values);
        acdParam.setAttribute("information", "List param");
        acdParam.setAttribute("help", "Long description");
        SADLDescription.Parameter sadlParam = ACDToSADL.SADLParameterCreator.createParameter(acdParam);
        Assert.assertEquals((Object)sadlParam.getName().getDisplayName(), (Object)"List param");
        Assert.assertEquals((Object)sadlParam.getComment(), (Object)"Long description");
        Assert.assertEquals((Object)sadlParam.getSelectionOptions()[0].toString(), (Object)SADLDescription.Name.createName("a", "all").toString());
        acd = ACDToSADLTest.getTestDescription("complex");
        sadl = ACDToSADL.convert(acd, "complex.acd");
        Assert.assertEquals((long)acd.getParameter("multiple").getDefaults().length, (long)3L);
        for (SADLDescription.Parameter parameter : sadl.parameters()) {
            if (!parameter.getName().getID().equals("multiple")) continue;
            Assert.assertEquals((Object)parameter.getFrom(), (Object)"1");
            Assert.assertEquals((Object)parameter.getTo(), (Object)"4");
            Assert.assertEquals((long)parameter.getDefaultValues().length, (long)3L);
            Assert.assertEquals((Object)parameter.getDefaultValues()[0], (Object)"b");
            Assert.assertEquals((Object)parameter.getDefaultValues()[1], (Object)"o");
            Assert.assertEquals((Object)parameter.getDefaultValues()[2], (Object)"g");
        }
        try {
            sadl = new SADLParser().parse(sadl.toString());
            for (SADLDescription.Parameter parameter : sadl.parameters()) {
                if (!parameter.getName().getID().equals("multiple")) continue;
                Assert.assertEquals((Object)parameter.getFrom(), (Object)"1");
                Assert.assertEquals((Object)parameter.getTo(), (Object)"4");
                Assert.assertEquals((long)parameter.getDefaultValues().length, (long)3L);
                Assert.assertEquals((Object)parameter.getDefaultValues()[0], (Object)"b");
                Assert.assertEquals((Object)parameter.getDefaultValues()[1], (Object)"o");
                Assert.assertEquals((Object)parameter.getDefaultValues()[2], (Object)"g");
            }
        }
        catch (SADLParser.ParseException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        ACDToSADLTest test = new ACDToSADLTest();
        test.testACDToSADL();
    }
}

