/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.emboss;

import fi.csc.microarray.analyser.emboss.ACDDescription;
import fi.csc.microarray.analyser.emboss.ACDParameter;
import java.io.File;
import java.util.LinkedHashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ACDDescriptionTest {
    ACDDescription acd;
    String path = "src/test/resources/";

    @Before
    public void setUp() {
        this.acd = new ACDDescription(new File(this.path + "emma.acd"));
    }

    @Test
    public void testACDDescription() {
        Assert.assertEquals((Object)this.acd.getName(), (Object)"emma");
        Assert.assertEquals((Object)this.acd.getDescription(), (Object)"Multiple sequence alignment (ClustalW wrapper)");
        Assert.assertEquals((long)this.acd.getGroups().size(), (long)1L);
        Assert.assertEquals((Object)this.acd.getGroups().get(0), (Object)"Alignment:Multiple");
        Assert.assertEquals((long)this.acd.getParameters("input", null, false).size(), (long)5L);
        Assert.assertEquals((long)this.acd.getParameters("input", null, true).size(), (long)11L);
        Assert.assertEquals((long)this.acd.getParameters("input", "matrixsection", false).size(), (long)3L);
        Assert.assertEquals((long)this.acd.getParameters("additional", null, true).size(), (long)15L);
        Assert.assertEquals((Object)this.acd.getParameter("maxdiv").getAttribute("default"), (Object)"30");
        Assert.assertEquals((Object)this.acd.getParameter("dendoutfile").getAttribute("extension"), (Object)"dnd");
        Assert.assertEquals((long)this.acd.getParameter("dnamatrix").getList().size(), (long)3L);
        Assert.assertFalse((boolean)this.acd.getParameter("maxdiv").isRequired());
        Assert.assertTrue((boolean)this.acd.getParameter("maxdiv").isAdditional());
        Assert.assertTrue((boolean)this.acd.getParameter("sequence").isRequired());
        Assert.assertFalse((boolean)this.acd.getParameter("sequence").isAdditional());
        Assert.assertFalse((boolean)this.acd.getParameter("sequence").isAdvanced());
        Assert.assertTrue((boolean)this.acd.getParameter("pwgapopen").validate("0.1"));
        Assert.assertFalse((boolean)this.acd.getParameter("pwgapopen").validate("-0.1"));
    }

    @Test
    public void testACDParameter() {
        ACDParameter param = new ACDParameter("integer", "param", "", null);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("foo", "n");
        map.put("bar", "21");
        Assert.assertEquals((Object)ACDParameter.resolveExp("$(foo)", map), (Object)"false");
        Assert.assertEquals((Object)ACDParameter.resolveExp("@(!$(foo))", map), (Object)"true");
        Assert.assertEquals((Object)ACDParameter.resolveExp("@($(bar)+2)", map), (Object)"23");
        param = new ACDParameter("boolean", "param", "", null);
        Assert.assertEquals((Object)param.normalize("yes"), (Object)"Y");
        Assert.assertEquals((Object)param.normalize("n"), (Object)"N");
        Assert.assertFalse((boolean)param.normalize("taip").equals("Y"));
        param = new ACDParameter("selection", "param", "", null);
        Assert.assertEquals((Object)param.normalize("1,2,3"), (Object)"1;2;3");
        param.setAttribute("delimiter", "-");
        Assert.assertEquals((Object)param.normalize("1,2,3"), (Object)"1-2-3");
        param = new ACDParameter("array", "param", "", null);
        Assert.assertTrue((boolean)param.validate("1.5,1.0,0.5"));
        Assert.assertTrue((boolean)param.validate("1.5 1.0 2"));
        Assert.assertFalse((boolean)param.validate("1.5 1.0 a"));
        param = new ACDParameter("boolean", "param", "", null);
        Assert.assertTrue((boolean)param.validate("true"));
        Assert.assertTrue((boolean)param.validate("Y"));
        Assert.assertTrue((boolean)param.validate("0"));
        Assert.assertFalse((boolean)param.validate("X"));
        Assert.assertFalse((boolean)param.validate("24"));
        param = new ACDParameter("float", "param", "", null);
        param.setAttribute("minimum", "-2.2");
        param.setAttribute("maximum", "2");
        Assert.assertTrue((boolean)param.validate("-2.2"));
        Assert.assertFalse((boolean)param.validate("-2.3"));
        Assert.assertFalse((boolean)param.validate("2.01"));
        param = new ACDParameter("integer", "param", "", null);
        param.setAttribute("minimum", "-7");
        param.setAttribute("maximum", "23");
        Assert.assertTrue((boolean)param.validate("23"));
        Assert.assertTrue((boolean)param.validate("-7"));
        Assert.assertFalse((boolean)param.validate("-2.3"));
        Assert.assertFalse((boolean)param.validate("24"));
        param = this.acd.getParameter("pwmatrix");
        Assert.assertTrue((boolean)param.validate("o"));
        Assert.assertFalse((boolean)param.validate("x"));
        param = new ACDParameter("list", "param", "", null);
        String[] titles = new String[]{"all", "your", "base"};
        String[] values = new String[]{"a", "y", "b"};
        param.setList(titles, values);
        param.setAttribute("maximum", "2");
        Assert.assertTrue((boolean)param.validate("y"));
        Assert.assertTrue((boolean)param.validate("b,y"));
        Assert.assertFalse((boolean)param.validate("b,x"));
        Assert.assertFalse((boolean)param.validate("b,y,a"));
    }

    public static void main(String[] args) throws Exception {
        ACDDescriptionTest test = new ACDDescriptionTest();
        test.setUp();
        test.testACDDescription();
        test.testACDParameter();
    }
}

