/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.test.BaseTest;

public class TestAutoAST
extends BaseTest {
    protected boolean debug = false;

    public void testTokenList() throws Exception {
        String string = "grammar foo;\noptions {output=AST;}\na : ID INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("foo.g", string, "fooParser", "fooLexer", "a", "abc 34", this.debug);
        TestAutoAST.assertEquals((String)"abc 34\n", (String)string2);
    }

    public void testTokenListInSingleAltBlock() throws Exception {
        String string = "grammar foo;\noptions {output=AST;}\na : (ID INT) ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("foo.g", string, "fooParser", "fooLexer", "a", "abc 34", this.debug);
        TestAutoAST.assertEquals((String)"abc 34\n", (String)string2);
    }

    public void testSimpleRootAtOuterLevel() throws Exception {
        String string = "grammar foo;\noptions {output=AST;}\na : ID^ INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("foo.g", string, "fooParser", "fooLexer", "a", "abc 34", this.debug);
        TestAutoAST.assertEquals((String)"(abc 34)\n", (String)string2);
    }

    public void testSimpleRootAtOuterLevelReverse() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : INT ID^ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "34 abc", this.debug);
        TestAutoAST.assertEquals((String)"(abc 34)\n", (String)string2);
    }

    public void testBang() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT! ID! INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc 34 dag 4532", this.debug);
        TestAutoAST.assertEquals((String)"abc 4532\n", (String)string2);
    }

    public void testOptionalThenRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ( ID INT )? ID^ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a 1 b", this.debug);
        TestAutoAST.assertEquals((String)"(b a 1)\n", (String)string2);
    }

    public void testLabeledStringRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : v='void'^ ID ';' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "void foo;", this.debug);
        TestAutoAST.assertEquals((String)"(void foo ;)\n", (String)string2);
    }

    public void testWildcard() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : v='void'^ . ';' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "void foo;", this.debug);
        TestAutoAST.assertEquals((String)"(void foo ;)\n", (String)string2);
    }

    public void testWildcardRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : v='void' .^ ';' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "void foo;", this.debug);
        TestAutoAST.assertEquals((String)"(foo void ;)\n", (String)string2);
    }

    public void testRootRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID^ INT^ ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a 34 c", this.debug);
        TestAutoAST.assertEquals((String)"(34 a c)\n", (String)string2);
    }

    public void testRootRoot2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT^ ID^ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a 34 c", this.debug);
        TestAutoAST.assertEquals((String)"(c (34 a))\n", (String)string2);
    }

    public void testRootThenRootInLoop() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID^ (INT '*'^ ID)+ ;\nID  : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a 34 * b 9 * c", this.debug);
        TestAutoAST.assertEquals((String)"(* (* (a 34) b 9) c)\n", (String)string2);
    }

    public void testNestedSubrule() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : 'void' (({;}ID|INT) ID | 'null' ) ';' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "void a b;", this.debug);
        TestAutoAST.assertEquals((String)"void a b ;\n", (String)string2);
    }

    public void testInvokeRule() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na  : type ID ;\ntype : {;}'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "int a", this.debug);
        TestAutoAST.assertEquals((String)"int a\n", (String)string2);
    }

    public void testInvokeRuleAsRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na  : type^ ID ;\ntype : {;}'int' | 'float' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "int a", this.debug);
        TestAutoAST.assertEquals((String)"(int a)\n", (String)string2);
    }

    public void testRuleRootInLoop() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID ('+'^ ID)* ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a+b+c+d", this.debug);
        TestAutoAST.assertEquals((String)"(+ (+ (+ a b) c) d)\n", (String)string2);
    }

    public void testRuleInvocationRuleRootInLoop() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID (op^ ID)* ;\nop : {;}'+' | '-' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a+b+c-d", this.debug);
        TestAutoAST.assertEquals((String)"(- (+ (+ a b) c) d)\n", (String)string2);
    }

    public void testTailRecursion() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\ns : a ;\na : atom ('exp'^ a)? ;\natom : INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "s", "3 exp 4 exp 5", this.debug);
        TestAutoAST.assertEquals((String)"(exp 3 (exp 4 5))\n", (String)string2);
    }

    public void testSet() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID|INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc", this.debug);
        TestAutoAST.assertEquals((String)"abc\n", (String)string2);
    }

    public void testSetRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ('+' | '-')^ ID ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "+abc", this.debug);
        TestAutoAST.assertEquals((String)"(+ abc)\n", (String)string2);
    }

    public void testSetAsRuleRootInLoop() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID (('+'|'-')^ ID)* ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a+b-c", this.debug);
        TestAutoAST.assertEquals((String)"(- (+ a b) c)\n", (String)string2);
    }

    public void testNotSet() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ~ID '+' INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "34+2", this.debug);
        TestAutoAST.assertEquals((String)"34 + 2\n", (String)string2);
    }

    public void testNotSetRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ~'+'^ INT ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "34 55", this.debug);
        TestAutoAST.assertEquals((String)"(34 55)\n", (String)string2);
    }

    public void testNotSetRuleRootInLoop() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : INT (~INT^ INT)* ;\nblort : '+' ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "3+4+5", this.debug);
        TestAutoAST.assertEquals((String)"(+ (+ 3 4) 5)\n", (String)string2);
    }

    public void testTokenLabelReuse() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : id=ID id=ID {System.out.print(\"2nd id=\"+$id.text+';');} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b", this.debug);
        TestAutoAST.assertEquals((String)"2nd id=b;a b\n", (String)string2);
    }

    public void testTokenLabelReuse2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : id=ID id=ID^ {System.out.print(\"2nd id=\"+$id.text+';');} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b", this.debug);
        TestAutoAST.assertEquals((String)"2nd id=b;(b a)\n", (String)string2);
    }

    public void testTokenListLabelReuse() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ids+=ID ids+=ID {System.out.print(\"id list=\"+$ids+';');} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b", this.debug);
        String string3 = "id list=[[@0,0:0='a',<4>,1:0], [@2,2:2='b',<4>,1:2]];a b\n";
        TestAutoAST.assertEquals((String)string3, (String)string2);
    }

    public void testTokenListLabelReuse2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ids+=ID^ ids+=ID {System.out.print(\"id list=\"+$ids+';');} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b", this.debug);
        String string3 = "id list=[[@0,0:0='a',<4>,1:0], [@2,2:2='b',<4>,1:2]];(a b)\n";
        TestAutoAST.assertEquals((String)string3, (String)string2);
    }

    public void testTokenListLabelRuleRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : id+=ID^ ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a", this.debug);
        TestAutoAST.assertEquals((String)"a\n", (String)string2);
    }

    public void testTokenListLabelBang() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : id+=ID! ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a", this.debug);
        TestAutoAST.assertEquals((String)"nil\n", (String)string2);
    }

    public void testRuleListLabel() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : x+=b x+=b {Tree t=(Tree)$x.get(1);System.out.print(\"2nd x=\"+t.toStringTree()+';');} ;\nb : ID;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b", this.debug);
        TestAutoAST.assertEquals((String)"2nd x=b;a b\n", (String)string2);
    }

    public void testRuleListLabelRuleRoot() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ( x+=b^ )+ {System.out.print(\"x=\"+((CommonTree)$x.get(1)).toStringTree()+';');} ;\nb : ID;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b", this.debug);
        TestAutoAST.assertEquals((String)"x=(b a);(b a)\n", (String)string2);
    }

    public void testRuleListLabelBang() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : x+=b! x+=b {System.out.print(\"1st x=\"+((CommonTree)$x.get(0)).toStringTree()+';');} ;\nb : ID;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b", this.debug);
        TestAutoAST.assertEquals((String)"1st x=a;b\n", (String)string2);
    }

    public void testComplicatedMelange() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : A b=B b=B c+=C c+=C D {$D.text;} ;\nA : 'a' ;\nB : 'b' ;\nC : 'c' ;\nD : 'd' ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a b b c c d", this.debug);
        TestAutoAST.assertEquals((String)"a b b c c d\n", (String)string2);
    }

    public void testReturnValueWithAST() throws Exception {
        String string = "grammar foo;\noptions {output=AST;}\na : ID b {System.out.println($b.i);} ;\nb returns [int i] : INT {$i=Integer.parseInt($INT.text);} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("foo.g", string, "fooParser", "fooLexer", "a", "abc 34", this.debug);
        TestAutoAST.assertEquals((String)"34\nabc 34\n", (String)string2);
    }

    public void testSetLoop() throws Exception {
        String string = "grammar T;\noptions { output=AST; }\nr : (INT|ID)+ ; \nID : 'a'..'z' + ;\nINT : '0'..'9' +;\nWS: (' ' | '\\n' | '\\t')+ {$channel = HIDDEN;};\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "r", "abc 34 d", this.debug);
        TestAutoAST.assertEquals((String)"abc 34 d\n", (String)string2);
    }

    public void _test() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na :  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abc 34", this.debug);
        TestAutoAST.assertEquals((String)"\n", (String)string2);
    }
}

